/* pkcs12.h */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#ifndef HEADER_PKCS12_H
#define HEADER_PKCS12_H


#include "bio.h"
#include "x509.h"

#ifdef __cplusplus
extern "C" {
#endif

#define PKCS12_LIB_NAME	"PKCS12 library"

/* Compatability macros.
 * In case anyone is interested this lot is intended to allow the stuff
 * to be compiled under three versions of SSLeay/OpenSSL: SSLeay 0.9.0x
 * OpenSSL 0.9.1c, OpenSSL 0.9.2. What we largely do is do things the
 * 0.9.2 way and then add extra #defines for the older ways which will
 * typically discard a parameter or use something else.
 */

#ifdef IS_SEQUENCE
#define VERSION_HEADER "OpenSSL 0.9.2"
#define i2d_ASN1_SEQ__compat(a, b, c, d, e) \
				i2d_ASN1_SET(a, b, c, d, e, IS_SEQUENCE)
#else
#define i2d_ASN1_SEQ__compat(a, b, c, d, e) i2d_ASN1_SET(a, b, c, d, e)
#endif

#ifdef OPENSSL_VERSION_NUMBER 

#ifndef VERSION_HEADER
#define VERSION_HEADER "OpenSSL 0.9.1c"
#endif

#define PKCS12_ASN1_new() ASN1_CTX c

#define M_ASN1_D2I_get_IMP_set_opt__compat(a, d2i, free_func, imp) \
		M_ASN1_D2I_get_IMP_set_opt(a, d2i, free_func, imp)

#define d2i_ASN1_SET__compat(a,b,c,d,free_func,e,f) \
				d2i_ASN1_SET(a,b,c,d,free_func,e,f)

#define M_ASN1_D2I_get_EXP_set_opt__compat(a, b, free_func, c, d) \
			M_ASN1_D2I_get_EXP_set_opt(a, b, free_func, c, d)

#define M_ASN1_D2I_get_set_opt__compat(a, b, func_free) \
				M_ASN1_D2I_get_set_opt(a, b, func_free)



#else


#define VERSION_HEADER "SSLeay 0.9.0b or earlier"

#define PKCS12_ASN1_new() /**/

#define M_ASN1_D2I_get_IMP_set_opt__compat(a, d2i, free_func, imp) \
		M_ASN1_D2I_get_IMP_set_opt(a, d2i, imp)

#define d2i_ASN1_SET__compat(a,b,c,d,free_func,e,f) \
				d2i_ASN1_SET(a,b,c,d,e,f)

#define M_ASN1_D2I_get_EXP_set_opt__compat(a, b, free_func, c, d) \
			M_ASN1_D2I_get_EXP_set_opt(a, b, c, d)

#define M_ASN1_D2I_get_set_opt__compat(a, b, func_free) \
				M_ASN1_D2I_get_set_opt(a, b)

/* Object creation bug work around */
#define OBJ_HACK

#endif

#ifndef M_ASN1_I2D_len_EXP_SEQUENCE_opt
#define M_ASN1_I2D_len_EXP_SEQUENCE_opt M_ASN1_I2D_len_EXP_set_opt
#endif

#ifndef M_ASN1_I2D_put_EXP_SEQUENCE_opt
#define M_ASN1_I2D_put_EXP_SEQUENCE_opt M_ASN1_I2D_put_EXP_set_opt
#endif

#ifndef M_ASN1_I2D_len_IMP_SET_opt 
#define M_ASN1_I2D_len_IMP_SET_opt M_ASN1_I2D_len_IMP_set_opt
#endif

#ifndef M_ASN1_I2D_put_IMP_SET_opt 
#define M_ASN1_I2D_put_IMP_SET_opt M_ASN1_I2D_put_IMP_set_opt
#endif

/* End of compatability macros */

#define PKCS12_KEY_ID	1
#define PKCS12_IV_ID	2
#define PKCS12_MAC_ID	3

#define PKCS12_MAC_KEY_LENGTH 20

#define PKCS12_SALT_LEN	8

/* External definitions */

#ifdef _WINDOWS
#ifdef WIN32
#define EXTERN __declspec( dllexport )
#else
/* Win 16 ... untested */
#define EXTERN _export _far _pascal
#endif
#else
/* Everything else */
#define EXTERN /**/
#endif

/* Uncomment out next line for unicode password and names, otherwise ASCII */

/*#define PBE_UNICODE*/

#ifdef PBE_UNICODE
#define PKCS12_key_gen PKCS12_key_gen_uni
#define PKCS12_add_friendlyname PKCS12_add_friendlyname_uni
#else
#define PKCS12_key_gen PKCS12_key_gen_asc
#define PKCS12_add_friendlyname PKCS12_add_friendlyname_asc
#endif

/* New objects */

#define NID_pbe_WithSHA1And128BitRC4		0
#define NID_pbe_WithSHA1And40BitRC4		1
#define NID_pbe_WithSHA1And3_Key_TripleDES_CBC	2
#define NID_pbe_WithSHA1And2_Key_TripleDES_CBC	3
#define NID_pbe_WithSHA1And128BitRC2_CBC	4
#define NID_pbe_WithSHA1And40BitRC2_CBC		5
#define NID_keyBag				6
#define NID_pkcs8ShroudedKeyBag			7
#define NID_certBag				8
#define NID_crlBag				9
#define NID_secretBag				10
#define NID_safeContentsBag			11
#define	NID_friendlyName			12
#define	NID_localKeyID				13
#define	NID_x509Certificate			14
#define	NID_sdsiCertificate			15
#define	NID_x509Crl				16

/* MS key usage constants */

#define KEY_EX	0x10
#define KEY_SIG 0x80

/* Various ASN1 macros */

#ifndef M_ASN1_D2I_get_set_opt
#define M_ASN1_D2I_get_set_opt(r,func) \
 	if ((c.slen != 0) && (M_ASN1_next == (V_ASN1_UNIVERSAL| \
 		V_ASN1_CONSTRUCTED|V_ASN1_SET)))\
 		{ M_ASN1_D2I_get_set(r,func); }
#endif
 
#ifndef M_ASN1_I2D_len_SET_opt
#define M_ASN1_I2D_len_SET_opt(a,f) \
 		if (a != NULL) M_ASN1_I2D_len_SET(a,f);
#endif

#ifndef M_ASN1_I2D_put_SET_opt
#define M_ASN1_I2D_put_SET_opt(a,f) \
		if (a != NULL) M_ASN1_I2D_put_SET(a,f);

#endif

extern int PKCS12_lib_error_code;

#define PKCS12err(f,r) ERR_PKCS12_error((f),(r),ERR_file_name, __LINE__)
/*#undef ASN1err
#define ASN1err(f,r) PKCS12err (f, r)*/

typedef struct {
X509_SIG *dinfo;
ASN1_OCTET_STRING *salt;
ASN1_INTEGER *iter;	/* defaults to 1 */
} PKCS12_MAC_DATA;

typedef struct {
ASN1_INTEGER *version;
PKCS12_MAC_DATA *mac;
PKCS7 *authsafes;
} PKCS12;

typedef struct {
ASN1_OCTET_STRING *salt;
ASN1_INTEGER *iter;
} PBEPARAM;

typedef struct pkcs8_priv_key_info_st {
int broken;	/* Flag for various broken formats */
ASN1_INTEGER *version;
X509_ALGOR *pkeyalg;
ASN1_TYPE *pkey; /* Should be OCTET STRING but some versions are broken */
STACK *attributes;
} PKCS8_PRIV_KEY_INFO;

#define PKCS8_OK	0
#define PKCS8_NO_OCTET	1

typedef struct {
ASN1_OBJECT *type;
union {
	struct pkcs12_bag_st *bag; /* secret, crl and certbag */
	struct pkcs8_priv_key_info_st	*keybag; /* keybag */
	X509_SIG *shkeybag; /* shrouded key bag */
	STACK /* PKCS12_SAFEBAG */ *safes;
	ASN1_TYPE *other;
}value;
STACK *attrib;
ASN1_TYPE *rest;
} PKCS12_SAFEBAG;

typedef struct pkcs12_bag_st {
ASN1_OBJECT *type;
union {
	ASN1_OCTET_STRING *x509cert;
	ASN1_OCTET_STRING *x509crl;
	ASN1_OCTET_STRING *octet;
	ASN1_IA5STRING *sdsicert;
	ASN1_TYPE *other; /* Secret or other bag */
}value;
} PKCS12_BAGS;

typedef int (EVP_PBE_KEYGEN)(unsigned char *pass, int passlen,
	 unsigned char *salt,  int saltlen, int iter, EVP_CIPHER *cipher, 
		EVP_MD *md, unsigned char *key, unsigned char *iv);

typedef struct {
int pbe_nid;
EVP_CIPHER *cipher;
EVP_MD *md;
EVP_PBE_KEYGEN *keygen;
} EVP_PBE_CTL;

#define PKCS12_ERROR	0
#define PKCS12_OK	1

#if 0
#define i2d_PKCS12_bio(bp, p12) \
        ASN1_i2d_bio((int(*)())i2d_PKCS12, bp, (unsigned char *)(p12))
#define i2d_PKCS12_fp(fp, p12) \
        ASN1_i2d_fp((int(*)())i2d_PKCS12, fp, (unsigned char *)(p12))
#define d2i_PKCS12_bio(bp, p12) \
	(PKCS12 *)ASN1_d2i_bio((char *(*)())PKCS12_new, \
	 (char *(*)())d2i_PKCS12, (bp), (unsigned char **)(p12))
#define d2i_PKCS12_fp(fp, p12) \
	(PKCS12 *)ASN1_d2i_fp((char *(*)())PKCS12_new, \
	 (char *(*)())d2i_PKCS12, (fp), (unsigned char **)(p12))
#endif

#define M_PKCS12_bag_type(bag) (OBJ_obj2nid(bag->type) - PKCS12_obj_offset() )
#define M_PKCS12_cert_bag_type(bag) \
		(OBJ_obj2nid(bag->value.bag->type) - PKCS12_obj_offset() )
#define M_PKCS12_crl_bag_type M_PKCS12_cert_bag_type

#define M_PKCS12_x5092certbag(x509) \
PKCS12_pack_safebag ((char *)(x509), i2d_X509, NID_x509Certificate, NID_certBag)

#define M_PKCS12_x509crl2certbag(crl) \
PKCS12_pack_safebag ((char *)(crl), i2d_X509CRL, NID_x509Crl, NID_crlBag)

#define M_PKCS12_certbag2x509(bg) \
(X509 *) PKCS12_unpack_octet ((bg)->value.bag->value.octet, \
(char *(*)())d2i_X509)

#define M_PKCS12_certbag2x509crl(bg) \
(X509CRL *) PKCS12_unpack_octet ((bg)->value.bag->value.octet, \
(char *(*)())d2i_X509CRL)

/*#define M_PKCS12_pkcs82rsa(p8) \
(RSA *) PKCS12_unpack_octet ((p8)->pkey, (char *(*)())d2i_RSAPrivateKey)*/

#define M_PKCS12_unpack_p7data(p7) \
PKCS12_struct_unpack ((p7)->d.data->data, p7->d.data->length, \
			 (char *(*)())d2i_PKCS12_SAFEBAG, PKCS12_SAFEBAG_free)

#define M_PKCS12_pack_authsafes(p12, safes) \
PKCS12_struct_pack ((safes), (int (*)())i2d_PKCS7,\
	&(p12)->authsafes->d.data->data, &(p12)->authsafes->d.data->length)

#define M_PKCS12_unpack_authsafes(p12) \
PKCS12_struct_unpack ((p12)->authsafes->d.data->data, \
		(p12)->authsafes->d.data->length, (char *(*)())d2i_PKCS7, \
							PKCS7_free)

#define M_PKCS12_unpack_p7encdata(p7, pass, passlen) \
(STACK *) PKCS12_decrypt_d2i ((p7)->d.encrypted->enc_data->algorithm,\
			 (char *(*)())d2i_PKCS12_SAFEBAG, PKCS12_SAFEBAG_free, \
							(pass), (passlen), \
			(p7)->d.encrypted->enc_data->enc_data, 3)

#define M_PKCS12_decrypt_skey(bag, pass, passlen) \
(PKCS8_PRIV_KEY_INFO *) PKCS12_decrypt_d2i ((bag)->value.shkeybag->algor, \
(char *(*)())d2i_PKCS8_PRIV_KEY_INFO, PKCS8_PRIV_KEY_INFO_free, \
						(pass), (passlen), \
			 (bag)->value.shkeybag->digest, 2)

#define M_PKCS8_decrypt(p8, pass, passlen) \
(PKCS8_PRIV_KEY_INFO *) PKCS12_decrypt_d2i ((p8)->algor, \
(char *(*)())d2i_PKCS8_PRIV_KEY_INFO, (pass), (passlen), (p8)->digest, 2)

#define PKCS12_get_attr(bag, attr_nid) \
	PKCS12_get_attr_gen(bag->attrib, (attr_nid) + PKCS12_obj_offset() )

#define PKCS8_get_attr(p8, attr_nid) \
		PKCS12_get_attr_gen(p8->attributes, attr_nid)

#define PKCS12_mac_present(p12) ((p12)->mac ? 1 : 0)

#define M_ASN1_OBJECT_set(obj, nid) \
{\
ASN1_OBJECT_free(obj); \
obj = OBJ_nid2obj((nid));\
}

#ifndef NOPROTO
EXTERN int i2d_PKCS8_PRIV_KEY_INFO(PKCS8_PRIV_KEY_INFO *a, unsigned char **pp);
EXTERN PKCS8_PRIV_KEY_INFO *PKCS8_PRIV_KEY_INFO_new(void);
EXTERN PKCS8_PRIV_KEY_INFO *d2i_PKCS8_PRIV_KEY_INFO(PKCS8_PRIV_KEY_INFO **a, unsigned char **pp, long length);
EXTERN void PKCS8_PRIV_KEY_INFO_free(PKCS8_PRIV_KEY_INFO *a);
EXTERN PKCS12_SAFEBAG *PKCS12_pack_safebag(char *obj, int (*i2d)(), int nid1, int nid2);
EXTERN PKCS8_PRIV_KEY_INFO *PKEY2PKCS8(EVP_PKEY *pkey);
EXTERN EVP_PKEY *PKCS82PKEY(PKCS8_PRIV_KEY_INFO *p8);
EXTERN PKCS12_SAFEBAG *PKCS12_MAKE_KEYBAG(PKCS8_PRIV_KEY_INFO *p8);
EXTERN X509_SIG *PKCS8_encrypt(int pbe_nid, unsigned char *pass, int passlen, unsigned char *salt, int saltlen, int iter, PKCS8_PRIV_KEY_INFO *p8);
EXTERN PKCS12_SAFEBAG *PKCS12_MAKE_SHKEYBAG(int pbe_nid, unsigned char *pass, int passlen, unsigned char *salt, int saltlen, int iter, PKCS8_PRIV_KEY_INFO *p8);
EXTERN PKCS7 *PKCS12_pack_p7data(STACK *sk);
EXTERN PKCS7 *PKCS12_pack_p7encdata(int pbe_nid, unsigned char *pass, int passlen, unsigned char *salt, int saltlen, int iter, STACK *bags);
EXTERN int PKCS12_add_localkeyid(PKCS12_SAFEBAG *bag, unsigned char *name, int namelen);
EXTERN int PKCS12_add_friendlyname_asc(PKCS12_SAFEBAG *bag, unsigned char *name, int namelen);
EXTERN int PKCS12_add_friendlyname_uni(PKCS12_SAFEBAG *bag, unsigned char *name, int namelen);
EXTERN int PKCS8_add_keyusage(PKCS8_PRIV_KEY_INFO *p8, int usage);
EXTERN ASN1_TYPE *PKCS12_get_attr_gen(STACK *attrs, int attr_nid);
EXTERN char *PKCS12_get_friendlyname(PKCS12_SAFEBAG *bag);
EXTERN int EVP_PBE_ALGOR_CipherInit(X509_ALGOR *algor, unsigned char *pass, int passlen, EVP_CIPHER_CTX *ctx, int en_de);
EXTERN unsigned char *PKCS12_pbe_crypt(X509_ALGOR *algor, unsigned char *pass, int passlen, unsigned char *in, int inlen, unsigned char **data, int *datalen, int en_de);
EXTERN char *PKCS12_decrypt_d2i(X509_ALGOR *algor, char *(*d2i)(), void (*free_func)(), unsigned char *pass, int passlen, ASN1_STRING *oct, int seq);
EXTERN ASN1_STRING *PKCS12_i2d_encrypt(X509_ALGOR *algor, int (*i2d)(), unsigned char *pass, int passlen, char *obj, int seq);
EXTERN PKCS12 *PKCS12_init(int mode);
EXTERN int PKCS12_obj_offset(void);
EXTERN X509_ALGOR *PKCS12_pbe_set(int alg, int iter, unsigned char *salt, int saltlen);
EXTERN int PKCS12_key_gen_asc(unsigned char *pass, int passlen, unsigned char *salt, int saltlen, int id, int iter, int n, unsigned char *out, EVP_MD *md_type);
EXTERN int PKCS12_key_gen_uni(unsigned char *pass, int passlen, unsigned char *salt, int saltlen, int id, int iter, int n, unsigned char *out, EVP_MD *md_type);
EXTERN int PKCS12_PBE_keyivgen(unsigned char *pass, int passlen, unsigned char *salt, int saltlen, int iter, EVP_CIPHER *cipher, EVP_MD *md_type, unsigned char *key, unsigned char *iv);
EXTERN int PKCS12_gen_mac(PKCS12 *p12, unsigned char *pass, int passlen, unsigned char *mac, unsigned int *maclen);
EXTERN int PKCS12_gen_mac(PKCS12 *p12, unsigned char *pass, int passlen, unsigned char *mac, unsigned int *maclen);
EXTERN int PKCS12_verify_mac(PKCS12 *p12, unsigned char *pass, int passlen);
EXTERN int PKCS12_set_mac(PKCS12 *p12, unsigned char *pass, int passlen, unsigned char *salt, int saltlen, int iter, EVP_MD *md_type);
EXTERN int PKCS12_setup_mac(PKCS12 *p12, int iter, unsigned char *salt, int saltlen, EVP_MD *md_type);
EXTERN STACK *PKCS12_struct_unpack(unsigned char *buf, int len, char *(*d2i)(), void (*free_func)());
EXTERN unsigned char *PKCS12_struct_pack(STACK *safes, int (*i2d)(), unsigned char **buf, int *len);
EXTERN char *PKCS12_unpack_octet(ASN1_STRING *oct, char *(*d2i)());
EXTERN ASN1_STRING *PKCS12_pack_octet(char *obj, int (*i2d)(), ASN1_STRING **oct);
EXTERN unsigned char *asc2uni(unsigned char *asc, unsigned char **uni, int *unilen);
EXTERN char *uni2asc(unsigned char *uni, int unilen);
EXTERN void PKCS12_add_obj_error(ASN1_OBJECT *obj);
EXTERN int i2d_PKCS12_BAGS(PKCS12_BAGS *a, unsigned char **pp);
EXTERN PKCS12_BAGS *PKCS12_BAGS_new(void);
EXTERN PKCS12_BAGS *d2i_PKCS12_BAGS(PKCS12_BAGS **a, unsigned char **pp, long length);
EXTERN void PKCS12_BAGS_free(PKCS12_BAGS *a);
EXTERN int i2d_PKCS12(PKCS12 *a, unsigned char **pp);
EXTERN PKCS12 *d2i_PKCS12(PKCS12 **a, unsigned char **pp, long length);
EXTERN PKCS12 *PKCS12_new(void);
EXTERN void PKCS12_free(PKCS12 *a);
EXTERN int i2d_PKCS12_MAC_DATA(PKCS12_MAC_DATA *a, unsigned char **pp);
EXTERN PKCS12_MAC_DATA *PKCS12_MAC_DATA_new(void);
EXTERN PKCS12_MAC_DATA *d2i_PKCS12_MAC_DATA(PKCS12_MAC_DATA **a, unsigned char **pp, long length);
EXTERN void PKCS12_MAC_DATA_free(PKCS12_MAC_DATA *a);
EXTERN int i2d_PBEPARAM(PBEPARAM *a, unsigned char **pp);
EXTERN PBEPARAM *PBEPARAM_new(void);
EXTERN PBEPARAM *d2i_PBEPARAM(PBEPARAM **a, unsigned char **pp, long length);
EXTERN void PBEPARAM_free(PBEPARAM *a);
EXTERN int i2d_PKCS12_SAFEBAG(PKCS12_SAFEBAG *a, unsigned char **pp);
EXTERN PKCS12_SAFEBAG *PKCS12_SAFEBAG_new(void);
EXTERN PKCS12_SAFEBAG *d2i_PKCS12_SAFEBAG(PKCS12_SAFEBAG **a, unsigned char **pp, long length);
EXTERN void PKCS12_SAFEBAG_free(PKCS12_SAFEBAG *a);
EXTERN void ERR_load_PKCS12_strings(void);
EXTERN void ERR_PKCS12_error(int function, int reason, char *file, int line);
EXTERN void PKCS12_add_obj(void);
EXTERN void PKCS12_lib_init(void);
EXTERN int PKCS12_obj_offset();
EXTERN void PKCS12_PBE_add(void);
EXTERN int EVP_PBE_alg_add(int nid, EVP_CIPHER *cipher, EVP_MD *md, EVP_PBE_KEYGEN *keygen);
EXTERN int PKCS12_parse(PKCS12 *p12, char *pass, EVP_PKEY **pkey, X509 **cert, STACK **ca);
EXTERN PKCS12 *PKCS12_create(char *pass, char *name, EVP_PKEY *pkey, X509 *cert, STACK *ca, int nid_key, int nid_cert, int iter, int mac_iter, int keytype);
EXTERN int i2d_PKCS12_bio(BIO *bp, PKCS12 *p12);
EXTERN int i2d_PKCS12_fp(FILE *fp, PKCS12 *p12);
EXTERN PKCS12 *d2i_PKCS12_bio(BIO *bp, PKCS12 **p12);
EXTERN PKCS12 *d2i_PKCS12_fp(FILE *fp, PKCS12 **p12);

#else

EXTERN int i2d_PKCS8_PRIV_KEY_INFO();
EXTERN PKCS8_PRIV_KEY_INFO *PKCS8_PRIV_KEY_INFO_new();
EXTERN PKCS8_PRIV_KEY_INFO *d2i_PKCS8_PRIV_KEY_INFO();
EXTERN void PKCS8_PRIV_KEY_INFO_free();
EXTERN PKCS12_SAFEBAG *PKCS12_pack_safebag();
EXTERN PKCS8_PRIV_KEY_INFO *PKEY2PKCS8();
EXTERN EVP_PKEY *PKCS82PKEY();
EXTERN PKCS12_SAFEBAG *PKCS12_MAKE_KEYBAG();
EXTERN X509_SIG *PKCS8_encrypt();
EXTERN PKCS12_SAFEBAG *PKCS12_MAKE_SHKEYBAG();
EXTERN PKCS7 *PKCS12_pack_p7data();
EXTERN PKCS7 *PKCS12_pack_p7encdata();
EXTERN int PKCS12_add_localkeyid();
EXTERN int PKCS12_add_friendlyname_asc();
EXTERN int PKCS12_add_friendlyname_uni();
EXTERN char *PKCS12_get_friendlyname();
EXTERN int EVP_PBE_ALGOR_CipherInit();
EXTERN unsigned char *PKCS12_pbe_crypt();
EXTERN char *PKCS12_decrypt_d2i();
EXTERN ASN1_STRING *PKCS12_i2d_encrypt();
EXTERN PKCS12 *PKCS12_init();
EXTERN X509_ALGOR *PKCS12_pbe_set();
EXTERN int PKCS12_key_gen_asc();
EXTERN int PKCS12_key_gen_uni();
EXTERN int PKCS12_gen_mac();
EXTERN int PKCS12_verify_mac();
EXTERN int PKCS12_set_mac();
EXTERN int PKCS12_setup_mac();
EXTERN STACK *PKCS12_struct_unpack();
EXTERN unsigned char *PKCS12_struct_pack();
EXTERN char *PKCS12_unpack_octet();
EXTERN ASN1_STRING *PKCS12_pack_octet();
EXTERN unsigned char *asc2uni();
EXTERN char *uni2asc();
EXTERN void PKCS12_add_obj_error();
EXTERN int i2d_PKCS12_BAGS();
EXTERN PKCS12_BAGS *PKCS12_BAGS_new();
EXTERN PKCS12_BAGS *d2i_PKCS12_BAGS();
EXTERN void PKCS12_BAGS_free();
EXTERN int i2d_PKCS12();
EXTERN PKCS12 *d2i_PKCS12();
EXTERN PKCS12 *PKCS12_new();
EXTERN void PKCS12_free();
EXTERN int i2d_PKCS12_MAC_DATA();
EXTERN PKCS12_MAC_DATA *PKCS12_MAC_DATA_new();
EXTERN PKCS12_MAC_DATA *d2i_PKCS12_MAC_DATA();
EXTERN void PKCS12_MAC_DATA_free();
EXTERN int i2d_PBEPARAM();
EXTERN PBEPARAM *PBEPARAM_new();
EXTERN PBEPARAM *d2i_PBEPARAM();
EXTERN void PBEPARAM_free();
EXTERN int i2d_PKCS12_SAFEBAG();
EXTERN PKCS12_SAFEBAG *PKCS12_SAFEBAG_new();
EXTERN PKCS12_SAFEBAG *d2i_PKCS12_SAFEBAG();
EXTERN void PKCS12_SAFEBAG_free();
EXTERN void ERR_load_PKCS12_strings();
EXTERN void ERR_PKCS12_error ();
EXTERN void PKCS12_add_obj();
EXTERN void PKCS12_lib_init();
EXTERN void PKCS12_PBE_add();
EXTERN int EVP_PBE_alg_add();
EXTERN int PKCS8_add_keyusage();
EXTERN ASN1_TYPE *PKCS12_get_attr_gen();
EXTERN int PKCS12_obj_offset();
EXTERN int PKCS12_parse();
EXTERN PKCS12 *PKCS12_create();
EXTERN int i2d_PKCS12_bio();
EXTERN int i2d_PKCS12_fp();
EXTERN PKCS12 *d2i_PKCS12_bio();
EXTERN PKCS12 *d2i_PKCS12_fp();

#endif

/* BEGIN ERROR CODES */
/* Error codes for the PKCS12 functions. */

/* Function codes. */
#define PKCS12_F_ADD_FRIENDLYNAME			 100
#define PKCS12_F_ADD_FRIENDLYNAME_ASC			 101
#define PKCS12_F_ADD_FRIENDLYNAME_UNI			 102
#define PKCS12_F_D2I_PBEPARAM				 103
#define PKCS12_F_D2I_PKCS12				 104
#define PKCS12_F_D2I_PKCS12_BAGS			 105
#define PKCS12_F_D2I_PKCS12_MAC_DATA			 106
#define PKCS12_F_D2I_PKCS12_SAFEBAG			 107
#define PKCS12_F_D2I_PKCS8_PRIV_KEY_INFO		 108
#define PKCS12_F_EVP_PBE_ALGOR_CIPHERINIT		 109
#define PKCS12_F_EVP_PBE_ALG_ADD			 110
#define PKCS12_F_EVP_PBE_CIPHERINIT			 111
#define PKCS12_F_PARSE_BAGS				 147
#define PKCS12_F_PBEPARAM_NEW				 112
#define PKCS12_F_PKCS12_ADD_LOCALKEYID			 113
#define PKCS12_F_PKCS12_BAGS_NEW			 114
#define PKCS12_F_PKCS12_CREATE				 149
#define PKCS12_F_PKCS12_DECRYPT_D2I			 115
#define PKCS12_F_PKCS12_GEN_MAC				 116
#define PKCS12_F_PKCS12_I2D_ENCRYPT			 117
#define PKCS12_F_PKCS12_INIT				 118
#define PKCS12_F_PKCS12_KEY_GEN_ASC			 119
#define PKCS12_F_PKCS12_KEY_GEN_UNI			 120
#define PKCS12_F_PKCS12_MAC_DATA_NEW			 121
#define PKCS12_F_PKCS12_MAKE_SAFEBAG			 122
#define PKCS12_F_PKCS12_MAKE_SHKEYBAG			 123
#define PKCS12_F_PKCS12_NEW				 124
#define PKCS12_F_PKCS12_NEWPASS				 150
#define PKCS12_F_PKCS12_PACK_OCTET			 125
#define PKCS12_F_PKCS12_PACK_P7DATA			 126
#define PKCS12_F_PKCS12_PACK_P7ENCDATA			 127
#define PKCS12_F_PKCS12_PACK_P7_DATA			 128
#define PKCS12_F_PKCS12_PACK_SAFEBAG			 129
#define PKCS12_F_PKCS12_PARSE				 148
#define PKCS12_F_PKCS12_PBE_CRYPT			 130
#define PKCS12_F_PKCS12_PBE_KEYIVGEN			 131
#define PKCS12_F_PKCS12_PBE_SET				 132
#define PKCS12_F_PKCS12_PKCS12_SET_MAC			 133
#define PKCS12_F_PKCS12_PKCS82PKEY			 134
#define PKCS12_F_PKCS12_PKCS8_SET_BROKEN		 135
#define PKCS12_F_PKCS12_PKEY2PKCS8			 136
#define PKCS12_F_PKCS12_SAFEBAG_NEW			 137
#define PKCS12_F_PKCS12_SETUP_MAC			 138
#define PKCS12_F_PKCS12_SET_MAC				 139
#define PKCS12_F_PKCS12_STRUCT_PACK			 140
#define PKCS12_F_PKCS12_STRUCT_UNPACK			 141
#define PKCS12_F_PKCS12_UNPACK_OCTET			 142
#define PKCS12_F_PKCS8_ADD_KEYUSAGE			 143
#define PKCS12_F_PKCS8_ENCRYPT				 144
#define PKCS12_F_PKCS8_PRIV_KEY_INFO_NEW		 145
#define PKCS12_F_VERIFY_MAC				 146

/* Reason codes. */
#define PKCS12_R_BN_DECODE_ERROR			 100
#define PKCS12_R_BN_PUBKEY_ERROR			 101
#define PKCS12_R_CANT_PACK_STRUCTURE			 102
#define PKCS12_R_DECODE_ERROR				 103
#define PKCS12_R_DEOCDE_ERROR				 104
#define PKCS12_R_ENCODE_ERROR				 105
#define PKCS12_R_ENCRYPT_ERROR				 106
#define PKCS12_R_EVP_PBE_CIPHERINIT_ERROR		 107
#define PKCS12_R_INVALID_NULL_ARGUMENT			 128
#define PKCS12_R_INVALID_NULL_PKCS12_POINTER		 125
#define PKCS12_R_IV_GEN_ERROR				 108
#define PKCS12_R_KEYGEN_FAILURE				 109
#define PKCS12_R_KEY_GEN_ERROR				 110
#define PKCS12_R_MAC_ABSENT				 111
#define PKCS12_R_MAC_GENERATION_ERROR			 112
#define PKCS12_R_MAC_SETUP_ERROR			 113
#define PKCS12_R_MAC_STRING_SET_ERROR			 114
#define PKCS12_R_MAC_VERIFY_ERROR			 115
#define PKCS12_R_MAC_VERIFY_FAILURE			 126
#define PKCS12_R_NO_DSA_PARAMETERS			 116
#define PKCS12_R_PARSE_ERROR				 127
#define PKCS12_R_PKCS12_ALGOR_CIPHERINIT_ERROR		 117
#define PKCS12_R_PKCS12_CIPHERFINAL_ERROR		 118
#define PKCS12_R_PKCS12_PBE_CRYPT_ERROR			 119
#define PKCS12_R_PKCS8_UNKNOWN_BROKEN_TYPE		 120
#define PKCS12_R_UNKNOWN_DIGEST_ALGORITHM		 121
#define PKCS12_R_UNKNOWN_PBE_ALGORITHM			 122
#define PKCS12_R_UNSUPPORTED_PKCS12_MODE		 123
#define PKCS12_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM	 124
 
#ifdef  __cplusplus
}
#endif
#endif

