/* p12_utl.c */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <bio.h>
#include <err.h>
#include "pkcs12.h"

/* Cheap and nasty Unicode stuff */

unsigned char *asc2uni (asc, uni, unilen)
unsigned char *asc, **uni;
int *unilen;
{
	int ulen, i;
	unsigned char *unitmp;
	ulen = strlen((char *) asc)*2  + 2;
	if (!(unitmp = Malloc (ulen))) return NULL;
	for (i = 0; i < ulen; i+=2) {
		unitmp[i] = 0;
		unitmp[i + 1] = asc[i>>1];
	}
	if (unilen) *unilen = ulen;
	if (uni) *uni = unitmp;
	return unitmp;
}

char *uni2asc (uni, unilen)
unsigned char *uni;
int unilen;
{
	int asclen, i;
	char *asctmp;
	asclen = unilen / 2;
	/* If no terminating zero allow for one */
	if (uni[unilen - 1]) asclen++;
	uni++;
	if (!(asctmp = Malloc (asclen))) return NULL;
	for (i = 0; i < unilen; i+=2) asctmp[i>>1] = uni[i];
	asctmp[asclen - 1] = 0;
	return asctmp;
}

/* Tag an object type onto an error code */

void PKCS12_add_obj_error (obj)
ASN1_OBJECT *obj;
{
	char obj_tmp[80];
	if (!obj) strcpy (obj_tmp, "NULL");
	else i2t_ASN1_OBJECT(obj_tmp, 80, obj);
	ERR_add_error_data(2, "TYPE=", obj_tmp);
}

int i2d_PKCS12_bio(bp, p12)
BIO *bp;
PKCS12 *p12;
{
	return ASN1_i2d_bio((int(*)())i2d_PKCS12, bp, (unsigned char *)p12);
}

int i2d_PKCS12_fp(fp, p12)
FILE *fp;
PKCS12 *p12;
{
	return ASN1_i2d_fp((int(*)())i2d_PKCS12, fp, (unsigned char *)p12);
}

PKCS12 *d2i_PKCS12_bio(bp, p12)
BIO *bp;
PKCS12 **p12;
{
	return (PKCS12 *)ASN1_d2i_bio((char *(*)())PKCS12_new,
         (char *(*)())d2i_PKCS12, bp, (unsigned char **)p12);
}
PKCS12 *d2i_PKCS12_fp(fp, p12)
FILE *fp;
PKCS12 **p12;
{
        return (PKCS12 *)ASN1_d2i_fp((char *(*)())PKCS12_new, 
         (char *(*)())d2i_PKCS12, fp, (unsigned char **)(p12));
}

