/* p12_pbop.c */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <bio.h>
#include <err.h>
#include "pkcs12.h"

static STACK *pbe_algs;

/* Setup a cipher context from a PBE algorithm */

int EVP_PBE_CipherInit (pbe_obj, pass, passlen, salt, saltlen, iter, ctx, en_de)
ASN1_OBJECT *pbe_obj;
int passlen, saltlen, iter;
unsigned char *pass, *salt;
EVP_CIPHER_CTX *ctx;
int en_de;
{

	EVP_PBE_CTL *pbetmp, pbelu;
	unsigned char key[EVP_MAX_KEY_LENGTH], iv[EVP_MAX_IV_LENGTH];
	int i;
	pbelu.pbe_nid = OBJ_obj2nid(pbe_obj);
	if ((pbelu.pbe_nid != NID_undef) && pbe_algs) 
			i = sk_find (pbe_algs, (char *)&pbelu);
	else i = -1;

	if (i == -1) {
		PKCS12err(PKCS12_F_EVP_PBE_CIPHERINIT,PKCS12_R_UNKNOWN_PBE_ALGORITHM);
		PKCS12_add_obj_error(pbe_obj);
		return 0;
	}
	if (passlen == -1) passlen = strlen((char *) pass);
	pbetmp = (EVP_PBE_CTL *)sk_value (pbe_algs, i);
	i = (*pbetmp->keygen)(pass, passlen, salt, saltlen, iter,
					 pbetmp->cipher, pbetmp->md, key, iv);
	if (!i) {
		PKCS12err(PKCS12_F_EVP_PBE_CIPHERINIT,PKCS12_R_KEYGEN_FAILURE);
		return 0;
	}
	EVP_CipherInit (ctx, pbetmp->cipher, key, iv, en_de);
	return 1;	
}

/* Setup a PBE algorithm but take most parameters from AlgorithmIdentifier */

int EVP_PBE_ALGOR_CipherInit (algor, pass, passlen, ctx, en_de)
X509_ALGOR *algor;
unsigned char *pass;
int passlen;
EVP_CIPHER_CTX *ctx;
int en_de;
{
	PBEPARAM *pbe;
	int saltlen, iter;
	unsigned char *salt, *pbuf;

	/* Extract useful info from algor */
	pbuf = (unsigned char *) algor->parameter->value.sequence->data;
	if (!(pbe = d2i_PBEPARAM (NULL, &pbuf,
			 algor->parameter->value.sequence->length))) {
		PKCS12err(PKCS12_F_EVP_PBE_ALGOR_CIPHERINIT,PKCS12_R_DECODE_ERROR);
		return 0;
	}

	if (!pbe->iter) iter = 1;
	else iter = ASN1_INTEGER_get (pbe->iter);
	salt = pbe->salt->data;
	saltlen = pbe->salt->length;

	if (!(EVP_PBE_CipherInit (algor->algorithm, pass, passlen, salt,
 						saltlen, iter, ctx, en_de))) {
		PKCS12err(PKCS12_F_EVP_PBE_ALGOR_CIPHERINIT,PKCS12_R_EVP_PBE_CIPHERINIT_ERROR);
		PBEPARAM_free(pbe);
		return 0;
	}
	PBEPARAM_free(pbe);
	return 1;
}


static int pbe_cmp (pbe1, pbe2)
EVP_PBE_CTL **pbe1, **pbe2;
{
	return ((*pbe1)->pbe_nid - (*pbe2)->pbe_nid);
}

/* Add a PBE algorithm */

int EVP_PBE_alg_add (nid, cipher, md, keygen)
int nid;
EVP_CIPHER *cipher;
EVP_MD *md;
EVP_PBE_KEYGEN *keygen;
{
	EVP_PBE_CTL *pbe_tmp;
	if (!pbe_algs) pbe_algs = sk_new (pbe_cmp);
	if (!(pbe_tmp = (EVP_PBE_CTL*) Malloc (sizeof(EVP_PBE_CTL)))) {
		PKCS12err(PKCS12_F_EVP_PBE_ALG_ADD,ERR_R_MALLOC_FAILURE);
		return 0;
	}
	pbe_tmp->pbe_nid = nid;
	pbe_tmp->cipher = cipher;
	pbe_tmp->md = md;
	pbe_tmp->keygen = keygen;
	sk_push (pbe_algs, (char *)pbe_tmp);
	return 1;
}
