/* p12_pack.c */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#include <stdio.h>
#include <stdlib.h>
#include <err.h>
#include "pkcs12.h"

/* Turn an ASN1 encoded sequence into a STACK of structures */

STACK *PKCS12_struct_unpack (buf, len, d2i, free_func)
unsigned char *buf;
int len;
char *(*d2i)();
void (*free_func)();
{
    STACK *sk;
    unsigned char *pbuf;
    pbuf =  buf;
    if (!(sk = d2i_ASN1_SET__compat(NULL, &pbuf, len, d2i, free_func,
					V_ASN1_SEQUENCE, V_ASN1_UNIVERSAL)))
		 PKCS12err(PKCS12_F_PKCS12_STRUCT_UNPACK,PKCS12_R_DECODE_ERROR);
    return sk;
}

/* Turn a STACK of structures into an ASN1 encoded sequence */

unsigned char *PKCS12_struct_pack (safes, i2d, buf, len)
STACK *safes;
int (*i2d)();
unsigned char **buf;
int *len;
{
	int safelen;
	unsigned char *safe, *p;
	if (!(safelen = i2d_ASN1_SEQ__compat(safes, NULL, i2d, V_ASN1_SEQUENCE,
							 V_ASN1_UNIVERSAL))) {
		PKCS12err(PKCS12_F_PKCS12_STRUCT_PACK,PKCS12_R_ENCODE_ERROR);
		return NULL;
	}
	if (!(safe = Malloc (safelen))) {
		PKCS12err(PKCS12_F_PKCS12_STRUCT_PACK,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	p = safe;
	i2d_ASN1_SEQ__compat(safes, &p, i2d, V_ASN1_SEQUENCE, V_ASN1_UNIVERSAL);
	if (len) *len = safelen;
	if (buf) *buf = safe;
	return safe;
}

/* Extract an ASN1 object from an OCTET STRING */

char *PKCS12_unpack_octet (oct, d2i)
ASN1_OCTET_STRING *oct;
char *(*d2i)();
{
	unsigned char *p;
	char *ret;
	p = oct->data;
	if(!(ret = d2i(NULL, &p, oct->length)))
		PKCS12err(PKCS12_F_PKCS12_UNPACK_OCTET,PKCS12_R_DECODE_ERROR);
	return ret;
}

/* Pack an ASN1 object into an OCTET STRING */

ASN1_OCTET_STRING *PKCS12_pack_octet (obj, i2d, oct)
char *obj;
int (*i2d)();
ASN1_OCTET_STRING **oct;
{
	unsigned char *p;
	ASN1_OCTET_STRING *octmp;

	if (!oct || !*oct) {
		if (!(octmp = ASN1_OCTET_STRING_new ())) {
			PKCS12err(PKCS12_F_PKCS12_PACK_OCTET,ERR_R_MALLOC_FAILURE);
			return NULL;
		}
		if (oct) *oct = octmp;
	} else octmp = *oct;
		
	if (!(octmp->length = i2d(obj, NULL))) {
		PKCS12err(PKCS12_F_PKCS12_PACK_OCTET,PKCS12_R_ENCODE_ERROR);
		return NULL;
	}
	if (!(p = Malloc (octmp->length))) {
		PKCS12err(PKCS12_F_PKCS12_PACK_OCTET,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	octmp->data = p;
	i2d (obj, &p);
	return octmp;
}

