/* p12_decr.c */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#include <stdio.h>
#include <stdlib.h>
#include <objects.h>
#include <pkcs7.h>
#include <err.h>
#include <crypto.h>
#include <sha.h>
#include <stack.h>
#include <evp.h>
#include <string.h>
#include "hmac.h"
#include "pkcs12.h"

/* Define this to dump decrypted output to files called DERnnn */
/*#define DEBUG_DECRYPT*/


/* Encrypt/Decrypt a buffer based on password and algor, result in a
 * Malloc'ed buffer
 */

unsigned char * PKCS12_pbe_crypt (algor, pass, passlen, in, inlen,
						 data, datalen, en_de)
X509_ALGOR *algor;
unsigned char *pass;
int passlen;
unsigned char *in;
int inlen;
unsigned char **data;
int *datalen;
int en_de;
{
	unsigned char *out;
	int outlen, i;
	EVP_CIPHER_CTX ctx;

	if(!(out = Malloc (inlen + 8))) {
		PKCS12err(PKCS12_F_PKCS12_PBE_CRYPT,ERR_R_MALLOC_FAILURE);
		return NULL;
	}

	/* Decrypt data */
        if (!EVP_PBE_ALGOR_CipherInit (algor, pass, passlen, &ctx, en_de)) {
		PKCS12err(PKCS12_F_PKCS12_PBE_CRYPT,PKCS12_R_PKCS12_ALGOR_CIPHERINIT_ERROR);
		return NULL;
	}
	EVP_CipherUpdate (&ctx, out, &i, in, inlen);
	outlen = i;
	if(!EVP_CipherFinal (&ctx, out + i, &i)) {
		Free (out);
		PKCS12err(PKCS12_F_PKCS12_PBE_CRYPT,PKCS12_R_PKCS12_CIPHERFINAL_ERROR);
		return NULL;
	}
	outlen += i;
	if (datalen) *datalen = outlen;
	if (data) *data = out;
	return out;

}

/* Decrypt an OCTET STRING and decode ASN1 structure 
 * if seq & 1 'obj' is a stack of structures to be encoded
 * if seq & 2 zero buffer after use
 * as a sequence.
 */

char * PKCS12_decrypt_d2i (algor, d2i, free_func, pass, passlen, oct, seq)
X509_ALGOR *algor;
char * (*d2i)();
void (*free_func)();
unsigned char *pass;
int passlen;
ASN1_OCTET_STRING *oct;
int seq;
{
	unsigned char *out, *p;
	char *ret;
	int outlen;
	if (!PKCS12_pbe_crypt (algor, pass, passlen, oct->data, oct->length,
				 &out, &outlen, 0)) {
		PKCS12err(PKCS12_F_PKCS12_DECRYPT_D2I,PKCS12_R_PKCS12_PBE_CRYPT_ERROR);
		return NULL;
	}
	p = out;
#ifdef DEBUG_DECRYPT
	{
		FILE *op;

		char fname[30];
		static int fnm = 1;
		sprintf(fname, "DER%d", fnm++);
		op = fopen(fname, "wb");
		fwrite (p, 1, outlen, op);
		fclose(op);
	}
#endif
	if (seq & 1) ret = (char *) d2i_ASN1_SET__compat(NULL, &p, outlen, d2i,
				free_func, V_ASN1_SEQUENCE, V_ASN1_UNIVERSAL);
	else ret = d2i(NULL, &p, outlen);
	if (seq & 2) memset(out, 0, outlen);
	if(!ret) PKCS12err(PKCS12_F_PKCS12_DECRYPT_D2I,PKCS12_R_DECODE_ERROR);
	Free (out);
	return ret;
}

/* Encode ASN1 structure and encrypt, return OCTET STRING 
 * if 'seq' is non-zero 'obj' is a stack of structures to be encoded
 * as a sequence
 */

ASN1_OCTET_STRING *PKCS12_i2d_encrypt (algor, i2d, pass, passlen, obj, seq)
X509_ALGOR *algor;
int (*i2d)();
unsigned char *pass;
int passlen;
char *obj;
int seq;
{
	ASN1_OCTET_STRING *oct;
	unsigned char *in, *p;
	int inlen;
	if (!(oct = ASN1_OCTET_STRING_new ())) {
		PKCS12err(PKCS12_F_PKCS12_I2D_ENCRYPT,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	if (seq) inlen = i2d_ASN1_SEQ__compat ((STACK *)obj, NULL, i2d,
					 V_ASN1_SEQUENCE, V_ASN1_UNIVERSAL);
	else inlen = i2d (obj, NULL);
	if (!inlen) {
		PKCS12err(PKCS12_F_PKCS12_I2D_ENCRYPT,PKCS12_R_ENCODE_ERROR);
		return NULL;
	}
	if (!(in = Malloc (inlen))) {
		PKCS12err(PKCS12_F_PKCS12_I2D_ENCRYPT,ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	p = in;
	if (seq) i2d_ASN1_SEQ__compat ((STACK *)obj, &p, i2d, V_ASN1_SEQUENCE,
							V_ASN1_UNIVERSAL);
	else i2d (obj, &p);
	if (!PKCS12_pbe_crypt (algor, pass, passlen, in, inlen, &oct->data,
				 &oct->length, 1)) {
		PKCS12err(PKCS12_F_PKCS12_I2D_ENCRYPT,PKCS12_R_ENCRYPT_ERROR);
		Free(in);
		return NULL;
	}
	Free (in);
	return oct;
}
