/* 
 *
 * Routine which can be used from deamons like sshd 
 * to fork and exec sslk5 to get a K5 ticket using 
 * the delegated proxy file. 
 * 
 * This should be called before the ANL_DFS_PAG or
 * ANL_AFS_PAG routines. 
 * 
 * sslk5_exec()
 */


#include "k5-int.h"

#ifdef SSLK5

#include <stdio.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>

/* Only run this code on systems with POSIX
 * All that we are interested in do:, AIX 4.x,
 * Solaris 2.5.x, HPUX 10.x  Even SunOS 4.1.4, AIX 3.2.5
 * and SGI 5.3 are OK.  This simplifies
 * the build/configure which I don't want to change now.
 * All of them also have waitpid as well. 
 */

#define POSIX_SETJMP
#define POSIX_SIGNALS
#define HAVE_WAITPID

#include <signal.h>
#include <setjmp.h>
#ifndef POSIX_SETJMP
#undef sigjmp_buf
#undef sigsetjmp
#undef siglongjmp
#define sigjmp_buf  jmp_buf
#define sigsetjmp(j,s)  setjmp(j)
#define siglongjmp  longjmp
#endif

#ifdef POSIX_SIGNALS
typedef struct sigaction handler;
#define handler_init(H,F)       (sigemptyset(&(H).sa_mask), \
                     (H).sa_flags=0, \
                     (H).sa_handler=(F))
#define handler_swap(S,NEW,OLD)     sigaction(S, &NEW, &OLD)
#define handler_set(S,OLD)      sigaction(S, &OLD, NULL)
#else
typedef sigtype (*handler)();
#define handler_init(H,F)       ((H) = (F))
#define handler_swap(S,NEW,OLD)     ((OLD) = signal ((S), (NEW)))
#define handler_set(S,OLD)      (signal ((S), (OLD)))
#endif

typedef krb5_sigtype sigtype;


#ifdef  WAIT_USES_INT
                int wait_status;
#else   /* WAIT_USES_INT */
                union wait wait_status;
#endif  /* WAIT_USES_INT */

#ifndef SSLK5_PROGRAM
#define SSLK5_PROGRAM "/krb5/bin/sslk5" 
#endif

/* 
 * mysig()
 *
 * signal handler to catch any problems with sslk5
 *
 */

static sigjmp_buf setpag_buf;

static sigtype mysig()
{
  siglongjmp(setpag_buf, 1);
}

/*
 * sslk5_exec()
 *
 * Given a principal and local username,
 * fork and exec the sslk5 to create K5 ticket
 * from a X509 certificate located in the X590_USER_PROXY  
 * 
 * This routine should be called after the gssapi is complete.
 *
 * Call this before the krb5_dfs_pag or krb5_afs_pag.
 * DEE - 2/99
 */ 
 
int sslk5_exec(context, flag, principal, luser)
	krb5_context context;
    int flag; /* 1 if a forwarded TGT is to be used */
	krb5_principal principal;
	const char *luser;

{
  
  struct stat stx;
  int fd[2];
  int i,j;
  int pid;
  int new_pag;
  int pag;
  char newccname[MAXPATHLEN] = ""; 
  char *princ;
  int err; 

#ifdef  WAIT_USES_INT
  int wait_status;
#else   /* WAIT_USES_INT */
  union wait wait_status;
#endif  /* WAIT_USES_INT */

  i = 0;
  do {
   sprintf(newccname,"FILE:/tmp/krb5cc_p%d%d",getpid(),i++);
  }
  while(stat(newccname+5,&stx) == 0);

  krb5_setenv("KRB5CCNAME", newccname, 1);

  if (krb5_unparse_name(context, principal, &princ))
   return(0);
/* DEE may not need this, or set to default */
  
#if 0
  if (pipe(fd) == -1) 
     return(0);
#endif

  pid = fork();
  if (pid <0) 
   return(0);

  if (pid == 0) {  /* child process */

    close(1);       /* close stdout */
    dup(fd[1]);     /* point stdout at pipe here */
    close(fd[0]);   /* don't use end of pipe here */
    close(fd[1]);   /* pipe now as stdout */

/*DEE - may need different parms */
/*DEE - May want to run as the user */
    execl(SSLK5_PROGRAM, "sslk5",
         "-f", princ, (char *)0);

    exit(127);      /* incase execl fails */
  } 

  /* parent, wait for child to finish */

  close(fd[1]);  /* dont need this end of pipe */

#if defined(sgi) || defined(_sgi)
  wait_status.w_status = 0;
  waitpid((pid_t) pid, &wait_status.w_status, 0);
#else


 wait_status = 0;
#ifdef  HAVE_WAITPID
  err = waitpid((pid_t) pid, &wait_status, 0);
#else   /* HAVE_WAITPID */
  err = wait4(pid, &wait_status, 0, (struct rusage *) NULL);
#endif  /* HAVE_WAITPID */
#endif

#if 0
  if (WIFEXITED(wait_status)){
    if (WEXITSTATUS(wait_status) == 0) {
      i = 1;
      j = 0;
      while (i != 0) {
        i = read(fd[0], &newccname[j], sizeof(newccname)-1-j);
        if ( i > 0)
          j += i;
        if (j >=  sizeof(newccname)-1)
          i = 0;
      }
      close(fd[0]);
      if (j > 0) {
        newccname[j] = '\0'; 
        krb5_setenv("KRB5CCNAME",newccname,1);
      }
    }
  }
#endif
  return(0); /* something not right */
}

#else /* ANL_DFS_PAG */

/* 
 * sslk5exec() - dummy version for the lib for systems 
 */

krb5_boolean
sslk5exec(context, flag, principal, luser)
	krb5_context context;
	int flag,
	krb5_principal principal;
	const char *luser;
{
	return(0);
}

#endif /* ANL_SSLK5_EXEC */
