/*************************************************************
sslk5.h

Description:
	Header file to define the ssl to K5 interface routines
	which will seperate the SSL code from the K5 code 
	Thias is used by sendto_kdc.c in the DLL or shared lib
	to call the routines which do SSL in the application
    thus avoiding dependencies between SSL and K5. 

*************************************************************/

#ifndef _SSLK5_H
#define _SSLK5_H

typedef struct _sslk5_sendto_kdc_work {
	void * data;
	int  (*sendrecvssl)();
	int  (*initssl)();
    void (*cleanssl)();
} sslk5_sendto_kdc_work;

#ifdef SSLK5_INTERNAL
typedef struct _sslk5_sendto_kdc_data {
	SSL * gs_ssl;
	BIO * sbio;
    proxy_cred_desc * cred_handle;
    proxy_verify_desc verify_area;
} sslk5_sendto_kdc_data;
#endif

krb5_error_code krb5_sendto_kdc_ssl_init
	KRB5_PROTOTYPE((krb5_context, 
					void *));

krb5_error_code krb5_sendto_kdc_ssl_free 
		KRB5_PROTOTYPE((krb5_context));

#endif /* _SSLK5_H */
