/*
 * sendto_kdcx.c
 *
 * Extra routines for doing SSL from the sendto_kdc.c routine
 * split here for WINDOWS as to avoid as many changes as possible
 * with the PC version. We only need an extr field in the 
 * context, and changes to the sendto_kdc.c code. 
 * All SSL code is outside the k5 DLL, in the sslk5 application. 
 * The application calls the sslk5_sendto_kdc_init before
 * the init_tkt* calls. This trigers the modified 
 * sendto_kdc to call these routines to do the SSL code. 
 * DEE 8/10/98
 */

#define NEED_SOCKETS
/* #define NEED_LOWLEVEL_IO */
#include "k5-int.h"

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#include "os-proto.h"

#ifdef _AIX
#include <sys/select.h>
#endif

#ifdef HAVE_SYS_FILIO_H
#include <sys/filio.h>
#endif
#ifndef WIN32
#include <sys/ioctl.h>
#endif
#include "ssl.h"
#include "err.h"
#include "bio.h"
#include "pem.h"
#include "x509.h"
#include "stack.h"
#include "sslutils.h"
#define SSLK5_INTERNAL
#include "sslk5.h"

/*****************************************************************/
static int
initssl(sslk5data, sock)
	sslk5_sendto_kdc_data * sslk5data;
	SOCKET sock;
{

    long on = 1;
		BIO_socket_ioctl(sock,FIONBIO,&on);
#ifdef DEBUG
	fprintf(stderr,"Starting to init SSL\n");
#endif
		/* must use SSL_CTX_set_verify, as
		 * SSL_set_verify does not handle the callback 
		 * correctly in 0.8.1 or 0.9.0
		 */
		SSL_CTX_set_verify(sslk5data->cred_handle->gs_ctx,
			SSL_VERIFY_PEER|SSL_VERIFY_FAIL_IF_NO_PEER_CERT,
			proxy_verify_callback);

		sslk5data->gs_ssl = SSL_new(sslk5data->cred_handle->gs_ctx);
		SSL_set_cipher_list(sslk5data->gs_ssl,"DEFAULT:-EXP");

		if (sslk5data->cred_handle->certdir) {
            sslk5data->verify_area.certdir = strdup(sslk5data->cred_handle->certdir);
		}

		SSL_set_app_data(sslk5data->gs_ssl, 
				(char *)&(sslk5data->verify_area));
		SSL_set_connect_state(sslk5data->gs_ssl);

        sslk5data->sbio=BIO_new_socket(sock,BIO_NOCLOSE);
        SSL_set_bio(sslk5data->gs_ssl,
				sslk5data->sbio,sslk5data->sbio);
		return 0;
}

/*******************************************************/
static int sendrecvssl(dir, sslk5data, sock, data, len)
	int		dir;
	sslk5_sendto_kdc_data * sslk5data;
	SOCKET  sock;
	char *	data;
	int		len;
{
	int kdc_timeout = 10;
	int rc;
	int shouldr;
	int shouldw;
	fd_set fdsets;
	struct timeval waitlen;
	int nready;

#ifdef DEBUG
	fprintf(stderr,"SSL sendrecvssl ");
	if (dir) {
		fprintf(stderr,"writing %d bytes\n", len);
	} else {
		 fprintf(stderr,"reading upto %d bytes\n",len);
	}
#endif
	rc = -1;
	while (rc < 0)	{
		if (dir) {
			rc = SSL_write(sslk5data->gs_ssl, data, len);
		} else {
			rc = SSL_read(sslk5data->gs_ssl,data,len);
		}
#ifdef DEBUG
		fprintf(stderr,"SSL_read/write rc=%d\n",rc);
		if (rc == -1) perror("ERRNO=");
#endif
		if (rc < 0) {
			if (!BIO_should_retry(SSL_get_rbio(sslk5data->gs_ssl))) {
					fprintf(stderr,"SSL error rc=%d\n",rc);
					return rc;
			} 
			shouldr = BIO_should_read(SSL_get_rbio(sslk5data->gs_ssl));
			shouldw = BIO_should_write(SSL_get_rbio(sslk5data->gs_ssl));
#ifdef DEBUG
			fprintf(stderr,"shouldr=%d shouldw=%d\n",shouldr,shouldw);
#endif
   	 retry:
   	    	waitlen.tv_usec = 0;
        	waitlen.tv_sec = kdc_timeout;
        	FD_ZERO(&fdsets);
        	FD_SET(sock, &fdsets);
        	rc = select(SOCKET_NFDS(sock), (shouldr ? &fdsets : 0),
               	 (shouldw ? &fdsets : 0), 0, &waitlen);
#ifdef DEBUG
			fprintf(stderr,"select rc=%d\n",rc);
#endif
			if (rc == SOCKET_ERROR) {
           		if (SOCKET_ERRNO == SOCKET_EINTR) {
           				goto retry;
				}
           		return SOCKET_ERROR;
     		}
			if (rc != 0) { /* timeout same as closed connection */
				rc = -1; /* retry the read/write */
			}
		}
	} /* while (rc < 0) */
#ifdef DEBUG
	if (rc > 0 && !dir) {
		fprintf(stderr,"read %d bytes\n", rc);
	}
#endif
	return rc;
}

/***********************************************************/
static void
cleanssl(sslk5data)
	sslk5_sendto_kdc_data * sslk5data;

{
#ifdef DEBUG
        fprintf(stderr,"cleanssl start\n");
#endif

	proxy_release_verify(&(sslk5data->verify_area));
#ifdef DEBUG
        fprintf(stderr,"cleanssl middle\n");
#endif

	if (sslk5data->gs_ssl) {
		SSL_free(sslk5data->gs_ssl);
		sslk5data->gs_ssl = NULL;
		sslk5data->sbio = NULL;
	}
	if (sslk5data->sbio)
		BIO_free(sslk5data->sbio);
#ifdef DEBUG
        fprintf(stderr,"cleanssl complete\n");
#endif
}

/******************************************************************/
krb5_error_code
krb5_sendto_kdc_ssl_init (context, cred_handle)
    krb5_context context;
	void * cred_handle;
{

	sslk5_sendto_kdc_work * sslk5;
	sslk5_sendto_kdc_data * sslk5data;

#ifdef DEBUG
	fprintf(stderr,"krb5_sendto_kdc_ssl_init\n");
#endif
 	if ((sslk5 = (sslk5_sendto_kdc_work *)
		 malloc(sizeof(sslk5_sendto_kdc_work))) == NULL) {
		 return ENOMEM;
	}
	
	sslk5->sendrecvssl =  sendrecvssl;
	sslk5->initssl = initssl;
	sslk5->cleanssl = cleanssl;
 	if ((sslk5data = (sslk5_sendto_kdc_data *)
		malloc(sizeof(sslk5_sendto_kdc_data))) == NULL) {
		return ENOMEM;
	}

	sslk5data->sbio = NULL;
	sslk5data->gs_ssl = NULL;
	proxy_init_verify(&(sslk5data->verify_area));
	sslk5data->cred_handle = cred_handle;

	sslk5->data = sslk5data;
	context->sslk5 = sslk5;
	return 0;
}

/*************************************************************/
krb5_error_code
krb5_sendto_kdc_ssl_free(context)
	krb5_context context;
{
	sslk5_sendto_kdc_work * sslk5 = context->sslk5;
	sslk5_sendto_kdc_data * sslk5data;
#ifdef DEBUG
        fprintf(stderr,"krb5_sendto_kdc_ssl_free start\n");
#endif

	if (sslk5) {
		sslk5data = sslk5->data;
		if (sslk5data) {
			cleanssl(sslk5data);
			free(sslk5data);
		}
		free(sslk5);
	}
        context->sslk5 = NULL;
#ifdef DEBUG
        fprintf(stderr,"krb5_sendto_kdc_ssl_free complete\n");
#endif
        return 0;
}  

