/**********************************************************************

release_name.c:

Description:
    GSSAPI routine to release a name
    See: <draft-ietf-cat-gssv2-cbind-04.txt>
CVS Information:

    $Source: /home/globdev/CVS/globus-current/Globus/Security/gssapi_ssleay/release_name.c,v $
    $Date: 1999/06/14 14:29:22 $
    $Revision: 1.5 $
    $Author: dengert $

**********************************************************************/

static char *rcsid = "$Header: /home/globdev/CVS/globus-current/Globus/Security/gssapi_ssleay/release_name.c,v 1.5 1999/06/14 14:29:22 dengert Exp $";

/**********************************************************************
                             Include header files
**********************************************************************/

#include "gssapi_ssleay.h"

/**********************************************************************
                               Type definitions
**********************************************************************/

/**********************************************************************
                          Module specific prototypes
**********************************************************************/

/**********************************************************************
                       Define module specific variables
**********************************************************************/

/**********************************************************************
Function:   gss_release_name()

Description:
	Release the gssapi name structure

Parameters:
   
Returns:
**********************************************************************/

OM_uint32 
GSS_CALLCONV gss_release_name
(OM_uint32 *          minor_status,
 gss_name_t *         name_P
)
{
  
  gss_name_desc** name = (gss_name_desc**) name_P ;

  *minor_status = 0;
  if (name == NULL || *name == NULL || *name == GSS_C_NO_NAME) {
    return GSS_S_COMPLETE ;
  }

  if ((*name)->x509n) {
    X509_NAME_free((*name)->x509n);
  }

  free(*name) ;
  *name = GSS_C_NO_NAME ;

  return GSS_S_COMPLETE ;

} /* gss_release_name */
