/* sample_init.c: 
 * Test routine for using gss_init_sec_context() 
 *
 * Description :
 * The functions in this file form the client side servies demonstrating
 * the use of the rlogin gss-api.  The code is documented and should be
 * straight forward.  View the Release Notes for an overall description
 * of the communication.
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <pwd.h>


#include <sys/time.h>
#include <arpa/inet.h>

#ifndef FREEBSD 
#include <malloc.h>
#endif /* !FREEBSD */

#ifdef FREEBSD
#include <stdlib.h>
#endif /* FREEBSD */

#include <string.h>

#include <gssapi.h>

#include "sample_comm.h"

void send_test_data(int, gss_ctx_id_t) ;

main(int argc, char *argv[])
{
  
  const char this_function[] = "main()";
  
  OM_uint32                          minor_status = 0;
  gss_cred_id_t                      initiator_cred_handle;
  gss_ctx_id_t                       context_handle;
  gss_name_t                         target_name ;
  gss_OID                            mech_type;
  OM_uint32                          req_flags = 0;
  OM_uint32                          time_req = 0;
  gss_channel_bindings_t             input_chan_bindings;
  gss_buffer_desc                    input_buffer_desc, output_buffer_desc;
  gss_OID                            actual_mech_type;

  OM_uint32                          ret_flags = 0;
  OM_uint32                          time_rec = 0;

  OM_uint32                          major_status = 0;

  char                               target_name_str[80];
  char                               target_address_str[80];
  int                                msg_result ;

  gss_buffer_t                       output_buffer = &output_buffer_desc ;
  gss_buffer_t                       input_buffer  = &input_buffer_desc ; 

  int                                context_established = 0 ;

  /* needed for comm. */
  int peer_socket;
  int port;
  char read_buffer[80];

  switch (argc) {
  case 1:
    printf("input target name (max 79 chars):");
    scanf("%s", target_name_str);
      
    printf("input target address (max 79 chars):");
    scanf("%s", target_address_str);
      
    printf("Enter port number of acceptor; \n");
    scanf("%d", &port);
    break ;

  case 2:
    strcpy(target_name_str, argv[1]) ;
    strcpy(target_address_str, "localhost") ;
    port = DEFAULT_PORT ;
    break ;
  case 3:
    strcpy(target_name_str, argv[1]) ;
    strcpy(target_address_str, argv[2]) ;
    port = DEFAULT_PORT ;
    break ;
  default:
    fprintf(stderr, "E %s: Invalid parameters.\n", this_function) ;
    fprintf(stderr,
	    "E %s: Usage: client [<target_name> <target_address>]\n",
	    this_function) ;
    exit(1) ;
    break ;
  }
  


  /* connect to acceptor :
   *   This actually connects to the server through Berkley socket calls.
   *   No data is transfered. 
   */
  {
    const char invoked_function[] = "connection";
    peer_socket = connection(target_address_str, port, SERVICE_NAME);
    if (peer_socket < 0) {
      fprintf(stderr, "E %s: %s: peer_socket = %d: cannot get peer socket \n",
	      this_function, invoked_function, peer_socket);
      exit (1);
    }
  } /* connect to acceptor */


#ifdef DEBUG
  fprintf(stderr, "N %s: Connected to acceptor\n", this_function) ;
#endif 


  {				/* Copy target_name string into a gss_buffer */

    input_buffer->length = strlen(target_name_str);
    input_buffer->value = (void*) malloc(input_buffer->length) ;
    if (input_buffer->value == NULL) {
      fprintf(stderr, 
	      "E %s: Could not allocate enougy memory!\n", this_function);
      exit(1) ;
    }
    memcpy(input_buffer->value, 
	   (void*) target_name_str, 
	   input_buffer->length) ;
  }

  {				/* import the name */

    major_status = gss_import_name(&minor_status,
				   input_buffer,
				   GSS_C_NO_OID,
				   &target_name) ;

    major_status = gss_release_buffer(&minor_status,
				      input_buffer) ;

  }

  {				/* Setup context variables */

    minor_status = 0 ;
    initiator_cred_handle = GSS_C_NO_CREDENTIAL ;
    context_handle = GSS_C_NO_CONTEXT;
    mech_type = GSS_C_NO_OID;
    req_flags = 0;
    time_req = 0;
    input_chan_bindings = GSS_C_NO_CHANNEL_BINDINGS;
    ret_flags = 0 ;
    time_rec = 0 ;

    input_buffer->length = 0 ;
  }



  while (!context_established) {

#ifdef DEBUG
    fprintf(stderr, "N %s: Looping while GSS_S_CONTINUE_NEEDED\n", 
	    this_function) ;
#endif 



    major_status = gss_init_sec_context(&minor_status,
					initiator_cred_handle,
					&context_handle,
					target_name,
					mech_type,
					req_flags,
					time_req,
					input_chan_bindings,
					input_buffer,
					&actual_mech_type,
					output_buffer,
					&ret_flags,
					&time_rec);

#ifdef DEBUG
    fprintf(stderr,
	    "N %s: Returned from init_sec_ctx w/token [%d]\n",
	    this_function,
	    output_buffer->length) ;
#endif /* DEBUG */

    if (GSS_ERROR(major_status) ) {
      fprintf(stderr,
	      "E %s: Error durring context establishment.\n",
	      this_function) ;
    }


    if (output_buffer->length != 0) {

      
      

      {				/* send the output token */
	msg_result = send_message(peer_socket,         
				  context_handle,      
				  output_buffer,
				  0, /* 0 = no wrap */
				  0) ; /* 0 = no encrypt */
	if ( msg_result < 0 ) {
	  fprintf(stderr,
		  "E %s: Could not send message.\n",
		  this_function) ;
	  gss_delete_sec_context(&minor_status, 
				 &context_handle,
				 output_buffer) ;
	  close(peer_socket) ;
	  exit(1) ;
	}
	
      }

#ifdef DEBUG
      fprintf(stderr, 
	      "N %s: Sent output token [%d], waiting for new token\n",
	      this_function,
	      output_buffer->length) ;
#endif
      
      {				/* Release output buffer */

	OM_uint32 inv_major_status = 0 , inv_minor_status = 0 ;
	inv_major_status = gss_release_buffer(&inv_minor_status,
					      output_buffer) ;
      } /* Release output buffer */

    }

    if (GSS_ERROR(major_status)) {
      if (context_handle != GSS_C_NO_CONTEXT) {
	OM_uint32 inv_major_status = 0 , inv_minor_status = 0 ;
	inv_major_status = gss_delete_sec_context(&inv_minor_status,
						  &context_handle,
						  GSS_C_NO_BUFFER) ;
	break ;
      }
    }


    if (major_status & GSS_S_CONTINUE_NEEDED) {

      msg_result = receive_message(peer_socket,
				   context_handle,
				   input_buffer,
				   0) ; /* 0 = no unwrap */
      if ( msg_result < 0 ) {
	fprintf(stderr,
		"E %s: Could not receive message.\n",
		this_function) ;
	gss_delete_sec_context(&minor_status, 
			       &context_handle,
			       input_buffer) ;
	close(peer_socket) ;
	exit(1) ;
      }
    
#ifdef DEBUG
      fprintf(stderr, 
	      "N %s: Received token: [%d]\n", 
	      this_function, 
	      input_buffer->length) ;
#endif

    } else {
      context_established = 1 ;
    } /* if (major_status & GSS_S_CONTINUE_NEEDED) */

  } /* while (!context_established) */


  /* send some sample data to the server. */

  if (context_established) {
    send_test_data(peer_socket, context_handle) ;
    
    fprintf(stderr, 
	    "N %s: Test data sent successfully.\n",
	    this_function) ;

    gss_delete_sec_context(&minor_status, 
			   &context_handle,
			   GSS_C_NO_BUFFER) ;
  }

  close(peer_socket) ;
  exit(0);

} /* main */



void send_test_data(int peer_socket, gss_ctx_id_t context_handle)
{
  const char this_function[] = "send_test_data()";
  
  int msg_result ;
  OM_uint32 minor_status ;
  gss_buffer_desc input_message_buffer, output_message_buffer ;
  char test_data[BUFFER_LENGTH] ;

  strcpy(test_data,"This is a test!") ;


  output_message_buffer.length = strlen(test_data)+1 ;

  output_message_buffer.value = (void*) malloc(output_message_buffer.length) ;

  if (output_message_buffer.value == NULL) {
    fprintf(stderr, 
	    "E %s: Could not allocate enougy memory!\n", this_function);
    close(peer_socket) ;
    exit(1) ;
  }

  memcpy(output_message_buffer.value,test_data,output_message_buffer.length) ;

#ifdef DEBUG
  fprintf(stderr,
	  "N %s: Buffer is ready.  Attempting to wrap...\n",
	  this_function) ;
#endif
  msg_result = send_message(peer_socket,
			    context_handle,
			    &output_message_buffer,
			    1,
			    1) ;
  if ( msg_result < 0 ) {
    fprintf(stderr,
	    "E %s: Could not send message.\n",
	    this_function) ;
    gss_delete_sec_context(&minor_status, 
			   &context_handle,
			   &output_message_buffer) ;
    close(peer_socket) ;
    exit(1) ;
  }  

  gss_release_buffer(&minor_status, &output_message_buffer) ;


  msg_result = receive_message(peer_socket, 
			       context_handle, 
			       &input_message_buffer,
			       1);
  if ( msg_result < 0 ) {
    fprintf(stderr,
	    "E %s: Could not receive message.\n",
	    this_function) ;
    gss_delete_sec_context(&minor_status, 
			   &context_handle,
			   &input_message_buffer) ;
    close(peer_socket) ;
    exit(1) ;
  }  

#ifdef DEBUG
  fprintf(stderr, 
	  "N %s: Received the following data in loopback: [%d:%s]\n",
	  this_function, 
	  input_message_buffer.length, 
	  (char *) input_message_buffer.value) ;
#endif  
  gss_release_buffer(&minor_status, &input_message_buffer) ;
  
} /* send_test_data */
