/* sample_accept.c:
 *     Test routine for using gss_accept_sec_context() 
 *     Covers only the basic usage.
 *     Lots of stuff like memory management missing.
 * FOR ILLUSTRATION ONLY, DOESN'T WORK OR EVEN COMPILE, IS INCOMPLETE
 */


  /* Following is the basic algorithm used in run_acceptor() */

  /* If !(major_status & GSS_S_CONTINUE_NEEDED) and !(GSS_ERROR(major_status))
   * context is established. Send output token to initiator and 
   * prepare to send and receive data.
   */

  /* Otherwise, send output token to initiator. This contains
   * PASSWORD request.
   */

  /* read token2 from initiator. This contains
   * password. Interpreted as encrypted or not acc. to the
   * context handle contents. Default is set to cleartext.
   */

  /* Call gss_accept_sec_context() with token2 */

  /* If !(major_status & GSS_S_CONTINUE_NEEDED) and !(GSS_ERROR(major_status))
   * context is established. Send output token to initiator and 
   * prepare to send and receive data.
   */

  /* Otherwise, we failed to establish context. */



#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <pwd.h>


#include <sys/time.h>
#include <arpa/inet.h>

#ifndef FREEBSD 
#include <malloc.h>
#endif /* !FREEBSD */

#ifdef FREEBSD
#include <stdlib.h>
#endif /* FREEBSD */

#include <string.h>

#include <gssapi.h>

#include "sample_comm.h"

void handle_connections(void *);
int run_acceptor(void*);
void receive_test_data(int peer_socket, gss_ctx_id_t context_handle) ;

main(int argc, char **argv)
{
  
  const char this_function[] = "main()";
  /* needed for comm. */
  int port;
  int acceptor_socket;



  if (argc==1) {
    printf("type in port number to use for acceptor: ");
    scanf("%d", &port);
  } else {
    port = DEFAULT_PORT ;
  }
  printf("Server listening on port: %d\n", port) ;

  /* open communication link and start listening. */

  acceptor_socket=setup_connection(port);
  handle_connections((void *) acceptor_socket);

} /* main */

void handle_connections(void *opq)
{
  char this_function[] = "handle_connections";
  int my_socket = (int) opq;
  int s;

  while(1) {
    s = establish_connection(my_socket);
    if (s >= 0) {

#ifdef DEBUG
      fprintf(stderr,
	      "N %s: got connection, s = %d\n", this_function, s);
#endif

      run_acceptor((void *)s);

#ifdef DEBUG
      fprintf(stderr,
	      "N %s: Acceptor done. Listening for next.\n", this_function) ;
#endif

    } else
      {
	fprintf(stderr,"W %s: didn't get connection, s = %d\n",
		this_function, s);
      }
  }
} /* handle_connections () */

int run_acceptor (void *opq)
{
  char this_function[] = "run_acceptor";


  int                            acceptor_socket;


  gss_cred_id_t                  credential_handle;
  gss_buffer_t                   input_token, output_token;
  gss_buffer_desc                input_token_desc, output_token_desc;
  gss_ctx_id_t                   context_handle;
  gss_name_t                     initiator_name;

  struct sockaddr_in             socket_address;
  int                            msg_result ;
  OM_uint32                      major_status = 0, minor_status=0 ;

  size_t socket_address_size =   sizeof(socket_address);

  output_token =                 &output_token_desc ;
  input_token =                  &input_token_desc ;

#ifdef DEBUG
  fprintf(stderr,"N %s: initiated on %d\n", this_function, (int) opq) ;
#endif

  acceptor_socket = (int) opq;
  context_handle = GSS_C_NO_CONTEXT ;
  credential_handle = GSS_C_NO_CREDENTIAL ;

  do {

#ifdef DEBUG
    fprintf(stderr,
	    "N %s: Looping while GSS_S_CONTINUE_NEEDED\n", 
	    this_function) ;
#endif

    msg_result = receive_message(acceptor_socket,
				 context_handle,
				 input_token,
				 0) ;
    if ( msg_result < 0 ) {
      fprintf(stderr,
	      "E %s: Could not receive message.\n",
	      this_function) ;
      gss_delete_sec_context(&minor_status,
			     &context_handle,
			     input_token) ;
      close(acceptor_socket) ;
      exit(1) ;
    }	


#ifdef DEBUG
        fprintf(stderr,
		"N %s: received input token: [%d]\n", 
		this_function, input_token->length) ;
#endif /* DEBUG */
	
    major_status = gss_accept_sec_context(&minor_status,
					  &context_handle,
					  credential_handle,
					  input_token,
					  GSS_C_NO_CHANNEL_BINDINGS,
					  &initiator_name,
					  NULL,
					  output_token,
					  NULL,
					  NULL,
					  NULL);
	
	
    if (GSS_ERROR(major_status)) {
      fprintf(stderr, 
	      "E %s: major_status = %d, minor_status = %d, token = [%d]\n",
	      this_function, major_status,
	      minor_status, output_token->length); 
    }


    if (output_token->length != 0) {
      {				/* send token to initiator */

	
#ifdef DEBUG
        fprintf(stderr,
		"N %s: sending output token: [%d]\n", 
		this_function, output_token->length) ;
#endif /* DEBUG */

	msg_result = send_message(acceptor_socket,
				  context_handle,
				  output_token,
				  0,
				  0) ;
	if ( msg_result < 0 ) {
	  OM_uint32 inv_minor_status = 0 , inv_major_status = 0 ;
	  fprintf(stderr,
		  "E %s: Could not send message.\n",
		  this_function) ;
	  inv_major_status = gss_delete_sec_context(&inv_minor_status,
						    &context_handle,
						    output_token) ;
	  close(acceptor_socket) ;
	  exit(1) ;
	}
      } /* send token to initiator */
      {				/* release buffer */
	OM_uint32 inv_minor_status = 0 , inv_major_status = 0 ;
	inv_major_status = gss_release_buffer(&inv_minor_status,
					      output_token) ;

      } /* release buffer */
    }



	
    if (GSS_ERROR(major_status)) { 
      if (context_handle != GSS_C_NO_CONTEXT) {
	OM_uint32 inv_minor_status = 0 , inv_major_status = 0 ;	  
	inv_major_status = gss_delete_sec_context(&inv_minor_status,
						  &context_handle,
						  GSS_C_NO_BUFFER);
	break ;
	  
      }

    }

  } while (major_status & GSS_S_CONTINUE_NEEDED) ;

  if (major_status == GSS_S_COMPLETE) {

#ifdef DEBUG
    fprintf(stderr,"N %s: security context accepted\n", this_function) ;
#endif


    receive_test_data(acceptor_socket, context_handle) ;


#ifdef DEBUG
    fprintf(stderr,"N %s: security context being shutdown\n", this_function) ;
#endif  
  

    {				/* cleanup security context */
      OM_uint32 inv_minor_status = 0 , inv_major_status = 0 ;	      
      inv_major_status = gss_delete_sec_context(&inv_minor_status,
						&context_handle,
						GSS_C_NO_BUFFER);

    }

  } else {
#ifdef DEBUG
    fprintf(stderr,"N %s: security context DENIED\n", this_function) ;
#endif /* DEBUG */
  }


  return 0 ;
} /* run_acceptor() */



void receive_test_data(int peer_socket, gss_ctx_id_t context_handle)
{
  const char this_function[] = "receive_test_data()";

  OM_uint32 minor_status ;
  gss_buffer_desc input_message_buffer ;
  int msg_result ;

#ifdef DEBUG
  fprintf(stderr, 
	      "N %s: Waiting for test data to be sent on %d\r\n", 
	      this_function, peer_socket) ;
#endif /* DEBUG */
  
  msg_result = receive_message(peer_socket,
			       context_handle,
			       &input_message_buffer, 
			       1) ;

  if ( msg_result < 0 ) {
    fprintf(stderr,
	    "E %s: Could not receive message.\n",
	    this_function) ;
    gss_delete_sec_context(&minor_status,
			   &context_handle,
			   &input_message_buffer) ;
    close(peer_socket) ;
    exit(1) ;
  }
  /* send back what we just got but leave it unencrypted and unwrapped. */

  msg_result = send_message(peer_socket,
			    context_handle,
			    &input_message_buffer,
			    1,
			    0) ;
  if ( msg_result < 0 ) {
    fprintf(stderr,
	    "E %s: Could not send message.\n",
	    this_function) ;
    gss_delete_sec_context(&minor_status,
			   &context_handle,
			   &input_message_buffer) ;
    close(peer_socket) ;
    exit(1) ;
  }

  gss_release_buffer(&minor_status, &input_message_buffer) ;

}
