#
# WIN32 makefile: use with  'nmake -f gsi.mak'
#

# The SOURCE directory of the SSLeay-0.9.0 tree 
# or the OpenSSL-0.9.[456] (where you have presumedly
# already made a build for WIN32).
#
SSL_SRC=c:\OpenSSL-0.9.6\src

# Compiler (this will use Microsoft Visual C++, run VCVARS32.BAT in the
#           bin directory of that distribution to compiler correctly in
#           a DOS window)
CC=cl

##########################################################################
####
#### NOTE NOTE NOTE NOTE
####
#### If you don't want extra features (Smartcard and/or Kerberos5 support),
#### you do not need to edit anything below this comment.
####
##########################################################################



# The source directory
#
SRC_D=.


# SSLeay/OpenSSL options
#
SSL_LIB=$(SSL_SRC)\out32dll
SSL_INC=-I$(SSL_SRC)\inc32\openssl \
		-I$(SSL_SRC)\inc32 -I$(SSL_SRC)\crypto -I$(SSL_SRC)\ssl
L_SSL=     $(SSL_LIB)\ssleay32.lib
L_CRYPTO=  $(SSL_LIB)\libeay32.lib

#
# Change the following of you are building with smartcards
# No SDK is needed. PKCS#11 header files obtained from RSA
# are included, See:
#  http://www.rsasecurity.con/rsalabs/pkcs/pkcs-11/index.html
# Use version 2.01
# This should then work with any Netscape Security Module, which 
# implement PKCS#11.  Have tried with Litronic NetSign. 
#
# Set the registry entry for:
# HKEY_CURRENT_USER software\Globus\GSI
#  PKCS11.DLL = "Core32.dll" 
# (Core32.dll is the Litronic NetSign DLL for this. Use your 
# providers Security Module Name here.) 
# In the future, this will be added to wgpi)
#
# The with smartcard can be used on systems with out a smartcard
# The only difference is the extra entries in the gsilib32.dll
# and the scload.exe is built. 
#
#Use these without smartcard
#
#SC_OBJ=
#SC_FLAGS=
#SC_EXE=  
#SC_OUT=
#SC_GSI_LIB_DEF=
#
#Use these with the smart cards and PKCS11
#
SC_OBJ= $(OBJ_D)\scutils.obj
SC_FLAGS= -DUSE_PKCS11 
SC_EXE=$(BIN_D)\scload.exe  
SC_GSI_LIB_DEF=.SC
#
# if you want to build with and without, and keep them seperate
# uncomment this:
#SC_OUT=.SC
#
#----------------------------------------------------------------------
#
# Change the following if you want the sslk5 
#
#Use these without Kerberos from MIT, i.e. to build only gss
K5B=
K5S=
K5U=
K5I=
K5L=
K5_OBJ=
K5_EXE=

# The Kerberos source from MIT. 
#K5B=c:\k510\nt20n\k32
#K5S=$(K5B)\lib\krb5\krb
#K5U=$(K5B)\util\windows
#K5I=-I$(K5B)\include -I$(K5B)\include\krb5 -I$(K5B)\lib\krb5\os
#K5L=$(K5B)\lib\krb5_32.lib $(K5B)\lib\comerr32.lib 
#K5_OBJ= $(OBJ_D)\sslk5.obj $(OBJ_D)\sendto_kdcx.obj
#K5_EXE=$(BIN_D)\sslk5.exe



#-----------------------------------------------------------------------------
# The real gssapi32 DLL

SSL_GSS =  gssapi32

O_SSL_GSS = $(LIB_D)\$(SSL_GSS).dll
SO_SSL_GSS = $(SSL_GSS)
L_SSL_GSS = $(LIB_D)\$(SSL_GSS).lib
M_SSL_GSS = $(LIB_D)\$(SSL_GSS).map
D_SSL_GSS = $(SRC_D)\gssapi_ssleay\$(SSL_GSS).def

# A gssapi32 which converts the C- calling convention to stdcall
# Used with SecureCRT 2.4 (We told them the wrong calling conventions
# and wrong dll name.) 
# We are expecting them to convert, and user gssapi32.dll as well. 

SSL_GSS_CONV =  gsigss32

O_SSL_GSS_CONV = $(LIB_D)\$(SSL_GSS_CONV).dll
SO_SSL_GSS_CONV = $(SSL_GSS_CONV)
L_SSL_GSS_CONV = $(LIB_D)\$(SSL_GSS_CONV).lib
M_SSL_GSS_CONV = $(LIB_D)\$(SSL_GSS_CONV).map
D_SSL_GSS_CONV = $(SRC_D)\gssapi_ssleay\$(SSL_GSS_CONV).def

# A gssapi32 which will choose between gssapi32gsi.dll and
# gssapik5.dll. Used when you have both GSI and Kerberos V5
# applications. This is a quick hack to allow the few of us
# using both to continue. It uses a MessageBox to choose. 
# It should be replaced by the gssapi "mechglue" at some time.  
#
# To use this, rename:
#		the MIT Kerberos gssapi32.dll to gssapi32k5.dll
#		the GSI gssapi32.dll          to gssapi32gsi.dll
#       this choose gssapi32c.dll	  to gssapi32.dll
#
# (use the same def as the gssapi32)

SSL_GSS_CHOOSE =  gssapi32c 

O_SSL_GSS_CHOOSE = $(LIB_D)\$(SSL_GSS_CHOOSE).dll
SO_SSL_GSS_CHOOSE = $(SSL_GSS_CHOOSE)
L_SSL_GSS_CHOOSE = $(LIB_D)\$(SSL_GSS_CHOOSE).lib
M_SSL_GSS_CHOOSE = $(LIB_D)\$(SSL_GSS_CHOOSE).map
D_SSL_GSS_CHOOSE = $(SRC_D)\gssapi_ssleay\$(SSL_GSS).def

# Other gsi routines shared among the many programs. 
GSI_LIB = gsilib32

O_GSI_LIB = $(LIB_D)\$(GSI_LIB).dll
SO_GSI_LIB = $(GSI_LIB)
L_GSI_LIB = $(LIB_D)\$(GSI_LIB).lib
M_GSI_LIB = $(LIB_D)\$(GSI_LIB).map
D_GSI_LIB = $(SRC_D)\gssapi_ssleay\$(GSI_LIB)$(SC_GSI_LIB_DEF).def

# GAA routines
GAA_LIB = gaalib32

O_GAA_LIB = $(LIB_D)\$(GAA_LIB).dll
SO_GAA_LIB = $(GAA_LIB)
L_GAA_LIB = $(LIB_D)\$(GAA_LIB).lib
M_GAA_LIB = $(LIB_D)\$(GAA_LIB).map
D_GAA_LIB = $(SRC_D)\gaa\$(GAA_LIB).def

L_LIBS= $(L_SSL) $(L_CRYPTO) $(L_GSI_LIB) $(L_GAA_LIB)


LINK=link
LFLAGS=/nologo /subsystem:console /machine:I386 /opt:ref
WLFLAGS=/nologo /subsystem:windows /machine:I386 /opt:ref 


# The output directory for everything intersting
OUT_D=out32$(SC_OUT)
# The output directory for all the temporary muck
TMP_D=tmp32$(SC_OUT)
# The output directory for the header files
INC_D=inc32$(SC_OUT)

CP=copy
RM=del
RC=rc
RANLIB=
MKDIR=mkdir
MKLIB=lib
MLFLAGS= /nologo /subsystem:console /machine:I386 /opt:ref /dll

# Compiler flags...
#
CFLAG=  /MD /W3     /G5 /Ox /O2 /Ob2 /Gs0 /GF /Gy /nologo -DWIN32 -DWIN32_LEAN_AND_MEAN -DL_ENDIAN
APP_CFLAG= -DNO_GSSAPI_CONFIG_H -DSSLK5 -D_WIN32 -DWINDOWS  
LIB_CFLAG= /GD -D_WINDLL -D_DLL -DNO_GLOBUS_CONFIG_H -DNO_GSSAPI_CONFIG_H -DSTDC_HEADERS -DHAVE_STDARG_H
CA_POLICY_FLAG=
SHLIB_CFLAG=
APP_EX_OBJ=setargv.obj
SHLIB_EX_OBJ=

EX_LIBS=wsock32.lib user32.lib gdi32.lib advapi32.lib

######################################################
# 
######################################################

# BIN_D  - Binary output directory
BIN_D=$(OUT_D)

# OBJ_D  - temp object file directory
OBJ_D=$(TMP_D)

# LIB_D - Library object directory
LIB_D= $(OUT_D)

######################################################
# 
######################################################

INC=-I$(INC_D) $(SSL_INC) 
#
# Can also add -DDEBUG to the next three lines to print to stderr
#
APP_CFLAGS=$(INC) $(CFLAG) $(APP_CFLAG) 
LIB_CFLAGS=$(INC) $(CFLAG) $(LIB_CFLAG) 
KAPP_CFLAGS=$(INC) $(CFLAG) $(APP_CFLAG) $(K5I)  
LIBS_DEP = $(O_SSL_GSS) $(O_SSL_GSS_CONV)
RFLAGS=$(INC)


#############################################

HEADER=$(INC_D)\sslutils.h \
		$(INC_D)\winglue.h \
		$(INC_D)\gssapi.h \
		$(INC_D)\globus_gaa.h \
		$(INC_D)\globus_gaa_utils.h \
		$(INC_D)\gaa_utils.h \
		$(INC_D)\gaa_policy_evaluator.h \
		$(INC_D)\scutils.h \
		$(INC_D)\pkcs11.h \
		$(INC_D)\pkcs11t.h \
		$(INC_D)\pkcs11f.h

E_OBJ=$(OBJ_D)\grid-proxy-init.obj \
	$(OBJ_D)\certdump.obj \
	$(OBJ_D)\grid-proxy-destroy.obj  \
	$(K5_OBJ)

GSI_LIBOBJ=$(OBJ_D)\sslutils.obj \
	$(OBJ_D)\winglue.obj \
	$(SC_OBJ)

GAA_LIBOBJ=$(OBJ_D)\gnu_regex.obj \
	$(OBJ_D)\rfc1779.obj \
	$(OBJ_D)\gaa_gl_internal_err.obj \
	$(OBJ_D)\gaa_api.obj \
	$(OBJ_D)\gaa_alloc.obj \
	$(OBJ_D)\gaa_release.obj \
	$(OBJ_D)\gaa_utils.obj \
	$(OBJ_D)\globus_gaa_utils.obj \
	$(OBJ_D)\gaa_policy_evaluator.obj

SSL_GSSOBJ= $(OBJ_D)\accept_sec_context.obj \
			$(OBJ_D)\acquire_cred.obj \
			$(OBJ_D)\compare_name.obj \
			$(OBJ_D)\delete_sec_context.obj \
			$(OBJ_D)\display_name.obj \
			$(OBJ_D)\display_status.obj \
			$(OBJ_D)\export_name.obj \
			$(OBJ_D)\export_sec_context.obj \
			$(OBJ_D)\get_mic.obj \
			$(OBJ_D)\gsserr.obj \
			$(OBJ_D)\gssutils.obj \
			$(OBJ_D)\import_name.obj \
			$(OBJ_D)\import_sec_context.obj \
			$(OBJ_D)\init_sec_context.obj \
			$(OBJ_D)\inquire_cred.obj \
			$(OBJ_D)\inquire_context.obj \
			$(OBJ_D)\release_cred.obj \
			$(OBJ_D)\release_name.obj \
			$(OBJ_D)\unwrap.obj \
			$(OBJ_D)\verify_mic.obj \
			$(OBJ_D)\wrap.obj \
			$(OBJ_D)\import_cred.obj \
			$(OBJ_D)\export_cred.obj \
			$(OBJ_D)\release_buffer.obj \
			$(OBJ_D)\oid_functions.obj \
			$(OBJ_D)\gssapi_working.obj

SSL_GSS_CONVOBJ = $(OBJ_D)\gsigss_conv.obj

SSL_GSS_CHOOSEOBJ = $(OBJ_D)\gss_mech_choose.obj

###################################################################
all: banner $(TMP_D) $(BIN_D) $(INC_D) headers obj lib exe


$(INC_D)\sslutils.h: $(SRC_D)\gssapi_ssleay\sslutils.h
        $(CP) $(SRC_D)\gssapi_ssleay\sslutils.h $(INC_D)\sslutils.h

$(INC_D)\scutils.h: $(SRC_D)\gssapi_ssleay\scutils.h
        $(CP) $(SRC_D)\gssapi_ssleay\scutils.h $(INC_D)\scutils.h

$(INC_D)\gssapi.h: $(SRC_D)\gssapi_ssleay\gssapi.hin
        $(CP) $(SRC_D)\gssapi_ssleay\gssapi.hin $(INC_D)\gssapi.h

$(INC_D)\winglue.h: $(SRC_D)\gssapi_ssleay\winglue.h
        $(CP) $(SRC_D)\gssapi_ssleay\winglue.h $(INC_D)\winglue.h

$(INC_D)\pkcs11.h: $(SRC_D)\gssapi_ssleay\pkcs11.h
        $(CP) $(SRC_D)\gssapi_ssleay\pkcs11.h $(INC_D)\pkcs11.h

$(INC_D)\pkcs11t.h: $(SRC_D)\gssapi_ssleay\pkcs11t.h
        $(CP) $(SRC_D)\gssapi_ssleay\pkcs11t.h $(INC_D)\pkcs11t.h

$(INC_D)\pkcs11f.h: $(SRC_D)\gssapi_ssleay\pkcs11f.h
        $(CP) $(SRC_D)\gssapi_ssleay\pkcs11f.h $(INC_D)\pkcs11f.h

$(INC_D)\globus_gaa.h: $(SRC_D)\gaa\globus_gaa.h
        $(CP) $(SRC_D)\gaa\globus_gaa.h $(INC_D)\globus_gaa.h

$(INC_D)\globus_gaa_utils.h: $(SRC_D)\gaa\globus_gaa_utils.h
        $(CP) $(SRC_D)\gaa\globus_gaa_utils.h $(INC_D)\globus_gaa_utils.h

$(INC_D)\gaa_utils.h: $(SRC_D)\gaa\gaa_utils.h
        $(CP) $(SRC_D)\gaa\gaa_utils.h $(INC_D)\gaa_utils.h

$(INC_D)\gaa_policy_evaluator.h: $(SRC_D)\gaa\gaa_policy_evaluator.h
        $(CP) $(SRC_D)\gaa\gaa_policy_evaluator.h $(INC_D)\gaa_policy_evaluator.h

# application objects 

$(OBJ_D)\grid-proxy-init.obj: $(SRC_D)\gssapi_ssleay\grid_proxy_init.c
        $(CC) /Fo$(OBJ_D)\grid-proxy-init.obj $(APP_CFLAGS) $(SC_FLAGS) -c $(SRC_D)\gssapi_ssleay\grid_proxy_init.c

$(OBJ_D)\grid-proxy-destroy.obj: $(SRC_D)\gssapi_ssleay\grid_proxy_destroy.c
        $(CC) /Fo$(OBJ_D)\grid-proxy-destroy.obj $(APP_CFLAGS) $(SC_FLAGS) -c $(SRC_D)\gssapi_ssleay\grid_proxy_destroy.c

$(OBJ_D)\scload.obj: $(SRC_D)\gssapi_ssleay\scload.c
        $(CC) /Fo$(OBJ_D)\scload.obj $(APP_CFLAGS) $(SC_FLAGS) -c $(SRC_D)\gssapi_ssleay\scload.c

$(OBJ_D)\certdump.obj: $(SRC_D)\gssapi_ssleay\certdump.c
        $(CC) /Fo$(OBJ_D)\certdump.obj $(APP_CFLAGS) $(SC_FLAGS) -c $(SRC_D)\gssapi_ssleay\certdump.c

# gsigss32 objects 

$(OBJ_D)\gsigss_conv.obj: $(SRC_D)\gssapi_ssleay\gsigss_conv.c
	$(CC) /Fo$(OBJ_D)\gsigss_conv.obj $(LIB_CFLAGS) -c $(SRC_D)\gssapi_ssleay\gsigss_conv.c

# gssapi32c objects

$(OBJ_D)\gss_mech_choose.obj: $(SRC_D)\gssapi_ssleay\gss_mech_choose.c
	$(CC) /Fo$(OBJ_D)\gss_mech_choose.obj $(LIB_CFLAGS) -c $(SRC_D)\gssapi_ssleay\gss_mech_choose.c

# gsilib32 objects 

$(OBJ_D)\sslutils.obj: $(SRC_D)\gssapi_ssleay\sslutils.c
        $(CC) /Fo$(OBJ_D)\sslutils.obj $(LIB_CFLAGS) $(CA_POLICY_FLAG) $(SC_FLAGS) -c $(SRC_D)\gssapi_ssleay\sslutils.c

$(OBJ_D)\winglue.obj: $(SRC_D)\gssapi_ssleay\winglue.c
        $(CC) /Fo$(OBJ_D)\winglue.obj $(LIB_CFLAGS) $(SC_FLAGS) -c $(SRC_D)\gssapi_ssleay\winglue.c

$(OBJ_D)\scutils.obj: $(SRC_D)\gssapi_ssleay\scutils.c
	$(CC) /Fo$(OBJ_D)\scutils.obj $(LIB_CFLAGS) $(SC_FLAGS) -c $(SRC_D)\gssapi_ssleay\scutils.c

$(OBJ_D)\globus_gaa_utils.obj: $(SRC_D)\gaa\globus_gaa_utils.c
        $(CC) /Fo$(OBJ_D)\globus_gaa_utils.obj $(LIB_CFLAGS) -c $(SRC_D)\gaa\globus_gaa_utils.c

# gaalib32 objects

$(OBJ_D)\gaa_gl_internal_err.obj: $(SRC_D)\gaa\gaa_gl_internal_err.c
        $(CC) /Fo$(OBJ_D)\gaa_gl_internal_err.obj $(LIB_CFLAGS) -c $(SRC_D)\gaa\gaa_gl_internal_err.c

$(OBJ_D)\rfc1779.obj: $(SRC_D)\gaa\rfc1779.c
        $(CC) /Fo$(OBJ_D)\rfc1779.obj $(LIB_CFLAGS) $(SC_FLAGS) -c $(SRC_D)\gaa\rfc1779.c

$(OBJ_D)\gnu_regex.obj: $(SRC_D)\gaa\gnu_regex.c
        $(CC) /Fo$(OBJ_D)\gnu_regex.obj $(LIB_CFLAGS) -c $(SRC_D)\gaa\gnu_regex.c

$(OBJ_D)\gaa_alloc.obj: $(SRC_D)\gaa\gaa_alloc.c
        $(CC) /Fo$(OBJ_D)\gaa_alloc.obj $(LIB_CFLAGS) -c $(SRC_D)\gaa\gaa_alloc.c

$(OBJ_D)\gaa_release.obj: $(SRC_D)\gaa\gaa_release.c
        $(CC) /Fo$(OBJ_D)\gaa_release.obj $(LIB_CFLAGS) -c $(SRC_D)\gaa\gaa_release.c

$(OBJ_D)\gaa_utils.obj: $(SRC_D)\gaa\gaa_utils.c
        $(CC) /Fo$(OBJ_D)\gaa_utils.obj $(LIB_CFLAGS) -c $(SRC_D)\gaa\gaa_utils.c

$(OBJ_D)\gaa_api.obj: $(SRC_D)\gaa\gaa_api.c
        $(CC) /Fo$(OBJ_D)\gaa_api.obj $(LIB_CFLAGS) -c $(SRC_D)\gaa\gaa_api.c

$(OBJ_D)\gaa_policy_evaluator.obj: $(SRC_D)\gaa\gaa_policy_evaluator.c
        $(CC) /Fo$(OBJ_D)\gaa_policy_evaluator.obj $(LIB_CFLAGS) -c $(SRC_D)\gaa\gaa_policy_evaluator.c

# gsiapi32 objects 

$(OBJ_D)\accept_sec_context.obj: $(SRC_D)\gssapi_ssleay\accept_sec_context.c
	$(CC) /Fo$(OBJ_D)\accept_sec_context.obj $(LIB_CFLAGS) -c $(SRC_D)\gssapi_ssleay\accept_sec_context.c

$(OBJ_D)\acquire_cred.obj: $(SRC_D)\gssapi_ssleay\acquire_cred.c
	$(CC) /Fo$(OBJ_D)\acquire_cred.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\acquire_cred.c

$(OBJ_D)\compare_name.obj: $(SRC_D)\gssapi_ssleay\compare_name.c
	$(CC) /Fo$(OBJ_D)\compare_name.obj $(LIB_CFLAGS) -c $(SRC_D)\gssapi_ssleay\compare_name.c

$(OBJ_D)\delete_sec_context.obj: $(SRC_D)\gssapi_ssleay\delete_sec_context.c
	$(CC) /Fo$(OBJ_D)\delete_sec_context.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\delete_sec_context.c

$(OBJ_D)\display_name.obj: $(SRC_D)\gssapi_ssleay\display_name.c
	$(CC) /Fo$(OBJ_D)\display_name.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\display_name.c

$(OBJ_D)\display_status.obj: $(SRC_D)\gssapi_ssleay\display_status.c
	$(CC) /Fo$(OBJ_D)\display_status.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\display_status.c

$(OBJ_D)\export_name.obj: $(SRC_D)\gssapi_ssleay\export_name.c
	$(CC) /Fo$(OBJ_D)\export_name.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\export_name.c

$(OBJ_D)\export_sec_context.obj: $(SRC_D)\gssapi_ssleay\export_sec_context.c
	$(CC) /Fo$(OBJ_D)\export_sec_context.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\export_sec_context.c

$(OBJ_D)\get_mic.obj: $(SRC_D)\gssapi_ssleay\get_mic.c
	$(CC) /Fo$(OBJ_D)\get_mic.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\get_mic.c

$(OBJ_D)\gsserr.obj: $(SRC_D)\gssapi_ssleay\gsserr.c
	$(CC) /Fo$(OBJ_D)\gsserr.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\gsserr.c

$(OBJ_D)\gssutils.obj: $(SRC_D)\gssapi_ssleay\gssutils.c
	$(CC) /Fo$(OBJ_D)\gssutils.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\gssutils.c

$(OBJ_D)\import_name.obj: $(SRC_D)\gssapi_ssleay\import_name.c
	$(CC) /Fo$(OBJ_D)\import_name.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\import_name.c

$(OBJ_D)\import_sec_context.obj: $(SRC_D)\gssapi_ssleay\import_sec_context.c
	$(CC) /Fo$(OBJ_D)\import_sec_context.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\import_sec_context.c

$(OBJ_D)\init_sec_context.obj: $(SRC_D)\gssapi_ssleay\init_sec_context.c
	$(CC) /Fo$(OBJ_D)\init_sec_context.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\init_sec_context.c

$(OBJ_D)\inquire_cred.obj: $(SRC_D)\gssapi_ssleay\inquire_cred.c
	$(CC) /Fo$(OBJ_D)\inquire_cred.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\inquire_cred.c

$(OBJ_D)\inquire_context.obj: $(SRC_D)\gssapi_ssleay\inquire_context.c
	$(CC) /Fo$(OBJ_D)\inquire_context.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\inquire_context.c

$(OBJ_D)\release_buffer.obj: $(SRC_D)\gssapi_ssleay\release_buffer.c
	$(CC) /Fo$(OBJ_D)\release_buffer.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\release_buffer.c

$(OBJ_D)\release_cred.obj: $(SRC_D)\gssapi_ssleay\release_cred.c
	$(CC) /Fo$(OBJ_D)\release_cred.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\release_cred.c

$(OBJ_D)\release_name.obj: $(SRC_D)\gssapi_ssleay\release_name.c
	$(CC) /Fo$(OBJ_D)\release_name.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\release_name.c

$(OBJ_D)\unwrap.obj: $(SRC_D)\gssapi_ssleay\unwrap.c
	$(CC) /Fo$(OBJ_D)\unwrap.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\unwrap.c

$(OBJ_D)\verify_mic.obj: $(SRC_D)\gssapi_ssleay\verify_mic.c
	$(CC) /Fo$(OBJ_D)\verify_mic.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\verify_mic.c

$(OBJ_D)\wrap.obj: $(SRC_D)\gssapi_ssleay\wrap.c
	$(CC) /Fo$(OBJ_D)\wrap.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\wrap.c

$(OBJ_D)\import_cred.obj: $(SRC_D)\gssapi_ssleay\import_cred.c
	$(CC) /Fo$(OBJ_D)\import_cred.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\import_cred.c

$(OBJ_D)\export_cred.obj: $(SRC_D)\gssapi_ssleay\export_cred.c
	$(CC) /Fo$(OBJ_D)\export_cred.obj $(LIB_CFLAGS)  -c $(SRC_D)\gssapi_ssleay\export_cred.c

$(OBJ_D)\gssapi_working.obj: $(SRC_D)\gssapi_ssleay\gssapi_working.c
	$(CC) /Fo$(OBJ_D)\gssapi_working.obj $(LIB_CFLAGS) -c $(SRC_D)\gssapi_ssleay\gssapi_working.c

$(OBJ_D)\oid_functions.obj: $(SRC_D)\gssapi_ssleay\oid_functions.c
        $(CC) /Fo$(OBJ_D)\oid_functions.obj $(LIB_CFLAGS) -c $(SRC_D)\gssapi_ssleay\oid_functions.c

# END OF LIB ROUTINES

$(OBJ_D)\sslk5.obj: $(SRC_D)\gssapi_ssleay\sslk5\sslk5.c
        $(CC) /Fo$(OBJ_D)\sslk5.obj $(KAPP_CFLAGS) $(SC_FLAGS) -c $(SRC_D)\gssapi_ssleay\sslk5\sslk5.c

$(OBJ_D)\sendto_kdcx.obj: $(SRC_D)\gssapi_ssleay\sslk5\sendto_kdcx.c
        $(CC) /Fo$(OBJ_D)\sendto_kdcx.obj $(KAPP_CFLAGS) -c $(SRC_D)\gssapi_ssleay\sslk5\sendto_kdcx.c


$(BIN_D)\grid-proxy-init.exe: $(OBJ_D)\grid-proxy-init.obj 
  $(LINK) $(LFLAGS) /out:$(BIN_D)\grid-proxy-init.exe @<< 
  $(APP_EX_OBJ) $(OBJ_D)\grid-proxy-init.obj $(L_LIBS) $(EX_LIBS)
<<

$(BIN_D)\scload.exe: $(OBJ_D)\scload.obj
  $(LINK) $(LFLAGS) /out:$(BIN_D)\scload.exe @<< 
  $(APP_EX_OBJ) $(OBJ_D)\scload.obj $(L_LIBS) $(EX_LIBS)
<<

$(BIN_D)\certdump.exe: $(OBJ_D)\certdump.obj 
  $(LINK) $(LFLAGS) /out:$(BIN_D)\certdump.exe @<< 
  $(APP_EX_OBJ) $(OBJ_D)\certdump.obj $(L_LIBS) $(EX_LIBS)
<<

$(BIN_D)\grid-proxy-destroy.exe: $(OBJ_D)\grid-proxy-destroy.obj 
  $(LINK) $(LFLAGS) /out:$(BIN_D)\grid-proxy-destroy.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\grid-proxy-destroy.obj $(L_LIBS) $(EX_LIBS)
<< 

$(BIN_D)\sslk5.exe: $(OBJ_D)\sslk5.obj $(OBJ_D)\sendto_kdcx.obj 
  $(LINK) $(LFLAGS) /out:$(BIN_D)\sslk5.exe @<<
  $(APP_EX_OBJ) $(OBJ_D)\sslk5.obj $(OBJ_D)\sendto_kdcx.obj $(K5U)\getopt.obj $(K5L) $(L_LIBS) $(EX_LIBS)
<<

#
# for DLLs, SSLeay does not specify the base so gets the default
# Kerberos uses 0x1c000000 for the default, but not for the gssapi? 
# So we will pick 0x1800000 and 0x19000000 which should fit well. 
#
$(O_GSI_LIB): $(GSI_LIBOBJ) $(O_GAA_LIB)
        $(LINK) $(MLFLAGS) /base:0x18000000 /out:$(O_GSI_LIB) /def:$(D_GSI_LIB) /MAP:$(M_GSI_LIB) @<<
	$(SHLIB_EX_OBJ) $(GSI_LIBOBJ) $(L_GAA_LIB) $(L_CRYPTO) $(L_SSL) $(EX_LIBS) 
<<

$(O_SSL_GSS): $(SSL_GSSOBJ) $(O_GSI_LIB)
        $(LINK) $(MLFLAGS) /base:0x19000000 /out:$(O_SSL_GSS) /def:$(D_SSL_GSS) /MAP:$(M_SSL_GSS) @<<
	$(SHLIB_EX_OBJ) $(SSL_GSSOBJ) $(L_CRYPTO) $(L_SSL) $(L_GSI_LIB) $(EX_LIBS)
<<

$(O_SSL_GSS_CONV): $(SSL_GSS_CONVOBJ) 
        $(LINK) $(MLFLAGS) /base:0x1a0000000 /out:$(O_SSL_GSS_CONV) /def:$(D_SSL_GSS_CONV) /MAP:$(M_SSL_GSS_CONV) @<<
	$(SHLIB_EX_OBJ) $(SSL_GSS_CONVOBJ) $(EX_LIBS)
<<

$(O_SSL_GSS_CHOOSE): $(SSL_GSS_CHOOSEOBJ) 
        $(LINK) $(MLFLAGS) /base:0x1a8000000 /out:$(O_SSL_GSS_CHOOSE) /def:$(D_SSL_GSS_CHOOSE) /MAP:$(M_SSL_GSS_CHOOSE) @<<
	$(SHLIB_EX_OBJ) $(SSL_GSS_CHOOSEOBJ) $(EX_LIBS)
<<

$(O_GAA_LIB): $(GAA_LIBOBJ) 
        $(LINK) $(MLFLAGS) /base:0x1b000000 /out:$(O_GAA_LIB) /def:$(D_GAA_LIB) /MAP:$(M_GAA_LIB) @<<
	$(SHLIB_EX_OBJ) $(GAA_LIBOBJ) $(EX_LIBS) 
<<

banner:

$(TMP_D):
	$(MKDIR) $(TMP_D)

$(BIN_D):
        $(MKDIR) $(BIN_D)

$(INC_D):
	$(MKDIR) $(INC_D)

headers: $(HEADER)

lib: $(LIBS_DEP) $(O_SSL_GSS_CHOOSE)

obj: $(E_OBJ)

exe:  $(BIN_D)\grid-proxy-init.exe \
	$(BIN_D)\certdump.exe \
	$(BIN_D)\grid-proxy-destroy.exe \
	$(K5_EXE) \
	$(SC_EXE)

clean:
	$(RM) $(TMP_D)\*.*

vclean:
	$(RM) $(TMP_D)\*.*
	$(RM) $(OUT_D)\*.*
	$(RM) $(INC_D)\*.*


