/**********************************************************************

gaa_parse_policy.c

Description:
	Program used to check the syntax of the ca-siging-policy.conf
	file.

TODO:
	-Needs to handle commandline options (help, verbose, etc.)
	-Needs usage

**********************************************************************/


/**********************************************************************
                             Include header files
**********************************************************************/

#include "globus_gaa.h"
#include "globus_gaa_utils.h" 
#include "gaa_utils.h"

#include <string.h>	/* for strerror() */
#include <errno.h>
#include <stdlib.h>	/* for getenv() */

/**********************************************************************
                          Module specific prototypes
**********************************************************************/
static
void
print_policy(gaa_policy_ptr policy);

/********************************************************************/

int
main(int     argc,
     char ** argv)
{
  char *	        program       = argv[0];
  gaa_policy_ptr        policy_handle = NULL;
  gaa_data_ptr          policy_db     = NULL;
  gaa_error_code        gaa_status    = GAA_NO;
  uint32                minor_status  = 0; 	 

 
  gaa_status = gaa_globus_initialize(NULL,
                                     NULL,
                                     NULL,
                                    &policy_db,
                                     NULL, 
                                     NULL,
                                     NULL);

  if(gaa_status != GAA_SUCCESS) 
  {   
    fprintf(stderr, "%s: %s error code: %d\n",
	    program,
	    policy_db->error_str,
            policy_db->error_code);
     	      
    exit(1);
   }

  gaa_status = gaa_get_object_policy_info(&minor_status,
                                           NULL,
                                           policy_db,
                                           gaa_globus_policy_retrieve,
                                          &policy_handle);
  
    
   /* get policy */

   if(gaa_status == GAA_RETRIEVE_ERROR) 
   {
    fprintf(stderr, "%s: %s error code: %d\n",
	    program,
	    policy_db->error_str, 
	    policy_db->error_code); 
     	      
    exit(1);
   }

   print_policy(policy_handle);

  
  gaa_status = gaa_globus_cleanup(NULL,
                                  NULL,
                                  NULL,
                                  NULL,  
                                  policy_db,
                                  NULL);
   return gaa_status;
    
}
	
 /*****************************************************************************/

static
void
print_policy(gaa_policy_ptr policy)

{ 
 gaa_policy_ptr ptr = policy;

 fprintf(stderr,"\nprint_policy:\n\n");

   while(ptr)
  {
   fprintf(stderr, "PRINCIPAL\n");      
   fprintf(stderr, "type      : %s\n",   ptr->type);
   fprintf(stderr, "authority : %s\n",   ptr->authority);
   fprintf(stderr, "value     : %s\n\n", ptr->value);

   gaa_globus_print_rights(ptr->rights);

   ptr = ptr->next; 
  }
 
}
  
 /*****************************************************************************/
