/**********************************************************************

gaa_inquire_policy_info.c

Description:
	Program used to check the syntax of the ca-signing-policy.conf
	file.

TODO:
	-Needs to handle commandline options (help, verbose, etc.)

**********************************************************************/

/**********************************************************************
                             Include header files
**********************************************************************/

#include "globus_gaa.h" 
#include "globus_gaa_utils.h"
#include <errno.h> 

/**********************************************************************
                          Module specific prototypes
**********************************************************************/

int
main(int    argc,
     char **argv)
{
  policy_file_context_ptr   pcontext        = NULL;
  char                     *signer          = NULL;
  gaa_data_ptr              policy_db       = NULL;
  gaa_rights_ptr            rights          = NULL;
  gaa_rights_ptr            out_rights      = NULL;
  uint32                    minor_status    = 0;
  gaa_policy_ptr            policy_handle   = NULL;
  gaa_sec_context_ptr       gaa_sc          = NULL;  
  int                       badops          = 0;
  char                     *program         = NULL;
  int                       debug           = 0;
  char                     *argp            = NULL;
  char                     *outfile         = NULL;
  gaa_error_code            gaa_status      = GAA_NO;

  program = argv[0];

  if (argc < 2)
  {
    fprintf(stderr, "Usage: %s [options] <signer>\n", program);
    exit(1);
  }
    argc--;
    argv++;

	while (argc >= 1) {

	       argp = *argv;
           				
               if ( *argp == '-' && *(argp+1) == '-') {
			argp++;
		}
               else { signer = *argv; break;} 

		if  (strcmp(argp,"-debug") == 0) {
			debug++;
		}		
			
		else if (strcmp(argp,"-help") == 0) {
			badops=1;
			break;
		}
		else {
			fprintf(stderr,"unknown option %s\n",*argv);
			badops=1;
			break;
		}

		argc--;
		argv++;
	}

	if (badops) {
bad:
		fprintf(stderr,"%s [options] signer\n",program);
		fprintf(stderr,"where options  are\n");
		fprintf(stderr," -help    show this list\n");
		fprintf(stderr," -debug   set debugging on\n");     		
		exit(1);
	}

       if (!signer)
        {
          fprintf(stderr,"%s: signer is missing \n",program);
	  exit(1);
	}

    /* Allocate and fill in GAA data structures */

 gaa_status =  gaa_globus_initialize(&gaa_sc,
                                     &rights,
                                      NULL,
                                     &policy_db,
                                      signer, 
                                      NULL,
                                      NULL);


 if(gaa_status != GAA_SUCCESS) 
  {   
    fprintf(stderr, "%s: %s error code: %d\n",
	    program,
	    policy_db->error_str,
            policy_db->error_code);
     	      
    exit(1);
   }

  gaa_status = gaa_get_object_policy_info(&minor_status,
                                           NULL,
                                           policy_db,
                                           gaa_globus_policy_retrieve,
                                          &policy_handle);
      
  /* get policy */

 if(gaa_status == GAA_RETRIEVE_ERROR) 
   {
    fprintf(stderr, "%s: %s error code: %d\n",
	    program,
	    policy_db->error_str,
            policy_db->error_code);
     	      
    exit(1);
   }
 
     
   /* check if signer is allowed to sign certificates for subject */

   if(gaa_inquire_policy_info(&minor_status,   
                               gaa_sc,   
                               policy_handle,     
                              &out_rights) != GAA_SUCCESS) return GAA_FAILURE;

  if(out_rights) gaa_globus_print_rights(out_rights);
  else fprintf(stderr, "%s: no matching entry found\n", program);

  
  gaa_status = gaa_globus_cleanup(&gaa_sc,
                                  &out_rights,
                                  NULL,
                                  NULL,  
                                  policy_db,
                                  NULL);

  return gaa_status;

}
  
      
 /*****************************************************************************/
