/**********************************************************************
 gaa_check_policy.c


Description:
	Program used to check to see if a particular signature on a
	subject by a particular CA is valid according to the
	ca-signing-policy file.

TODO:
	-Needs to handle commandline options (help, verbose, etc.)

**********************************************************************/

/**********************************************************************
                             Include header files
**********************************************************************/

#include "globus_gaa.h" 
#include "globus_gaa_utils.h"
#include <errno.h> 

/**********************************************************************
                          Module specific prototypes
**********************************************************************/
void
gaa_globus_print_answer(gaa_answer_ptr answer);


/********************************************************************/

int
main(int    argc,
     char **argv)

{
  policy_file_context_ptr   pcontext        = NULL;
  char                     *signer          = NULL;
  char                     *subject         = NULL;
  char 			   *errstring       = NULL;
  gaa_data_ptr              policy_db       = NULL;
  gaa_rights_ptr            rights          = NULL;
  uint32                    minor_status    = 0;
  gaa_policy_ptr            policy_handle   = NULL;
  gaa_sec_context_ptr       gaa_sc          = NULL;  
  int                       badops          = 0;
  char                     *program         = NULL;
  int                       debug           = 0;
  char                     *argp            = NULL;
  char                     *outfile         = NULL;
  gaa_error_code            gaa_status      = GAA_FAILURE;
  gaa_answer_ptr            detailed_answer = NULL;
  gaa_options_ptr           options         = NULL;

  program = argv[0];

  if (argc != 3)
  {
    fprintf(stderr, "Usage: %s <signer> <subject>\n",
	    argv[0]);
    exit(1);
  }

  signer  = argv[1];
  subject = argv[2];

  gaa_status = gaa_globus_initialize(&gaa_sc,
                                    &rights,
                                    &options,
                                    &policy_db,
                                    signer, 
                                    subject, 
                                    NULL);

   if(gaa_status != GAA_SUCCESS) 
  {   
    fprintf(stderr, "%s: %s error code: %d\n",
	    program,
	    policy_db->error_str,
            policy_db->error_code);
     	      
    exit(1);
   }
 
 /* get policy */

  gaa_status = gaa_get_object_policy_info(&minor_status,
                                           NULL,
                                           policy_db,
                                           gaa_globus_policy_retrieve,
                                          &policy_handle);      
 

   if(gaa_status == GAA_RETRIEVE_ERROR) 
  {   
    fprintf(stderr, "%s: %s error code: %d\n",
	    program,
	    policy_db->error_str,
            policy_db->error_code);
     	      
    exit(1);
   }

#ifdef TEST_ATTRIBUTES
  {
     gaa_sec_attrb_ptr attributes = NULL; 
     gaa_status = gaa_globus_get_trusted_ca_list(&attributes,
                                                  policy_handle,
                                                  rights);

     if(attributes) gaa_globus_print_attributes(attributes);
     if(attributes)
      {
       gaa_globus_print_attributes(attributes);
       if (attributes->type != NULL)      free(attributes->type);
       if (attributes->authority != NULL) free(attributes->authority);
       if (attributes->value != NULL)     free(attributes->value);
       free(attributes);
      }
   }
#endif


   /* check if signer is allowed to sign certificates for subject */

    gaa_status = gaa_check_authorization (&minor_status,   
                                          gaa_sc,   
                                          policy_handle,     
                                          rights, 
                                          options,
                                          &detailed_answer
                                          );

   fprintf(stderr,"gaa_status %d (0 yes, 1 no, -1 maybe)\n", gaa_status); 

   if(detailed_answer) gaa_globus_print_answer(detailed_answer);

  gaa_status = gaa_globus_cleanup(&gaa_sc,
                                  &rights,
                                  options,
                                  &detailed_answer,  
                                  policy_db,
                                  NULL);

  return gaa_status;
}
  
      
 
/*****************************************************************************/

void
gaa_globus_print_answer(gaa_answer_ptr answer)

{ 
 fprintf(stderr, "\nprint detailed answer:\n\n");
 if(answer->rights) gaa_globus_print_rights(answer->rights);
}

   
 /*****************************************************************************/
 
