/*
 * globus_rsl_assist_test.c
 *
 * This program test the Globus RSL and RSL_assist libraries
 *
 * CVS Information:
 *
 * $Source: /home/globdev/CVS/globus-current/Globus/ResourceManagement/rsl_assist/tests/globus_rsl_assist_test.c,v $
 * $Date: 2000/03/29 23:36:28 $
 * $Revision: 1.11 $
 * $Author: smartin $
 */
#include "globus_common.h"
#include "globus_rsl_assist.h"
#include "globus_i_rsl_assist.h"

void
Usage()
{
    globus_libc_printf("Usage: %s ['rsl-string' | -list <dn> | -h]\n",
		       "globus_rsl_assist_test");
    globus_libc_printf("  -h          prints out this message\n");
    globus_libc_printf("  -list <dn>  prints out a list user <dn>'s jobs\n");
    globus_libc_printf("  If an rsl-string is specified, parse it\n");
    globus_libc_printf("  and display the parsed tree.\n");
} /* Usage() */

void
get_and_print_job_list(char *  userdn)
{
    int rc;
    globus_list_t *job_contact_list=GLOBUS_NULL;
    char* job_listing_entry=GLOBUS_NULL;
    
    rc = globus_i_rsl_assist_get_user_job_list(userdn,
					       &job_contact_list);

    if (rc!= GLOBUS_SUCCESS)
	globus_libc_printf("Failed to get list of jobs\n");

    if (job_contact_list==GLOBUS_NULL)
	return;

    while (!globus_list_empty(job_contact_list))
    {
	job_listing_entry =
	    globus_list_remove(&job_contact_list, job_contact_list);
	if (job_listing_entry==GLOBUS_NULL)
	{
	    globus_libc_printf("Internal Error: extracted "
			       "a NULL entry from none empty list...\n");
	}
	else
	{
	    if (strcmp("none", job_listing_entry))
	    {
		globus_libc_printf("%s\n",
				   job_listing_entry);
	    }
	    globus_libc_free(job_listing_entry);
	}
    }
} /* get_and_print_job_list() */


int main(int argc, char **argv)
{
    globus_rsl_t *		parsed_rsl;
    globus_rsl_t *		new_parsed_rsl;
    char *			new_rsl;
    int 			rc=GLOBUS_SUCCESS;

    globus_module_activate(GLOBUS_COMMON_MODULE);

    if(argc < 2)
    {
	Usage();
	goto exit;
    }

    if (strcmp(argv[1],"-h")==0)
    {
	Usage();
	goto exit;
    }

    if (strcmp(argv[1],"-list")==0)
    {
	get_and_print_job_list(argv[2]);
	goto exit;
    }
    
    /* parse the RSL string into a globus_rsl_t data structure */
    parsed_rsl = globus_rsl_parse(argv[1]);

    if (parsed_rsl == GLOBUS_NULL)
    {
	globus_libc_printf("RSL invalid.\n");
	rc = -1;
	goto exit;	
    }
    /* display the internal representation of the RSL */
    if(parsed_rsl)
    {
       globus_libc_printf("RSL parse tree:\n");

       globus_rsl_print_recursive(parsed_rsl);
    }
    
  exit:
    globus_module_deactivate(GLOBUS_COMMON_MODULE);
    return rc;
}




