/*
 * globus_rsl_assist.h
 *
 * Description:
 *
 *   This header contains the interface prototypes for the rsl_assist library.
 *   
 * CVS Information:
 *
 * $Source: /home/globdev/CVS/globus-current/Globus/ResourceManagement/rsl_assist/libraries/globus_rsl_assist.h,v $
 * $Date: 1999/08/26 21:13:21 $
 * $Revision: 1.12 $
 * $Author: smartin $
 */
#ifndef _GLOBUS_RSL_ASSIST_INCLUDE_GLOBUS_RSL_ASSIST_H_
#define _GLOBUS_RSL_ASSIST_INCLUDE_GLOBUS_RSL_ASSIST_H_

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif

#include "globus_common.h"
#include "globus_rsl.h"
#include "lber.h"
#include "ldap.h"


/*
 * Function: globus_rsl_assist_replace_manager_name()
 *
 * Uses the Globus RSL library and the UMich LDAP
 * library to modify an RSL specification, changing instances of
 *
 * resourceManagerName=x
 *
 * with
 *
 * resourceManagerContact=y
 *
 * where y is obtained by querying the MDS ldap server, searching
 * for an object which matches the following filter
 *
 *   (&(objectclass=GlobusResourceManager)(cn=x))
 *
 * and extracting the contact value for that object.
 * 
 * Parameters: 
 *     rsl - Pointer to the RSL structure in which you want to
 *           replace the manager Name by its Contact.
 *
 *     NOTE: The RSL MUST have been created using globus_rsl_parse, because
 *     the rsl might be reallocated by this function !! (required when
 *     the rsl is only a simple relation equal : resourceManagerName=x
 *
 * Returns:
 *     Pointer to the new RSL (Might be equal to the original one) or
 *     GLOBUS_NULL in case of failure
 *     
 */
globus_rsl_t *
globus_rsl_assist_replace_manager_name(globus_rsl_t * rsl);


/*
 * Function: globus_rsl_assist_string_canonicalize()
 *
 * Canonizing a string in this implementation means to remove any
 * underscores and moving all characters to lowercase.
 *
 * For example, the string contents "Max_Time" will be altered to be "maxtime".
 *
 * Returns: void
 */
void
globus_rsl_assist_string_canonicalize(char * ptr);


/*
 * Connect to the ldap server, and search for the contact string
 * associated with the resourceManagerName.
 */
int
globus_i_rsl_assist_get_user_job_list(
    char *           globaluserid,
    globus_list_t ** job_contact_list);

/*
 * Function: globus_rsl_assist_attributes_canonicalize()
 *
 * Given an RSL tree (parsed RSL), walk the tree finding all attributes of
 * RSL relations (i.e. (var=value) pairs) and canonicalize them by calling the
 * ..._string_canonicalize function.
 *
 * Returns:
 *     GLOBUS_SUCCESS or GLOBUS_FAILURE.  If GLOBUS_SUCCESS is returned then
 * any and all attributes contained in the passed in RSL tree will have been
 * canonicalized.
 */
int
globus_rsl_assist_attributes_canonicalize(globus_rsl_t * rsl);


#endif


