#include <stdio.h>
#include "globus_common.h"
#include "globus_rsl.h"

typedef struct
{
    char * pgm;
    char ** dir;
} globus_param_t;

int
main(int argc, char ** argv)
{
    globus_rsl_t * new_tree;
    globus_rsl_t * tree;
    char * unparse_spec;
    FILE *input;
    char buff[10000];
    int c;
    int i;

    input = fopen (argv[1], "r");

    if (input == NULL)
    {
        printf("cannot open specified file - %s!!\n", argv[1]);
    }
    else
    {
       i = 0;
       while ((c = fgetc(input)) != EOF)
	 buff[i++] = c;
	 buff[i] = '\0';
	 tree = globus_rsl_parse(buff);
	 if (tree == NULL)
	 {
             printf("====== Invalid User Spec\n");
             return(1);
	 }
	 else
	 {
             printf("====== Start User Spec\n");
             globus_rsl_print_recursive(tree);
             printf("====== End User Spec\n\n");
	 }
       fclose(input);
    }

    printf("====== unparse of tree ==================\n\n");

    unparse_spec = globus_rsl_unparse(tree);

    printf(">>>>>%s<<<<<\n", globus_rsl_unparse(tree));

    printf("====== reparse of tree ==================\n\n");
    new_tree = globus_rsl_parse(unparse_spec);
    if (new_tree == NULL)
    {
         printf("====== Invalid User Spec\n");
         return(1);
    }
    else
    {
         printf("====== Start User Spec\n");
         globus_rsl_print_recursive(new_tree);
         printf("====== End User Spec\n\n");
    }

    printf("\n====== DONE ==================\n\n");
    return 0;
} /* end main() */
