#include "globus_common.h"
#include <stdio.h>
#include "globus_rsl.h"


int
main(int argc, char **argv)
{
    globus_symboltable_t * symbol_table;
    globus_rsl_t * new_root;
    globus_rsl_t * root;
    char ** values;
    FILE *input;
    char buff[1000];
    int c;
    int i;

    input = fopen (argv[1], "r");

    if (input == NULL)
    {
        printf("cannot open specified file - %s!!\n", argv[1]);

	return 1;
    }
    else
    {
       i = 0;
       while ((c = fgetc(input)) != EOF)
	 buff[i++] = c;
	 buff[i] = '\0';
	 root = globus_rsl_parse(buff);
	 if (root == NULL)
	 {
             printf("====== Invalid User Spec\n");
	 }
	 else
	 {
             printf("====== Start User Spec\n");
             globus_rsl_print_recursive(root);
             printf("====== End User Spec\n\n");
	 }
       fclose(input);
    }

    symbol_table = (globus_symboltable_t *) globus_malloc (sizeof(globus_symboltable_t));

    globus_symboltable_init(symbol_table,
                          globus_hashtable_string_hash,
                          globus_hashtable_string_keyeq);

    globus_symboltable_create_scope(symbol_table);

    globus_symboltable_insert(symbol_table,
                            (void *) "aaa",
                            (void *) "aaaVALUE");
    globus_symboltable_insert(symbol_table,
                            (void *) "bbb",
                            (void *) "bbbVALUE");
    globus_symboltable_insert(symbol_table,
                            (void *) "ccc",
                            (void *) "cccVALUE");
    globus_symboltable_insert(symbol_table,
                            (void *) "ddd",
                            (void *) "dddVALUE");
    globus_symboltable_insert(symbol_table,
                            (void *) "variable_concat_right",
                            (void *) "dummyVALUE");
    globus_symboltable_insert(symbol_table,
                            (void *) "variable1",
                            (void *) "anotherdummyVALUE");
    globus_symboltable_insert(symbol_table,
                            (void *) "last",
                            (void *) "lastVALUE");
    printf("lookup of aaa = %s\n", (char *)
	globus_symboltable_lookup(symbol_table, (void *) "aaa"));

    new_root = globus_rsl_copy_recursive(root);
    printf("====== After copy of tree ==================\n\n");

    if (new_root == NULL)
    {
        printf("====== Invalid User Spec\n");
    }
    else
    {
         printf("====== Start User Spec\n");
         globus_rsl_print_recursive(new_root);
         printf("====== End User Spec\n");
         globus_rsl_free_recursive(root);
    }


    if (globus_rsl_eval(new_root, symbol_table) != 0)
    {
        printf("====== ERROR: Unable to eval RSL spec!!\n");
        return 1;
    }

    printf("====== After eval of tree ==================\n\n");

    if (new_root == NULL)
    {
        printf("====== Invalid User Spec\n");
    }
    else
    {
         printf("====== Start User Spec\n");
         globus_rsl_print_recursive(new_root);
         printf("====== End User Spec\n");
/*
         globus_rsl_free_recursive(new_root);
*/
    }

    if (argc > 3)
    {
        printf("====== Testing Parameter get ==================\n\n");
        printf("getting parameter %s\n", argv[2]);

        if (globus_rsl_param_get(new_root,
                                 atoi(argv[3]),
                                 argv[2],
                                 &values)
            != 0 )
        {
            printf("failed getting value %s\n", argv[2]);

	    return 1;
        }

        for (i=0; (values)[i]; i++)
            printf("value[%d] is >%s<\n", i, (values)[i]);

	globus_free(values);
    }
    if (argc > 5)
    {
        printf("getting parameter %s\n", argv[4]);

        if (globus_rsl_param_get(new_root,
                                 atoi(argv[5]),
                                 argv[4],
                                 &(values))
            != 0 )
        {
            printf("failed getting value %s\n", argv[4]);

	    return 1;
        }

        for (i=0; (values)[i]; i++)
            printf("value[%d] is >%s<\n", i, (values)[i]);

	globus_free(values);
    }

    printf("\n====== DONE ==================\n\n");

    globus_symboltable_remove_scope(symbol_table);
    globus_symboltable_destroy(symbol_table);

    return 0;
} /* end main() */
