#include <stdio.h>
#include "globus_common.h"
#include "globus_rsl.h"

int
main(int argc, char ** argv)
{
    globus_rsl_t * new_tree;
    globus_rsl_t * tree;
    char ** values;
    FILE *input;
    char buff[1000];
    int c;
    int i;

    input = fopen (argv[1], "r");

    if (input == NULL)
    {
        printf("cannot open specified file - %s!!\n", argv[1]);
    }
    else
    {
       i = 0;
       while ((c = fgetc(input)) != EOF)
	 buff[i++] = c;
	 buff[i] = '\0';
	 tree = globus_rsl_parse(buff);
	 if (tree == NULL)
	 {
             printf("====== Invalid User Spec\n");
             return(1);
	 }
	 else
	 {
             printf("====== Start User Spec\n");
             globus_rsl_print_recursive(tree);
             printf("====== End User Spec\n\n");
	 }
       fclose(input);
    }

    new_tree = globus_rsl_copy_recursive(tree);

    printf("====== After copy of tree ==================\n\n");

    if (new_tree == NULL)
    {
        printf("====== Invalid User Spec\n");
    }
    else
    {
         printf("====== Start User Spec\n");
         globus_rsl_print_recursive(new_tree);
         printf("====== End User Spec\n");
    }

    if (argc > 3)
    {
        printf("====== Testing Parameter get from new tree ==================\n\n");
        printf("getting parameter %s\n", argv[2]);

        if (globus_rsl_param_get(new_tree,
				 atoi(argv[3]),
				 argv[2],
				 &values) != 0)
	{
	    printf("failed getting value %s\n", argv[2]);
	}

	
        for (i=0; (values)[i]; i++)
            printf("value[%d] is >%s<\n", i, (values)[i]);

	globus_free(values);
    }
    
    if (argc > 5)
    {
        printf("getting parameter %s\n", argv[4]);

        if (globus_rsl_param_get(new_tree,
                                 atoi(argv[5]),
                                 argv[4],
                                 &values) != 0 )
        {
            printf("failed getting value %s\n", argv[4]);
        }

        for (i=0; (values)[i]; i++)
            printf("value[%d] is >%s<\n", i, (values)[i]);

	globus_free(values);
    }


    if(new_tree)
    {
	printf("Freeing copy of tree\n");
	
	globus_rsl_free_recursive(new_tree);

	printf("Copy of tree freed\n");
    }

    if(tree)
    {
	printf("Freeing tree\n");

	globus_rsl_free_recursive(tree);

	printf("Copy of tree freed\n");
    }
    printf("\n====== DONE ==================\n\n");
    return 0;
} /* end main() */
