#include <stdio.h>
#include "globus_common.h"
#include "globus_rsl.h"

static char * my_globus_prefix;

static char * graml_job_contact;
static char * graml_my_globusid;
static char * graml_job_status;

globus_rsl_t * graml_rsl_tree;

static void
graml_add_job_to_rsl()
{

   globus_list_t * new_list;
   char * tmp_var;

   if (globus_rsl_is_boolean(graml_rsl_tree))
   {

       /*
        * create the RSL relation for the job contact
        */
       new_list = NULL;

       globus_list_insert(&new_list, (void *)
           globus_rsl_value_make_literal(graml_job_contact));

       tmp_var = (char *) globus_malloc (12);
       strcpy(tmp_var, "job_contact");

       globus_list_insert(
           globus_rsl_boolean_get_operand_list_ref(graml_rsl_tree),
           (void *) globus_rsl_make_relation(
                         GLOBUS_RSL_EQ,
                         tmp_var,
                         globus_rsl_value_make_sequence(new_list)));


       /*
        * create the RSL relation for the globus id
        */
       new_list = NULL;

       globus_list_insert(&new_list, (void *)
           globus_rsl_value_make_literal(graml_my_globusid));

       tmp_var = (char *) globus_malloc (10);
       strcpy(tmp_var, "globus_id");

       globus_list_insert(
           globus_rsl_boolean_get_operand_list_ref(graml_rsl_tree),
           (void *) globus_rsl_make_relation(
                         GLOBUS_RSL_EQ,
                         tmp_var,
                         globus_rsl_value_make_sequence(new_list)));

       /*
        * create the RSL relation for the job status
        */
       new_list = NULL;

       globus_list_insert(&new_list, (void *)
           globus_rsl_value_make_literal(graml_job_status));

       tmp_var = (char *) globus_malloc (11);
       strcpy(tmp_var, "job_status");

       globus_list_insert(
           globus_rsl_boolean_get_operand_list_ref(graml_rsl_tree),
           (void *) globus_rsl_make_relation(
                         GLOBUS_RSL_EQ,
                         tmp_var,
                         globus_rsl_value_make_sequence(new_list)));
   }

}


int
main(int argc, char **argv)
{
    globus_rsl_t * root;
    FILE *input;
    char buff[1000];
    int c;
    int i;
    globus_symboltable_t * symbol_table;

    input = fopen (argv[1], "r");

    if (input != NULL)
    {
       i = 0;
       while ((c = fgetc(input)) != EOF)
	 buff[i++] = c;

       fclose(input);
       buff[i] = '\0';
       root = globus_rsl_parse(buff);
       if (root == NULL)
       {
           printf("====== Invalid User Spec\n");
	   return 1;
       }
       else
       {
           printf("====== Start User Spec\n");
           globus_rsl_print_recursive(root);
           printf("====== End User Spec\n\n");
       }

       symbol_table = (globus_symboltable_t *) globus_malloc
                            (sizeof(globus_symboltable_t));

       globus_symboltable_init(symbol_table,
                          globus_hashtable_string_hash,
                          globus_hashtable_string_keyeq);

       globus_symboltable_create_scope(symbol_table);

 
       graml_job_contact = (char *) globus_malloc (10);
       graml_my_globusid = (char *) globus_malloc (10);
       graml_job_status = (char *) globus_malloc (10);
       strcpy(graml_job_contact, "cont 123");
       strcpy(graml_my_globusid, "g_id 777");

       my_globus_prefix = (char *) globus_malloc (10);
       strcpy(my_globus_prefix, "xxx");
       globus_symboltable_insert(symbol_table,
                            (void *) "GLOBUS_PREFIX",
                            (void *) my_globus_prefix);

       globus_rsl_eval(root, symbol_table);

       graml_rsl_tree = root;

       graml_add_job_to_rsl();

       strcpy(graml_job_status, "ACTIVE");

       printf("====== Start User Spec\n");
       globus_rsl_print_recursive(graml_rsl_tree);
       printf("====== End User Spec\n\n");

    }

   globus_rsl_free_recursive(graml_rsl_tree);
   return 0;
} /* end main() */
