#include <stdio.h>
#include <malloc.h>

int main(int argc, char **argv)
{
    char            logfile[1024];
    FILE *          logfile_fp;
    int             x;
    extern char **  environ;
    int             environ_count;
    int             i;
    char **         env;
    int             n_env;
    int             n;
    char            msg[1024];

    sprintf(logfile, "grami_test_app_%lu.log",
            (unsigned long) getpid());

    if ((logfile_fp = fopen(logfile, "a")) == NULL)
    {
        printf("Cannot open logfile, disabling logging\n");
        logfile_fp = fopen("/dev/null", "w");
    }
    else
        printf("Logging to %s\n", logfile);

    setbuf(logfile_fp, NULL);

    fprintf(logfile_fp,"----------------------------------------\n");
    fprintf(logfile_fp,"num args %d\n", argc);
    for(x=0;x<argc;x++)
    {
        fprintf(logfile_fp,"arg %d = %s\n", x, argv[x]);
    }

    fprintf(logfile_fp,"----------------------------------------\n");
    fprintf(logfile_fp, "hello world. pid = %lu    time = %lu\n",
            (unsigned long) getpid(), (unsigned long) time(0));

	fprintf(logfile_fp," uid = %lu\n", (unsigned long) getuid());
	fprintf(logfile_fp," gid = %lu\n", (unsigned long) getgid());
	fprintf(logfile_fp," sid = %lu\n", (unsigned long) getsid());
   {
    int i,j;
    int gidsetlen = 50;
    int gidset[50];

    j = getgroups(gidsetlen,gidset);
    fprintf(logfile_fp,"Groups(%d):",j);
    for (i = 0; i<j; i++) {
       fprintf(logfile_fp,"%#06x",gidset[i]);
       if((i+1)<j) fprintf(logfile_fp,",");
    }
    fprintf(logfile_fp,"\n");
   }


    fprintf(logfile_fp,"----------------------------------------\n");
    for (environ_count = 0; environ[environ_count] != NULL; environ_count++)
        ;

    n_env = environ_count;
    fprintf(logfile_fp,"Got %d environment variables\n", environ_count);
    env = (char **)malloc(sizeof(char *) * (n_env + 1));

    for (i = 0; i < environ_count; i++)
    {
        env[i] = environ[i];
    }
    env[n_env] = NULL;

    if (n_env > 0)
    {
        for (i = 0; i < n_env; i++)
        {
            fprintf(logfile_fp,"env[%d] is \"%s\"\n", i, env[i]);
        }
    }

    fprintf(logfile_fp, "stdin fd  = %d\n", stdin);
    fprintf(logfile_fp, "stdout fd = %d\n", stdout);
    fprintf(logfile_fp, "stderr fd = %d\n", stderr);

    memset(msg, sizeof(msg), '\0');
    /*
     * Read data from stdin
     */
    if (fread(msg, 1, sizeof(msg) - 1, stdin) == 0)
    {
        fprintf(stderr, "error reading stdin\n");
        fprintf(logfile_fp, "error reading stdin\n");
    }
    else
    {
        if (msg[strlen(msg)-1] == '\n')
        {
            msg[strlen(msg) - 1] = '\0';
        }

        fprintf(stdout, "read from stdin = %s\n", msg);
    }

    fprintf(stdout, "testing stdout\n");
    fprintf(stderr, "testing stderr\n");

#ifdef SLEEP 
    sleep(10); 
#endif

#ifdef LOOP 
    while(1); 
#else
    fprintf(logfile_fp,"----------------------------------------\n");
    fprintf(logfile_fp,"grami test app completed.\n");
    return(0);
#endif
}
