#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include "globus_gram_myjob.h"
#include "globus_gass_file.h"
#include "globus_common.h"

int
main(
    int					argc,
    char *				argv[])
{
    int					size;
    int					rank;
    int					rc;
    char * my_gass_url;
    char new_url[1024];
    FILE * fout, * ferr;
    int stdout_fd, stderr_fd;
    char local_host[256];


    if ( gethostname(local_host, 256) != 0 )
        strcpy(local_host, "UNKNOWN");

    if ((rc = globus_module_activate(GLOBUS_GRAM_MYJOB_MODULE))
	!= GLOBUS_SUCCESS)
    {
	printf("globus_module_activate() failed, rc=0x%08x.\n", rc);
	globus_gram_myjob_kill();
    }

    if ((rc = globus_module_activate(GLOBUS_GASS_FILE_MODULE))
	!= GLOBUS_SUCCESS)
    {
	printf("globus_module_activate() failed, rc=0x%08x.\n", rc);
	globus_gram_myjob_kill();
        return(1);
    }

    my_gass_url = (char *) getenv("GLOBUSRUN_GASS_URL");

    if (my_gass_url)
    {
        sprintf(new_url, "%s/dev/stdout", my_gass_url);
        stdout_fd=globus_gass_open(new_url, O_WRONLY|O_APPEND );
        fout=fdopen(stdout_fd, "a" );

        sprintf(new_url, "%s/dev/stderr", my_gass_url);
        stderr_fd=globus_gass_open(new_url,  O_WRONLY|O_APPEND );
        ferr=fdopen(stderr_fd, "a");
    }
    else
    {
        ferr = stderr;
        fout = stdout;
    }

    if ((rc = globus_gram_myjob_size(&size)) != GLOBUS_GRAM_MYJOB_SUCCESS)
    {
	fprintf(ferr, "globus_gram_myjob_size() failed, rc=0x%08x.\n", rc);
	globus_gram_myjob_kill();
    }

    if ((rc = globus_gram_myjob_rank(&rank)) != GLOBUS_GRAM_MYJOB_SUCCESS)
    {
	fprintf(ferr, "globus_gram_myjob_rank() failed, rc=0x%08x.\n", rc);
	globus_gram_myjob_kill();
    }

    fprintf(fout, "%d: local host %s: size=%d\n",
         rank,
         local_host,
         size);

    if (size > 1)
    {
	if (rank == 0)
	{
	    globus_byte_t *			msg_buf;
	    int					msg_sz;
	    int					p;

	    msg_buf = malloc(GLOBUS_GRAM_MYJOB_MAX_BUFFER_LENGTH);
	    if (msg_buf == NULL)
	    {
		fprintf(ferr, "%d: malloc() failed.\n", rank);
		globus_gram_myjob_kill();
	    }

	    for (p = 0; p < size - 1; p++)
	    {
		if ((rc = globus_gram_myjob_receive(msg_buf, &msg_sz))
		    != GLOBUS_GRAM_MYJOB_SUCCESS)
		{
		    fprintf(ferr, "%d: globus_gram_myjob_receive() failed, "
			   "rc=0x%08x.\n",
			   rank, rc);
		    globus_gram_myjob_kill();
		}

		if (msg_sz != sizeof(int))
		{
		    fprintf(fout, "%d: globus_gram_myjob_receive(), size=%d.\n",
			   rank, msg_sz);
		    globus_gram_myjob_kill();
		}

		fprintf(fout, "%d: received from %d\n",
                    rank,
                    * (int *) msg_buf);
	    }
	}
	else
	{
            fprintf(fout, "%d: local host %s: sending\n",
                rank,
                local_host);
	    if ((rc = globus_gram_myjob_send(0,
					     (globus_byte_t *) &rank,
					     sizeof(int)))
		!= GLOBUS_GRAM_MYJOB_SUCCESS)
	    {
		fprintf(ferr, "globus_gram_myjob_send() failed, rc=0x%08x.\n",
                     rc);
		globus_gram_myjob_kill();
	    }
	}
    }

    if (my_gass_url)
    {
        globus_gass_fclose(fout);
        globus_gass_fclose(ferr);
    }

    if ((rc = globus_module_deactivate(GLOBUS_GRAM_MYJOB_MODULE))
	 != GLOBUS_SUCCESS)
    {
	fprintf(ferr, "globus_module_deactivate() failed, rc=0x%08x.\n", rc);
	globus_gram_myjob_kill();
    }

    if ((rc = globus_module_deactivate(GLOBUS_GASS_FILE_MODULE))
	 != GLOBUS_SUCCESS)
    {
	fprintf(ferr, "globus_module_deactivate() failed, rc=0x%08x.\n", rc);
    }

    fprintf(fout, "%d: test complete.\n", rank);

    return(0);
}
