
#include "globus_i_gram_http.h"
#include "globus_i_gram_version.h"
#include "globus_gram_client.h"
#include <globus_io.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#define my_malloc(type) (type *) globus_libc_malloc(sizeof(type))

static void notice(char * format, ...)
{
    va_list ap;
    int rc;
    int save_errno;

    globus_libc_lock();

#ifdef HAVE_STDARG_H
    va_start(ap, format);
#else
    va_start(ap);
#endif
    
    rc = vfprintf(stderr, format, ap);
    save_errno=errno;

    globus_libc_unlock();

    errno=save_errno;
}

#if 1
#define verbose(q) q
#else
#define verbose(q) { }
#endif


static globus_mutex_t mutex;
static globus_cond_t cond;
static int thread_count;

void
my_http_query_callback( void * arg,
			globus_io_handle_t * handle,
			globus_byte_t * buf,
			globus_size_t   nbytes,
			int             errorcode)
{
    int             rc;
    int             failure;
    int             status;
    int             mask;
    int *           tstatus = GLOBUS_NULL;
    char *          query;
    char *          rest;
    char            url[1000];
    globus_byte_t * reply;
    globus_size_t   replysize;
    globus_byte_t * newbuf;
    globus_size_t   newsize;
    globus_result_t result;
    globus_size_t   i;


    verbose(notice("jm_read_callback : got message, handle=%d res=%d\n",
		   handle->fd, errorcode ));

    if (errorcode != GLOBUS_SUCCESS)
    {
	verbose(notice("jm_read_callback : error, closing %d\n",
		       handle->fd));
	globus_io_register_close( handle,
				  globus_gram_http_close_callback,
				  GLOBUS_NULL );
    }
    else
    {
	rc = globus_gram_http_unpack_status_request(
	    buf,
	    nbytes,
	    &query );

	globus_libc_free(buf);

	verbose(notice("jm_read_callback : rc=%d message =\n%s----\n",
		       rc, query));

	if (rc != GLOBUS_SUCCESS)
	{
	    verbose(notice("jm_read_callback : msg error\n"));
	}
	else
	{
	    globus_io_handle_get_user_pointer( handle,
					       (void **) &tstatus );

	    rest = strchr(query,' ');
	    if (rest)
		*rest++ = '\0';

	    failure = GLOBUS_SUCCESS;

	    if (strcmp(query,"cancel")==0)
	    {
		verbose(notice("jm_read_callback : cancel\n"));
		*tstatus = GLOBUS_GRAM_CLIENT_JOB_STATE_DONE;
		status = *tstatus;
	    }
	    else if (strcmp(query,"status")==0)
	    {
		verbose(notice("jm_read_callback : status\n"));
		status = *tstatus;
	    }
	    else if (strcmp(query,"register")==0)
	    {
		if (sscanf(rest,"%d %s", &mask, url) != 2)
		    failure = GLOBUS_GRAM_CLIENT_ERROR_PROTOCOL_FAILED;
		
		verbose(notice("jm_read_callback : register %s , mask %d\n",
			       url, mask));
		status = *tstatus;
	    }
	    else if (strcmp(query,"unregister")==0)
	    {
		if (sscanf(rest,"%s", url) != 2)
		    failure = GLOBUS_GRAM_CLIENT_ERROR_PROTOCOL_FAILED;
		
		verbose(notice("jm_read_callback : unregister %s\n",url));
		status = *tstatus;		
	    }
	    else
	    {
		status = GLOBUS_GRAM_CLIENT_JOB_STATE_FAILED;
		failure = GLOBUS_GRAM_CLIENT_ERROR_INVALID_JOB_QUERY;
	    }
	    
	    rc = globus_gram_http_pack_status_reply(
		status,
		failure,
		&reply,
		&replysize );
	}

	if (rc == GLOBUS_SUCCESS)
	    rc = globus_gram_http_frame_reply(
		200,
		reply,
		replysize,
		&newbuf,
		&newsize);
	
	if (rc != GLOBUS_SUCCESS)
	    globus_gram_http_frame_reply(
		500,
		GLOBUS_NULL,
		0,
		&newbuf,
		&newsize );
	
	globus_libc_free(reply);
	globus_libc_free(query);
    }
    verbose(notice("jm_read_callback : write on %d, size %d\n",
		   handle->fd, newsize));
    for(i = 0; i < newsize; i++)
    {
	verbose(notice("%c", newbuf[i]));
    }
    
    result = globus_io_register_write(
	handle,
	newbuf,
	newsize,
	globus_gram_http_close_after_write,
	GLOBUS_NULL );
}


typedef struct
{
    globus_mutex_t  mutex;
    globus_cond_t   cond;
    globus_bool_t   done;
    int             state;
    int             errcode;
} my_monitor_t;


void 
gram_callback_func(void * user_callback_arg, 
		   char * job_contact, 
		   int    state,
		   int    errorcode)
{
    my_monitor_t *  monitor = (my_monitor_t *) user_callback_arg;
    
    globus_mutex_lock(&monitor->mutex);
    
    verbose(printf("got state %d error %d from %s\n", state, errorcode, job_contact));

    monitor->state = state;

    if (errorcode != GLOBUS_SUCCESS)
    {
	monitor->done = GLOBUS_TRUE;
	monitor->errcode = errorcode;
    }
    if (state == GLOBUS_GRAM_CLIENT_JOB_STATE_DONE)
	monitor->done = GLOBUS_TRUE;

    globus_cond_signal(&monitor->cond);
    globus_mutex_unlock(&monitor->mutex);
}


static int jm_status = GLOBUS_GRAM_CLIENT_JOB_STATE_PENDING;


void
gatekeeper_callback( void * arg,
		     globus_io_handle_t * handle,
		     globus_byte_t * buf,
		     globus_size_t   nbytes,
		     int             errorcode)
{
    int             rc;
    int             status;
    int             mask;
    char *          callback;
    char *          rsl;
    char *          contact;
    char            url[1000];
    globus_byte_t * reply;
    globus_size_t   replysize;
    globus_byte_t * sendbuf;
    globus_size_t   sendsize;
    globus_result_t result;
    int             i;
    unsigned short  port;
    char *          host;


    verbose(printf("in the GK/JM\n"));

    rc = globus_gram_http_unpack_job_request(
	buf,
	nbytes,
	&mask,
	&callback,
	&rsl );

    verbose(printf("GK/JM: parse, rc = %d\n", rc));

    i = *(int *)arg;
    if (i==0)
    {
	status = globus_gram_http_allow_attach( &port,
						&host,
						(void *) &jm_status,
						my_http_query_callback,
						GLOBUS_NULL);

	globus_libc_sprintf(url,
			    "https://%s:%hu/",
			    host,
			    port);

	contact = url;
    }
    else
    {
	status = GLOBUS_GRAM_CLIENT_ERROR_BAD_RSL;
	contact = GLOBUS_NULL;
    }

    rc = globus_gram_http_pack_job_request_reply(
	status,
	contact,
	&reply,
	&replysize );


    rc = globus_gram_http_frame_reply(
	200,
	reply,
	replysize,
	&sendbuf,
	&sendsize );

    verbose(printf("GK/JM : reply:\n"));
    for (i=0; i<sendsize; i++)
	printf("%c", sendbuf[i]);

    result = globus_io_register_write(
	handle,
	sendbuf,
	sendsize,
	globus_gram_http_close_after_write,
	GLOBUS_NULL );
}
char * name = NULL;

void *
test(void * arg)
{
    char * rslstr = "&(executable = /bin/sleep)(arguments=60)";
    unsigned short              port;
    char *                      host;
    int                         rc;
    char                        url[1000];
    int                         jm_mode;
    int                         status = -1;
    int                         failure_code = -1;
    my_monitor_t                monitor;
    char *                      callback = GLOBUS_NULL;
    char *                      contact = GLOBUS_NULL;

    globus_module_activate(GLOBUS_GRAM_CLIENT_MODULE);

    rc = globus_gram_client_job_request(
	arg,
	rslstr,
	GLOBUS_GRAM_CLIENT_JOB_STATE_ALL,
	GLOBUS_NULL,
	&contact);

    verbose(printf("rc = %d (%s), contact = %s\n",
		   rc,
		   globus_gram_client_error_string(rc),
		   (contact) ? contact : "NULL"));

    verbose(printf("\nCalling globus_gram_client_job_status()\n"));
    rc = globus_gram_client_job_status(contact,
				       &status,
				       &failure_code);
    verbose(printf("rc = %d (%s), status = %d, failure_code = %d\n",
		   rc, globus_gram_client_error_string(rc), status, failure_code));


    verbose(printf("\nCalling globus_gram_client_job_status()\n"));
    rc = globus_gram_client_job_status(contact,
				       &status,
				       &failure_code);
    verbose(printf("rc = %d (%s), status = %d, failure_code = %d\n",
		   rc, globus_gram_client_error_string(rc), status, failure_code));


    verbose(printf("\nCalling globus_gram_client_job_status() again\n"));
    rc = globus_gram_client_job_status(contact,
				       &status,
				       &failure_code);
    verbose(printf("rc = %d (%s), status = %d, failure_code = %d\n",
		   rc, globus_gram_client_error_string(rc), status, failure_code));

    verbose(printf("\nCalling globus_gram_client_callback_allow()\n"));
    rc = globus_gram_client_callback_allow( gram_callback_func,
					    (void *) &monitor,
					    &callback );
    verbose(printf("rc = %d (%s), callback = %s\n",
		   rc, globus_gram_client_error_string(rc),
		   (callback) ? callback : "NULL"));

    verbose(printf("\nCalling globus_gram_client_job_callback_register()\n"));
    rc = globus_gram_client_job_callback_register(
	     contact,
	     GLOBUS_GRAM_CLIENT_JOB_STATE_ALL,
	     callback,
	     &status,
	     &failure_code );
    verbose(printf("rc =  %d (%s) , status = %d  failure = %d\n",
		   rc, globus_gram_client_error_string(rc), status, failure_code));

#if 0

    printf("\nWaiting for job completion...\n");
    globus_mutex_lock(&monitor.mutex);
    {
	while (!monitor.done)
	    globus_cond_wait(&monitor.cond, &monitor.mutex);
    }
    globus_mutex_unlock(&monitor.mutex);

    printf("errcode = %d (%s) , status = %d\n",
	   monitor.errcode, globus_gram_client_error_string(monitor.errcode),
	   monitor.state );

#else
    verbose(printf("\nCalling globus_gram_client_job_callback_unregister()\n"));
    rc = globus_gram_client_job_callback_unregister(
	     contact,
	     callback,
	     &status,
	     &failure_code );
    verbose(printf("rc =  %d (%s) , status = %d  failure = %d\n",
	   rc, globus_gram_client_error_string(rc), status, failure_code));

    verbose(printf("\nCalling globus_gram_client_job_cancel()\n"));
    rc = globus_gram_client_job_cancel(contact);
    verbose(printf("cancel : rc =  %d (%s)\n",
	   rc, globus_gram_client_error_string(rc)));

    verbose(printf("\nCalling globus_gram_client_job_cancel() AGAIN...\n"));
    rc = globus_gram_client_job_cancel(contact);
    verbose(printf("cancel : rc =  %d (%s)\n",
	   rc, globus_gram_client_error_string(rc)));

    verbose(printf("\nCalling gram_client_job_callback_register() AFTER cancel\n"));
    rc = globus_gram_client_job_callback_register(
	     contact,
	     GLOBUS_GRAM_CLIENT_JOB_STATE_ALL,
	     callback,
	     &status,
	     &failure_code );
    verbose(printf("rc =  %d (%s) , status = %d  failure = %d\n",
	   rc, globus_gram_client_error_string(rc), status, failure_code));

#endif

    verbose(printf("\nCalling globus_http_callback_disallow()\n"));
    rc = globus_gram_http_callback_disallow( callback );
    verbose(printf("callback_disallow returned rc =  %d (%s)\n",
	   rc, globus_gram_client_error_string(rc)));
    globus_libc_free(callback);
    globus_libc_free(contact);

    globus_mutex_lock(&mutex);
    thread_count--;
    globus_cond_signal(&cond);
    globus_mutex_unlock(&mutex);

    globus_module_deactivate(GLOBUS_GRAM_CLIENT_MODULE);
    return 0;
}

int main(int argc, char * argv[])
{
    int				i;

    globus_module_activate(GLOBUS_COMMON_MODULE);

    if(argc < 2)
    {
	globus_libc_printf("Usage: %s gatekeeper-contact\n", argv[0]);
	globus_module_deactivate(GLOBUS_COMMON_MODULE);

	exit(1);
    }


#if 0
    {
	gss_cred_id_t		cred;
	OM_uint32		maj_stat;
	OM_uint32		min_stat;
	gss_name_t		my_name = GSS_C_NO_NAME;
	gss_buffer_desc		tmp_buffer_desc = GSS_C_EMPTY_BUFFER;
	gss_buffer_t		tmp_buffer = &tmp_buffer_desc;
	int                     jm_mode;
	char *                  callback = GLOBUS_NULL;
	char *                  contact = GLOBUS_NULL;
	char *                  rslstr;
	unsigned short          port;
	char *                  host;
	int                     rc;
	char                    url[1000];
	int                     status = -1;
	int                     failure_code = -1;
	my_monitor_t            monitor;

	jm_mode = 1;
	
	maj_stat = globus_gss_assist_acquire_cred(&min_stat,
						  GSS_C_BOTH,
						  &cred);
	if(gss_inquire_cred(&min_stat,
			    cred,
			    &my_name,			
			    NULL,
			    NULL,
			    NULL) == GSS_S_COMPLETE)
	{
	    if(gss_display_name(&min_stat,
				my_name,
				tmp_buffer,
				NULL) == GSS_S_COMPLETE)
	    {
		name = globus_libc_malloc(tmp_buffer->length + 1);
		memcpy(name, tmp_buffer->value, tmp_buffer->length);
		name[tmp_buffer->length] = '\0';
		
		gss_release_buffer(&min_stat, tmp_buffer);
	    }
	    gss_release_name(&min_stat, &my_name);
	}
	
	gss_release_cred(&min_stat,
			 &cred);
	

	/* start a "JM"
	 *
	 * *NOTE*
	 * Currently, this does *NOT* work. The job request expects that the
	 * connection is done with delegation enabled; all other job manager
	 * messages bypass the delegation message (ie. the messages
	 * are just ssl-encoded packets).
	 */
	rc = globus_gram_http_allow_attach( &port,
					    &host,
					    GLOBUS_NULL,
					    gatekeeper_callback,
					    (void *) &jm_mode );
	
	globus_libc_sprintf(url,
			    "https://%s:%hu/jobmanager:%s",
			    host,
			    port,
			    name);
	
	verbose(printf("\nCalling globus_gram_client_job_request()\n"));
	rc = globus_gram_client_job_request(
	    url,
	    rslstr,
	    GLOBUS_GRAM_CLIENT_JOB_STATE_ALL,
	    GLOBUS_NULL,
	    &contact);
    }
#endif

    globus_mutex_init(&mutex, GLOBUS_NULL);
    globus_cond_init(&cond, GLOBUS_NULL);
    thread_count = 0;

    globus_mutex_lock(&mutex);
    for(i = 0; i < 10; i++)
    {
	globus_thread_t thread;
	int rc;

	thread_count++;
	rc = globus_thread_create(&thread,
				  NULL,
				  test,
				  argv[1]);

	if(rc < 0)
	{
	    thread_count--;
	}
    }

    if(thread_count == 0)
    {
        /* could not make any threads! We're probably not threaded*/
	thread_count++;
	globus_mutex_unlock(&mutex);
	test(argv[1]);
	globus_mutex_lock(&mutex);
    }
    while(thread_count != 0)
    {
	globus_cond_wait(&cond,
			 &mutex);
    }
    globus_mutex_unlock(&mutex);

    globus_module_deactivate(GLOBUS_COMMON_MODULE);

    return 0;
}
