#include "globus_common.h"

#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>

#include "globus_gram_client.h"

globus_mutex_t mutex;
globus_cond_t cond;

#if defined(BUILD_LITE)
#define my_thread_t pid_t
#define my_thread_create(pid, foo, func, arg) {\
    *pid = fork();\
    if(*pid == 0)\
    {\
	func(arg);\
	exit(0);\
    }\
}
#define MY_THREAD_ARG "-fork"
#define MY_THREAD_NAME "process "
#define my_thread_self() globus_libc_getpid()
#define my_wait(cond, mutex)  { wait(NULL); globus_poll(); outstanding--; }
#else
#define my_thread_t globus_thread_t
#define my_thread_create(a,b,c,d) globus_thread_create(a,b,c,d)
#define MY_THREAD_ARG "-threads"
#define MY_THREAD_NAME "thread "
#define my_thread_self() globus_thread_self()
#define my_wait(cond, mutex) { globus_cond_wait(cond, mutex); }
#endif

globus_bool_t all_started=GLOBUS_FALSE;
int outstanding = 0;

void callback_func(void * user_callback_arg,
                          char * job_contact,
                          int state,
                          int errorcode);

typedef struct
{
    globus_mutex_t mutex;
    globus_cond_t cond;
    globus_bool_t done;
    int simple_install_test;
} my_monitor_t;

void *test_child(void *url);

int main(int argc, char **argv)
{
    char url[10000];
    int fd1,fd2;
    int numthreads=1;
    my_thread_t *threads;
    int i;
    int rc;

    globus_module_activate(GLOBUS_COMMON_MODULE);
    
    for(i = 0; i < argc; i++)
    {
	if(strcmp(argv[i], MY_THREAD_ARG) == 0)
	{
	    i+=1;
	    if(i < argc)
	    {
		numthreads=atoi(argv[i]);
	    }
	}
    }

    threads = (my_thread_t *) malloc(numthreads * sizeof(my_thread_t));

    if(numthreads != 1)
    {
	for(i = 0; i < numthreads; i++)
	{
		my_thread_create(&threads[i], NULL, test_child, i);
        	globus_mutex_lock(&mutex);
		outstanding++;
        	globus_mutex_unlock(&mutex);
	}
        globus_mutex_lock(&mutex);
	all_started = GLOBUS_TRUE;
	while(all_started == GLOBUS_FALSE || outstanding != 0)
	{
	    my_wait(&cond, &mutex);
	}
	globus_mutex_unlock(&mutex);
    }
    else
    {
	test_child(url);
    }

    globus_module_deactivate(GLOBUS_COMMON_MODULE);
    return 0;
}

void *
test_child(void *url)
{
    int fd;
    int i;
    FILE *f;
    char hostname[100];
    char buffer[10000];
    int written;
    int rc = 0;

    int callback_fd;
    int job_state_mask;
    char * callback_contact;
    char * job_contact;
/*
    char * rm_contact;
    char * specification;
*/
    char rm_contact[256];
    char specification[256];
    globus_bool_t done;
    globus_gram_client_time_t estimate;
    globus_gram_client_time_t interval_size;
    my_monitor_t Monitor;

    globus_module_activate(GLOBUS_GRAM_CLIENT_MODULE);
    globus_libc_printf("Attempting to submit a gram request\n");

    globus_mutex_init(&Monitor.mutex, (globus_mutexattr_t *) NULL);
    globus_cond_init(&Monitor.cond, (globus_condattr_t *) NULL);

    /* entering the monitor and clearing the flag */
    globus_mutex_lock(&Monitor.mutex);
    Monitor.done = GLOBUS_FALSE;
    globus_mutex_unlock(&Monitor.mutex);

    globus_gram_client_callback_allow(callback_func,
                       (void *) &Monitor,
                       &callback_contact);

    printf("\n\tTEST: submitting to resource manager...\n");


    strcpy(rm_contact, "pitcairn.mcs.anl.gov:32797:/C=US/O=Globus/O=Argonne National Laboratory/OU=MCS/CN=smartin");

    sprintf(specification, "&(executable=/bin/echo)(arguments=%d)"
                           "(stdout=$(HOME)/gram_client_test.%lu.log)",
                           (int) url, (unsigned long) getpid());

    rc = globus_gram_client_job_request(rm_contact,
                         specification,
                         GLOBUS_GRAM_CLIENT_JOB_STATE_ALL,
                         callback_contact,
                         &job_contact);

    if (rc != 0)
    {
        globus_libc_printf("TEST: gram error: %d - %s\n",
                rc,
                globus_gram_client_error_string(rc));
        goto end;
    }

    globus_libc_printf("job submission was successful\n");

    globus_mutex_lock(&Monitor.mutex);
    while (!Monitor.done)
    {
        globus_cond_wait(&Monitor.cond, &Monitor.mutex);
    } /* endwhile */
    globus_mutex_unlock(&Monitor.mutex);

    globus_mutex_destroy(&Monitor.mutex);
    globus_cond_destroy(&Monitor.cond);

    globus_gram_client_job_contact_free(job_contact);

 end:
    globus_mutex_lock(&mutex);
    outstanding--;
    globus_cond_signal(&cond);
    globus_mutex_unlock(&mutex);

    globus_module_deactivate(GLOBUS_GRAM_CLIENT_MODULE);
    return NULL;
}

void callback_func(void * user_callback_arg,
                   char * job_contact,
                   int state,
                   int errorcode)
{

    my_monitor_t * Monitor = (my_monitor_t *) user_callback_arg;

    switch(state)
    {
    case GLOBUS_GRAM_CLIENT_JOB_STATE_PENDING:
        if (!(Monitor->simple_install_test))
            printf("\tTEST: Got GLOBUS_GRAM_CLIENT_JOB_STATE_PENDING"
                   " from job manager\n");
        break;
    case GLOBUS_GRAM_CLIENT_JOB_STATE_ACTIVE:
        if (!(Monitor->simple_install_test))
            printf("\tTEST: Got GLOBUS_GRAM_CLIENT_JOB_STATE_ACTIVE"
                   " from job manager\n");
        break;
    case GLOBUS_GRAM_CLIENT_JOB_STATE_FAILED:
        if (!(Monitor->simple_install_test))
            printf("\tTEST: Got GLOBUS_GRAM_CLIENT_JOB_STATE_FAILED"
                   " from job manager\n");
        globus_mutex_lock(&Monitor->mutex);
        Monitor->done = GLOBUS_TRUE;
        globus_cond_signal(&Monitor->cond);
        globus_mutex_unlock(&Monitor->mutex);
        break;
    case GLOBUS_GRAM_CLIENT_JOB_STATE_DONE:
        if (!(Monitor->simple_install_test))
            printf("\tTEST: Got GLOBUS_GRAM_CLIENT_JOB_STATE_DONE"
                   " from job manager\n");
        globus_mutex_lock(&Monitor->mutex);
        Monitor->done = GLOBUS_TRUE;
        Monitor->simple_install_test = 0;
        globus_cond_signal(&Monitor->cond);
        globus_mutex_unlock(&Monitor->mutex);
        break;
    }
}
