/******************************************************************************
globus_gatekeeper_service_prototype.c
 
Description:
	Prototype version of a service routine which is exec'ed by the 
	gatekeeper. The progam in defined in the gatekeeper's 
	grid-service file. 

	File descripters:
		 0 is the socket connected to the client.
		 1 is the socket connected to the client.
		 2 is the either the gatekeeper's log file, or the socket. 
		   this is set in the grid-service file. 
		 N is an open deleted temp file with the gssapi context 
		   which may be used with the client. 
		   N is defined by the GRID_SECURITY_CONTEXT_FD

	Depending on what the protocol between the cleint and the
	service, the service can restablish the gssapi context so
	as to use the gssapi wrap and unwrap for message protection. 
	
	ENV variables which may be used:


 
CVS Information:
 
	$Source: /home/globdev/CVS/globus-current/Globus/ResourceManagement/gram/tests/globus_gatekeeper_service_prototype.c,v $
	$Date: 1999/05/17 18:02:36 $
	$Revision: 1.2 $
	$Author: dengert $
******************************************************************************/

/******************************************************************************
                             Include header files
******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include "globus_gss_assist.h"
#include <gssapi.h>

/******************************************************************************
                               Type definitions
******************************************************************************/

/******************************************************************************
                          Module specific prototypes
******************************************************************************/

static void
failure(char *s);

/******************************************************************************
                       Define module specific variables
******************************************************************************/

/******************************************************************************
Function: 		failure()      

Description:    
		Produce failure message

Parameters:
Returns:
		Does not return, does an exit

******************************************************************************/
static void
failure(char * s)
{
	fprintf(stderr,"Failure: %s\n", s);
 	exit(1);
}

/******************************************************************************
Function:       
Description:    
Parameters:
Returns:
******************************************************************************/
int 
main(int argc,
	char ** argv)
{

	int					rc;
	int					i;
	int					debug = 0;
	int 				context_option= 0;
	int					wrap_option = 0;
	OM_uint32 			major_status = 0;
	OM_uint32 			minor_status = 0;
	gss_ctx_id_t        context_handle = GSS_C_NO_CONTEXT;
	int                 token_status = 0;
	int					context_fd;
	char *				context_fd_char;
	gss_buffer_desc 	context_token;
	unsigned char		ibuf[4];
	char *				message = "Hello, World";


	/* make sure buffering is handled correctly on the socket */
	
	setbuf(stdout,NULL);

	/* process args */

	for (i = 1; i < argc; i++)
	{
		if (strcmp(argv[i], "-d") == 0)
		{
			debug = 1;
		}
		else if (strcmp(argv[i], "-m") == 0)
		{
			i++;
			message = argv[i];
		}
		else if (strcmp(argv[i], "-c") == 0)
		{
			context_option = 1;
		}
		else if (strcmp(argv[i], "-w") == 0)
		{
			wrap_option = 1;
			context_option = 1;
		}
		else
		{
		/* assume stderr is valid at this point */
			fprintf(stderr, "Unknown argument %s\n", argv[i]);
			fprintf(stderr, "Usage: %s %s\n",
					argv[0], "[-d] [-c] [-w]");
			exit (1);
		}
	}


	/*
	 * Reestablish the gssapi security context, as we want to wrap
	 * messages to the client. 
	 * globus_gss_assist_import_sec_context will find the
	 * open file from the environment, and read in the 
	 * token, and import the security context. 
	 */

	if (debug)
	{
		fprintf(stderr,
			"globus_gatekeeper_service_prototype: starting\n");
		fprintf(stderr,
			"Running as user %d\n",getuid());
	}

	if (context_option)
	{
		
		if (globus_gss_assist_import_sec_context(&minor_status,
				&context_handle,
				&token_status,
				-1,
				stderr) != GSS_S_COMPLETE)
		{
			failure("Context not established");
		}
	}

	
	/* 
	 * We now need to send back a message to the client, saying
	 * the service is ready for comunications.
 	 */

	if (wrap_option) 
	{
		if (globus_gss_assist_wrap_send( &minor_status,
								context_handle,
								message,
								strlen(message)+1,
								&token_status,
								globus_gss_assist_token_send_fd,
								stdout,
								stderr) != GSS_S_COMPLETE)
		{
			failure("wrap failed");
		}
	}
	else
	{
		printf(message);
	}	

	if (debug)
	{
		fprintf(stderr,"Message: %s\n",message);
		fprintf(stderr,
			"globus_gatekeeper_service_prototype complete\n");
	}

	return 0;
}
