#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>
#include <netdb.h>

#include "ggg.h"

/*---------------------------------------------------------*/
int create_socket(unsigned int port)
{
     struct sockaddr_in saddr;
     int s;

     memset(&saddr,0,sizeof(saddr)); /* This corrects a Purify UMR warning. */

     saddr.sin_family = AF_INET;
     saddr.sin_port = htons(port);
     saddr.sin_addr.s_addr = INADDR_ANY;

     if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      perror("creating socket");
      return -1;
     }
     {
     int opt;
     setsockopt (s,SOL_SOCKET,SO_REUSEADDR,(char *)&opt,sizeof(opt));
     }

     if (bind(s, (struct sockaddr *) &saddr, sizeof(saddr)) < 0) {
      perror("binding socket");
      return -1;
     }
     if (listen(s, 5) < 0) {
      perror("listening on socket");
      return -1;
     }
     return s;
} /* create_socket() */

/*---------------------------------------------------------*/

int establish_connection(int my_socket) {
  char this_function[] ="establish_connection";
  int other_socket;
  struct sockaddr_in net_client;
  struct hostent *hostptr;
  int addr_len = sizeof(struct sockaddr);
  int retval;

  while ((( retval =
        accept(my_socket, (struct sockaddr *) (&net_client),
           &addr_len)) == -1) && errno == -1)
    ;
  if (retval == -1)
    return retval;
  hostptr =
    gethostbyaddr((char *) &(net_client.sin_addr.s_addr), 4, AF_INET);
  if (hostptr == NULL)
    fprintf(stderr,"%s:after succesful accept(), client host is UNKNOWN\n",
        this_function);
  else
    fprintf(stderr, "%s: after succesful accept(), client host is %s\n",
        this_function, (*hostptr).h_name);
  other_socket = retval;
  return other_socket;
} /* establish_connection() */

/*---------------------------------------------------------*/
int connect_to_server(char *host, unsigned int port)
{
  char this_function[] = "connect_to_server";
  struct sockaddr_in saddr;
  struct hostent *hp;
  int s;
  int retval;

  fprintf(stderr, "entering %s: args\n\t host = %s, port = %d\n",
      this_function, host, port);

  if ((hp = gethostbyname(host)) == NULL) {
    fprintf(stderr, "Unknown host: %s\n", host);
    return -1;
  }
  saddr.sin_family = hp->h_addrtype;
  memcpy((char *)&saddr.sin_addr, hp->h_addr, hp->h_length);
  saddr.sin_port = htons(port);

  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    perror("creating socket");
    return -1;
  }
  retval=connect(s, (struct sockaddr *)&saddr, sizeof(saddr));
  if (retval < 0) {
    perror("connecting to server");
    return -1;
  }
  fprintf(stderr, "Leaving %s; connected socket %d to host %s\n",
      this_function, s, host);
  return s;
} /* connect_to_server() */

/*------------------------------------------------------------*/

main(argc, argv)
 int argc;
 char *argv[]; 

{
	extern int optind;
	extern char *optarg;
    int rv;
	struct hostent *hp;
	struct servent *sp;
    unsigned int port;
	char *sname={NULL};
	char *hname={NULL};
	char *ename={NULL};
	char *cp;
    char *client_name={NULL};
    int mysocket;
    int s;
	int i;
    int retval; 

	while((rv = getopt(argc,argv,"s:h:p:")) != -1) {
	  switch(rv) {
        case 'p':           /* port number client and server */
            port = atoi(optarg);
            break;
        case 'h':           /* host client contacts  implies client*/
            hname = optarg;
            break;
        case 's':           /* service name to use */
			sname = optarg;
			break;
	    case '?':
		  fprintf(stdout,"Error\n");
		  break;
	  }	  
	}

  if (hname) { /* we are a cleint */
    
    s = connect_to_server(hname, port);
    if (s < 0) 
      exit (1);
    
    retval = ggg_init(sname, 
                      ggg_get_token_socket,
                      (void *)&s,
                      ggg_send_token_socket,
                      (void *)&s);

     fprintf(stderr,"ggg_send retval = %8.8x\n,", retval);

  } else {     /* we are the server */

    /* setup a socket */

    mysocket = create_socket(port);
    s = establish_connection(mysocket);
 
    if (s < 0 )
       exit (1);
    /* do authentication */

    retval = ggg_accept(&client_name,
                        sname,
                        ggg_get_token_socket,
                        (void *)&s,
                        ggg_send_token_socket,
                        (void *)&s);

    fprintf(stderr,"ggg_accept retval = %8.8x", retval);
    if (*client_name) 
      fprintf(stderr,"client= %s\n", client_name);

  }
}
