#include "globus_common.h"

#if HAVE_STRING_H
#include <string.h>
#endif

int main(int argc, char ** argv)
{
    char * dirname;
    char match_str[256];
    char stat_file[1024];
    DIR * globusdir;
    struct dirent * dir_entry;
    struct stat statbuf;
    unsigned long now;
    char buf[1024];
    FILE * stat_fp;
    int status_seconds;
    int rc;

    if (argc != 4)
    {
        fprintf(stderr, "Usage: %s <search directory> <search file str> "
                        "<seconds since accessed>\n", argv[0]);
        return(-1);
    }

    dirname = argv[1];
    sprintf(match_str, "%s", argv[2]);

    if (stat(dirname, &statbuf) != 0)
    {
        fprintf(stderr, "error: invalid directory --> %s\n", dirname);
        return(-1);
    }

    if ((status_seconds = atoi(argv[3])) <= 0 )
    {
        fprintf(stderr, "error: 3rd argument - seconds, invalid\n");
        return(-1);
    }

    globusdir = opendir(dirname);
    if(globusdir == GLOBUS_NULL)
    {
        fprintf(stderr, "error: opening directory %s\n", dirname);
        return(-1);
    }
    else
    {
        now = (unsigned long) time(NULL);
        for(globus_libc_readdir_r(globusdir, &dir_entry);
            dir_entry != GLOBUS_NULL;
            globus_libc_readdir_r(globusdir, &dir_entry))
        {
            if (strstr(dir_entry->d_name, match_str) != NULL)
            {
                fprintf(stderr, "testing file --> %s\n", dir_entry->d_name);
                sprintf(stat_file, "%s/%s", dirname,
                                          dir_entry->d_name);
                if (stat(stat_file, &statbuf) == 0)
                {
                    if ( (now - (unsigned long) statbuf.st_mtime) <=
                         status_seconds)
                    {
                        fprintf(stderr, "found status file --> %s\n",
                             dir_entry->d_name);

                        if ((stat_fp = fopen(stat_file, "r")) == NULL)
                        {
                           fprintf(stderr, "failed to open status file\n");
                           continue;
                        }
                        while((rc = fread(buf, 1, sizeof(buf), stat_fp)) > 0)
                        {
                             fwrite(buf, 1, rc , stdout);
                        }
                        fclose(stat_fp);
                    }
                }
            }
            globus_free(dir_entry);
        }
    }
    globus_libc_closedir(globusdir);

    return 0;
}
