/******************************************************************************
globus_gram_myjob_none.c

Description:

  Implementation of GRAM_MyJob API for a job containing a single process.  See
  gram_myjob.h for generic descriptions of the routines.

CVS Information:

  $Source: /home/globdev/CVS/globus-current/Globus/ResourceManagement/gram/libraries/myjob/globus_gram_myjob_none.c,v $
  $Date: 1998/05/01 21:42:06 $
  $Revision: 1.6 $
  $State: Exp $
  $Author: toonen $
******************************************************************************/

/******************************************************************************
			     Include header files
******************************************************************************/
#include "globus_gram_myjob.h"
#include "globus_common.h"
#include <stdlib.h>


/******************************************************************************
		       Define module specific variables
******************************************************************************/
static globus_bool_t			graml_myjob_initialized = GLOBUS_FALSE;


/******************************************************************************
			 Module activation definitions
******************************************************************************/
static int 
globus_l_gram_myjob_activate();

static int 
globus_l_gram_myjob_deactivate();


globus_module_descriptor_t		globus_i_gram_myjob_module =
{
    "globus_gram_myjob_none",
    globus_l_gram_myjob_activate,
    globus_l_gram_myjob_deactivate,
    GLOBUS_NULL
};


/*
 * globus_l_gram_myjob_activate()
 */
static int 
globus_l_gram_myjob_activate()
{
    graml_myjob_initialized = GLOBUS_TRUE;
    
    return GLOBUS_SUCCESS;
}


/*
 * globus_l_gram_myjob_deactivate()
 */
static int
globus_l_gram_myjob_deactivate()
{
    graml_myjob_initialized = GLOBUS_FALSE;
    
    return GLOBUS_SUCCESS;
}


/******************************************************************************
Function:	globus_gram_myjob_size()

Description:	sets size to one (1)

Parameters:	see API

Returns:	GLOBUS_SUCCESS
		GLOBUS_GRAM_MYJOB_ERROR_NOT_INITIALIZED
		GLOBUS_GRAM_MYJOB_BAD_PARAM
******************************************************************************/
int
globus_gram_myjob_size(
    int *				size)
{
    if (!graml_myjob_initialized)
    {
	return(GLOBUS_GRAM_MYJOB_ERROR_NOT_INITIALIZED);
    }

    if (size == NULL)
    {
	return(GLOBUS_GRAM_MYJOB_ERROR_BAD_PARAM);
    }

    *size = 1;
    return(GLOBUS_SUCCESS);
}


/******************************************************************************
Function:	globus_gram_myjob_rank()

Description:	sets rank to zero (0)

Parameters:	see API

Returns:	GLOBUS_SUCCESS
		GLOBUS_GRAM_MYJOB_ERROR_NOT_INITIALIZED
		GLOBUS_GRAM_MYJOB_BAD_PARAM
******************************************************************************/
int
globus_gram_myjob_rank(
    int *				rank)
{
    if (!graml_myjob_initialized)
    {
	return(GLOBUS_GRAM_MYJOB_ERROR_NOT_INITIALIZED);
    }

    if (rank == NULL)
    {
	return(GLOBUS_GRAM_MYJOB_ERROR_BAD_PARAM);
    }

    *rank = 0;
    return(GLOBUS_SUCCESS);
}


/******************************************************************************
Function:	globus_gram_myjob_send()

Description:	just returns error codes since a process is not allowed to
		send a message to itself

Parameters:	see API

Returns:	
******************************************************************************/
int
globus_gram_myjob_send(
    int					dest_rank,
    globus_byte_t *			msg_buf,
    int					msg_len)
{
    if (!graml_myjob_initialized)
    {
	return(GLOBUS_GRAM_MYJOB_ERROR_NOT_INITIALIZED);
    }

    return(GLOBUS_GRAM_MYJOB_ERROR_BAD_SIZE);
}


/******************************************************************************
Function:	globus_gram_myjob_receive()

Description:	just returns error codes since a process cannot receive
		messages from itself and this is a single process job

Parameters:	see API

Returns:	
******************************************************************************/
int
globus_gram_myjob_receive(
    globus_byte_t *			msg_buf,
    int *				msg_len)
{
    if (!graml_myjob_initialized)
    {
	return(GLOBUS_GRAM_MYJOB_ERROR_NOT_INITIALIZED);
    }

    return(GLOBUS_GRAM_MYJOB_ERROR_BAD_SIZE);
}


/******************************************************************************
Function:	globus_gram_myjob_kill()

Description:	there are two options possibilities here: (a) the process was
		started by gram, so we must have gram cancel it, or (b) the
		process is on it's own and therefore can simply be aborted.

		TODO: implement (a)

Parameters:     see API

Returns:	this will never return
******************************************************************************/
int
globus_gram_myjob_kill()
{
    abort();

    return -1;

}
