/******************************************************************************
grami_gss_init.c

Description:
	Globus GSSAPI Glue routine for client side 
	GSS authentication. 

	No knowledge of gss-api is assumed outside of these
	glue routines. But the return code is the GSS
	major status or 0.


CVS Information:
	$Source: /home/globdev/CVS/globus-current/Globus/ResourceManagement/gram/common/grami_ggg_init.c,v $
	$Date: 1998/02/16 15:29:25 $
	$Revision: 1.8 $
	$Author: dengert $
******************************************************************************/

#ifdef GSS_AUTHENTICATION
/******************************************************************************
                             Include header files
******************************************************************************/

#include <gssapi.h>
#include "grami_ggg.h"
#include <stdio.h>

/******************************************************************************
                               Type definitions
******************************************************************************/

/******************************************************************************
                          Module specific prototypes
******************************************************************************/
/******************************************************************************
                       Define module specific variables
******************************************************************************/

static gss_cred_id_t credential_handle;

/*********************************************************************** *******
Function:   grami_ggg_init_first()
Description:
	Called once at the start to get the clients credential.
	Forces the gssapi_cleartext to do its prompts early. 

Parameters:

Returns:
	zero on sucess
******************************************************************************/
int 
grami_ggg_init_first()
{
    OM_uint32   major_status;
	OM_uint32	mstatus;
    OM_uint32   mstatus2;
    OM_uint32   message_context = 0;
    gss_buffer_desc status_string_desc;
    gss_buffer_t status_string = &status_string_desc;

	credential_handle = GSS_C_NO_CREDENTIAL;

    major_status = gss_acquire_cred(&mstatus,
			GSS_C_NO_NAME,
			GSS_C_INDEFINITE,
			GSS_C_NO_OID_SET,
			GSS_C_INITIATE,
			&credential_handle,
			NULL,
			NULL) ;
    if (major_status != GSS_S_COMPLETE) {
      if (gss_display_status(&mstatus2,
                           major_status,
                           GSS_C_GSS_CODE,
                           GSS_C_NO_OID,
                           &message_context,
                           status_string) == GSS_S_COMPLETE) {
        fprintf(stderr,"%.*s\n",
                      status_string->length,
                      status_string->value);
        gss_release_buffer(&mstatus2,
                         status_string);
        if (gss_display_status(&mstatus2,
                             mstatus,
                             GSS_C_MECH_CODE,
                             GSS_C_NO_OID,
                             &message_context,
                             status_string) == GSS_S_COMPLETE) {
          fprintf(stderr,"%.*s\n",
                     status_string->length,
                     status_string->value);
          gss_release_buffer(&mstatus2, status_string);
        }
      }
    }
	return (major_status);
}

/******************************************************************************
Function:   grami_ggg_init()
Description:
	Initialize a gssapi security connection. Used with the 
	gram_client. 

Parameters:
	globus service name  i.e. globusID of the server being contacted
	a get_token routine 
	first arg for the get_token 
	a send_token routine 
	first arg for the send_token

Returns:
	0 on success
    !=0 on failure. This is the gssapi return value. 

******************************************************************************/
int 
grami_ggg_init(char * ggg_service_name,
               int (*ggg_get_token)(void *, void **, size_t *), 
               void *ggg_get_context,
               int (*ggg_send_token)(void *, void *, size_t),
               void *ggg_send_context)
{

  int context_established = 0;

  OM_uint32 major_status = GSS_S_COMPLETE;
  OM_uint32 minor_status = 0;
  OM_uint32 minor_status2 = 0;
  OM_uint32 message_context = 0;
  gss_ctx_id_t context_handle = GSS_C_NO_CONTEXT;
  gss_name_t target_name;
  gss_OID mech_type = GSS_C_NO_OID;
  OM_uint32  req_flags = GSS_C_DELEG_FLAG|GSS_C_MUTUAL_FLAG;
  OM_uint32  time_req = 0;
  gss_channel_bindings_t input_chan_bindings = NULL;
  gss_buffer_desc input_token_desc;
  gss_buffer_t input_token = &input_token_desc;
  gss_OID * actual_mech_type = NULL;
  gss_buffer_desc output_token_desc;
  gss_buffer_t output_token = &output_token_desc;
  gss_buffer_desc tmp_buffer_desc;
  gss_buffer_t tmp_buffer = &tmp_buffer_desc;
  gss_buffer_desc status_string_desc;
  gss_buffer_t status_string = &status_string_desc;
  OM_uint32 ret_flags = 0;
  OM_uint32 time_rec = 0;

  input_token->length = 0;
  output_token->length = 0;
  status_string->length = 0;

  /* supply the globus service name to the gss-api */

  tmp_buffer->value = ggg_service_name;
  tmp_buffer->length = strlen(ggg_service_name);

  major_status = gss_import_name(&minor_status,
                           tmp_buffer,
                           0  /* (gss_OID) GSS_C_NT_HOSTBASED_SERVICE*/,
                           &target_name);

  if (major_status == GSS_S_COMPLETE)
  while (!context_established) {
    major_status = gss_init_sec_context(&minor_status,
                                        credential_handle,
                                        &context_handle,
                                        target_name,
                                        mech_type,
                                        req_flags,
                                        time_req,
                                        input_chan_bindings,
                                        input_token,
                                        actual_mech_type,
                                        output_token,
                                        &ret_flags,
                                        &time_rec);

    if (output_token->length != 0) {
      if ((ggg_send_token(ggg_send_context, 
                   output_token->value,
                   output_token->length)) < 0) {
        major_status = GSS_S_FAILURE;
        minor_status = 256+1;
      }
      gss_release_buffer(&minor_status,
                          output_token);
    }
    if (GSS_ERROR(major_status)) {
      if (context_handle != GSS_C_NO_CONTEXT)
         gss_delete_sec_context(&minor_status,
                                &context_handle,
                                GSS_C_NO_BUFFER);
        break;
    }
    if (major_status & GSS_S_CONTINUE_NEEDED) {
       if (( ggg_get_token(ggg_get_context,
                        &input_token->value,
                        &input_token->length)) < 0) {
         major_status = GSS_S_FAILURE;
         minor_status = 256+2;
		 break;
       }

    } else {
       context_established = 1;
    }
  } /* end of GSS loop */

  if (input_token->length >0) {
    free(input_token->value); /* alloc done by g_get_token */
    input_token->length = 0;
  }

  /* return GSS status or zero if all ok. */
  if (major_status != GSS_S_COMPLETE) { 
    if (gss_display_status(&minor_status2,
                           major_status,
                           GSS_C_GSS_CODE,
                           GSS_C_NO_OID,
                           &message_context,
                           status_string) == GSS_S_COMPLETE) {
      fprintf(stderr,"%.*s\n",
                      status_string->length,
                      status_string->value);
      gss_release_buffer(&minor_status2,
                         status_string);
      if (gss_display_status(&minor_status2,
                             minor_status,
                             GSS_C_MECH_CODE,
                             GSS_C_NO_OID,
                             &message_context,
                             status_string) == GSS_S_COMPLETE) {
        fprintf(stderr,"%.*s\n",
                     status_string->length,
                     status_string->value);
        gss_release_buffer(&minor_status2, status_string);
      }
    }
                        
	/* for short term, assume the minor can be ored with major */
    return (major_status|minor_status);
    
  
  }
  else
    return 0;
}
#endif /* GSS_AUTHENTICATION */
