/***********************************************************************
*******
  grami_ggg.h

Description:
	This header file contains the Globus GSS Glue 
	routines definitions. 

CVS Information:

	$Source: /home/globdev/CVS/globus-current/Globus/ResourceManagement/gram/common/grami_ggg.h,v $
	$Date: 1999/07/09 23:06:51 $
	$Revision: 1.6 $
	$Author: welch $
************************************************************************
******/
 
#ifndef _GRAM_INCLUDE_GRAMI_GGG_H
#define _GRAM_INCLUDE_GRAMI_GGG_H

#ifdef __cplusplus
 extern "C" {
#endif
/******************************************************************************
                             Include header files
******************************************************************************/

/******************************************************************************
                               Define constants
******************************************************************************/

/******************************************************************************
                               Type definitions
******************************************************************************/

/******************************************************************************
                               Global variables
******************************************************************************/


/******************************************************************************
                              Function prototypes
******************************************************************************/
/* 
	Get and send gss tokens using sockets 
	the first parameter for these is a pointer to the socket
	Other versions of these routines can be defined for 
	passing tokens using other methods. 
 */

extern int
grami_ggg_get_token_socket(void *arg, void **bufp, size_t *sizep);

extern int
grami_ggg_send_token_socket(void *arg,  void *buf, size_t size);

/* init_first  gets the initial security credential for the client */

extern int
grami_ggg_init_first();

/* accept_first  gets the initial security credential for the server */

extern int
grami_ggg_accept_first();

/* accept  uses gss_accept_sec_context */

extern int
grami_ggg_accept(char ** client_name,
               char * server_name,
               int (* get_token)(void *, void **, size_t *),
               void * get_context,
               int (* send_token)(void *, void *, size_t),
               void * send_context);

/* init - used gss_init_sec_context */

extern int
grami_ggg_init(char * server_name,
               int (* get_token)(void *, void **, size_t *),
               void * get_context,
               int (* send_token)(void *, void *, size_t),
               void * send_context);

/* following are in setenv.c */

extern int 
grami_setenv( char *, char *, int);

extern void 
grami_unsetenv(char *);

extern char * 
grami_getenv(char *);

#ifdef __cplusplus
 }
#endif
#endif /* _GRAM_INCLUDE_GRAMI_GGG_H */
