#include <stdio.h>
#include "grami_fprintf.h"

/*
 * grami_fprintf()
 */
#ifdef HAVE_STDARG_H
void grami_fprintf(FILE * grami_fp, char *msg, ...)
#else
void grami_fprintf(FILE * grami_fp, msg, va_alist)
char *msg;
va_dcl
#endif
{
    va_list ap;

#ifdef HAVE_STDARG_H
    va_start(ap, msg);
#else
    va_start(ap);
#endif
    if (grami_fp)
    {
        vfprintf(grami_fp, msg, ap);
        fflush(grami_fp);
        va_end(ap);
    }

} /* grami_fprintf() */
