
#include <stdio.h>
#include <assert.h>

#include "grub_runtime.h"

/********************************************************************
 *
 * GRUB stub application main
 *
 ********************************************************************/

int main (int argc, char* argv[])
{
  int rank, size;
  int err;

  /* intialize and start nexus */
  err = nexus_init(&argc,
		   &argv,
		   "NEXUS_ARGS", /* conf info env variable          */
		   "nx",         /* package designator              */
		   NULL          /* module list                     */);
  assert (!err);
  nexus_enable_fault_tolerance (NULL, NULL);

  grub_barrier ();

  /* job start atomicity is only guaranteed starting here!
   * don't do anything non-restartable before the barrier! */


  /* this is all optional (it's the body of the app) */
  {
    /* this application doesn't do much */
    fprintf (stdout, "hello, world!\n");

    err = grub_myjob_init (&argc, &argv); assert (!err);

    err = grub_myjob_rank (&rank); assert (!err);
    err = grub_myjob_size (&size); assert (!err);

    if ( size > 1 ) {
      /* we have a multi-process job */
      grub_byte_t msg[GRUB_MYJOB_MAX_BUFFER_LENGTH];
      int len;
      int dest;

      if ( rank == 0 ) {
	for (dest=1; dest<size; dest++) {
	  sprintf ((char *)msg, 
		   "hello neighbor %d from your GRUB node zero!",
		   dest);
	  len = strlen ((char *)msg);
	  err = grub_myjob_send (dest, msg, len); assert (!err);
	}
      }
      else {
	err = grub_myjob_receive (msg, &len); assert (!err);
	fprintf (stdout, 
		 "got msg \"%s\"\n",
		 (char *)msg);
      }
    }

    err = grub_myjob_done (); assert (!err);

    /* this app didn't do much */
  }
  /* that was all optional (it's the body of the app) */


  err = nexus_shutdown (); assert (!err);


  /* a non-nexus app could keep doing things here! */


  return 0;
}
