
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <assert.h>

#include "nexus.h"

/* include hdrs needed to print messages and manipulate strings */
#include "grub-utils.h"

/* include hdrs needed to perform tests */
#include "grub-server-request.h"
#include "grub-server.h"
#include "grub-client.h"

/********************************************************************
 *
 * s_gram_callback_func
 *
 ********************************************************************/

static
void s_grub_callback_func (void *user_arg, char *job_contact,
			   int state, int errorcode)
{
  grub_debug (GRUB_DEBUG_TEST,
	      "TEST-GRUB: grub job %s state %d callback\n",
	      job_contact, state);
}

/********************************************************************
 *
 * s_gram_fault_callback_func
 *
 ********************************************************************/

static
int s_grub_fault_callback_func (void *user_arg, int fault_code)
{
  grub_debug (GRUB_DEBUG_TEST,
	      "TEST-GRUB: received nexus fault code %d\n",
	      fault_code);

  return 0;
}


/********************************************************************
 *
 * main
 *
 ********************************************************************/

int main (int argc, char* argv[])
{
  char *server_contact;
  char *callback_contact = NULL;
  
  /* intialize and start nexus */
  nexus_init(&argc,
	     &argv,
	     "NEXUS_ARGS", /* conf info env variable          */
	     "nx",         /* package designator              */
	     NULL          /* module list                     */);
  nexus_enable_fault_tolerance(s_grub_fault_callback_func, NULL);

#ifdef GRUB_SIMULATE_GRAM
  grub_fprintf (stderr, 
		"TEST-GRUB: grub server lib simulating GRAM requests\n");
#endif

  grub_server_startup (&server_contact);

  {
    char *app_path = NULL;
    char *rm = NULL;
    char *rconsole = NULL;
    char *requests[3];
    int size = 1;

    while ( (app_path = getcwd (NULL, size)) == NULL ) size++;
    assert (app_path!=NULL);

    rm = getenv ("GRUB_TEST_RM");
    assert (rm!=NULL);

    grub_debug (GRUB_DEBUG_TEST,
		"TEST-GRUB using RM contact \"%s\"\n",
		rm);

    grub_debug (GRUB_DEBUG_TEST,
		"TEST-GRUB using TEST-GRUB-app path \"%s\"\n",
		app_path);

    rconsole = getenv ("GRUB_RCONSOLE_CONTACT");
    assert (rconsole!=NULL);

    /* COOK UP THE REQUEST STRINGS, using resourceManagerContact from
     * GRUB_TEST_RM env variable and app_path as just discovered
     * for the test executable */

#define RM_IS "resourceManagerContact="
#define COUNT1 "count=1"
#define COUNT2 "count=2"
#define COUNT3 "count=3"
#define STDOUT "stderr=test_out"
#define EXEC_IS "executable="
#define TEST_APP "test-grub-app"
#define ENV_IS "environment="
#define RCONS_IS "GRUB_RCONSOLE_CONTACT:"

    requests[0] = (char*) nexus_malloc ((grub_strlen ("&" "(" RM_IS ")")
				 + grub_strlen (rm)
				 + grub_strlen ("(" COUNT1 ")"
						"(" STDOUT ")")
				 + grub_strlen ("(" EXEC_IS ")")
				 + grub_strlen (app_path)
				 + grub_strlen ("/" TEST_APP)
				 + grub_strlen ("(" ENV_IS RCONS_IS ")")
				 + grub_strlen (rconsole)
				 + 1 /* nul */)
				* sizeof (char));

    grub_sprintf (requests[0], 
		  "&" "(" RM_IS "%s" ")"
		      "(" COUNT1 ")"
		      "(" STDOUT ")"
		      "(" EXEC_IS "%s" "/" TEST_APP ")"
		      "(" ENV_IS RCONS_IS "%s" ")",
		  rm, app_path, rconsole);

    requests[1] = (char*) nexus_malloc ((grub_strlen ("+")
				 + grub_strlen ("(" ")")
				 + grub_strlen ("&" "(" RM_IS ")")
				 + grub_strlen (rm)
				 + grub_strlen ("(" COUNT1 ")"
						"(" STDOUT ")")
				 + grub_strlen ("(" EXEC_IS ")")
				 + grub_strlen (app_path)
				 + grub_strlen ("/" TEST_APP)
				 + grub_strlen ("(" ENV_IS RCONS_IS ")")
				 + grub_strlen (rconsole)

				 + grub_strlen ("(" ")")
				 + grub_strlen ("&" "(" RM_IS ")")
				 + grub_strlen (rm)
				 + grub_strlen ("(" COUNT1 ")"
						"(" STDOUT ")")
				 + grub_strlen ("(" EXEC_IS ")")
				 + grub_strlen (app_path)
				 + grub_strlen ("/" TEST_APP)
				 + grub_strlen ("(" ENV_IS RCONS_IS ")")
				 + grub_strlen (rconsole)
				 
				 + grub_strlen ("(" ")")
				 + grub_strlen ("&" "(" RM_IS ")")
				 + grub_strlen (rm)
				 + grub_strlen ("(" COUNT1 ")"
						"(" STDOUT ")")
				 + grub_strlen ("(" EXEC_IS ")")
				 + grub_strlen (app_path)
				 + grub_strlen ("/" TEST_APP)
				 + grub_strlen ("(" ENV_IS RCONS_IS ")")
				 + grub_strlen (rconsole)
				 + 1 /* nul */)
				* sizeof (char));

    grub_sprintf (requests[1],
		  "+" "(" "&" "(" RM_IS "%s" ")"
		              "(" COUNT1 ")"
		              "(" STDOUT ")"
		              "(" EXEC_IS "%s" "/" TEST_APP ")"
		              "(" ENV_IS RCONS_IS "%s" ")" ")"
		      "(" "&" "(" RM_IS "%s" ")"
		              "(" COUNT1 ")"
		              "(" STDOUT ")"
		              "(" EXEC_IS "%s" "/" TEST_APP ")"
		              "(" ENV_IS RCONS_IS "%s" ")" ")"
		      "(" "&" "(" RM_IS "%s" ")"
		              "(" COUNT1 ")"
		              "(" STDOUT ")"
		              "(" EXEC_IS "%s" "/" TEST_APP ")"
		              "(" ENV_IS RCONS_IS "%s" ")" ")",
		  rm, app_path, rconsole, 
		  rm, app_path, rconsole, 
		  rm, app_path, rconsole);

    requests[2] = (char*) nexus_malloc ((grub_strlen ("+")

				 + grub_strlen ("(" ")")
				 + grub_strlen ("&" "(" RM_IS ")")
				 + grub_strlen (rm)
				 + grub_strlen ("(" COUNT1 ")"
						"(" STDOUT ")")
				 + grub_strlen ("(" EXEC_IS ")")
				 + grub_strlen (app_path)
				 + grub_strlen ("/" TEST_APP)
				 
				 + grub_strlen ("(" ")")
				 + grub_strlen ("&" "(" RM_IS ")")
				 + grub_strlen (rm)
				 + grub_strlen ("(" COUNT1 ")"
						"(" STDOUT ")")
				 + grub_strlen ("(" EXEC_IS ")")
				 + grub_strlen (app_path)
				 + grub_strlen ("/" TEST_APP)
				 + 1 /* nul */)
				* sizeof (char));

    grub_sprintf (requests[2],
		  "+" "(" "&" "(" RM_IS "%s" ")"
		              "(" COUNT1 ")"
		              "(" STDOUT ")"
		              "(" EXEC_IS "%s" "/" TEST_APP ")" ")"
		      "(" "&" "(" RM_IS "%s" ")"
		              "(" COUNT1 ")"
		              "(" STDOUT ")"
		              "(" EXEC_IS "%s" "/" TEST_APP ")" ")",
		  rm, app_path, rm, app_path);

    grub_callback_allow (s_grub_callback_func, NULL, &callback_contact);

    {
      char *job_contacts[3];
      int res;
      /*
      grub_fprintf (stderr, 
		   "\nTEST-GRUB: "
		   "performing grub server lib test allocations...\n");

      grub_fprintf (stderr,
		    "\nTEST-GRUB request: \"%s\"\n\n", requests[0]);
      res = grub_server_job_request (requests[0],
				     0, callback_contact, &(job_contacts[0]));
      grub_fprintf (stderr, 
		    "TEST-GRUB result: %s\n\n",
		    ((res==GRUB_SUCCESS) ? "success" : "failure"));

      grub_fprintf (stderr,
		    "\nTEST-GRUB request: \"%s\"\n", requests[1]);
      res = grub_server_job_request (requests[1],
				     0, callback_contact, &(job_contacts[1]));
      grub_fprintf (stderr, 
		    "TEST-GRUB result: %s\n\n",
		    ((res==GRUB_SUCCESS) ? "success" : "failure"));

      grub_fprintf (stderr,
		   "\nTEST-GRUB request: \"%s\"\n", requests[2]);
      res = grub_server_job_request (requests[2],
				     0, callback_contact, &(job_contacts[2]));
      grub_fprintf (stderr, 
		    "TEST-GRUB result: %s\n\n",
		    ((res==GRUB_SUCCESS) ? "success" : "failure"));
		    */
    }

    {
      char *job_contacts[3];
      int res;

      grub_fprintf (stderr, 
		   "\nTEST-GRUB: "
		    "performing grub client lib test allocations...\n");

      grub_fprintf (stderr,
		   "\nTEST-GRUB request: \"%s\"\n", requests[0]);
      res = grub_job_request (server_contact,
			      requests[0],
			      0, callback_contact, &job_contacts[0]);
      grub_fprintf (stderr, 
		    "TEST-GRUB result: %s\n\n",
		    ((res==GRUB_SUCCESS) ? "success" : "failure"));

      grub_fprintf (stderr,
		   "\nTEST-GRUB request: \"%s\"\n", requests[1]);
      res = grub_job_request (server_contact,
			      requests[1],
			      0, callback_contact, &(job_contacts[1]));
      grub_fprintf (stderr, 
		    "TEST-GRUB result: %s\n\n",
		    ((res==GRUB_SUCCESS) ? "success" : "failure"));

      /*
      grub_fprintf (stderr,
		   "\nTEST-GRUB request: \"%s\"\n", requests[2]);
      res = grub_job_request (server_contact,
			      requests[2],
			      0, callback_contact, &(job_contacts[2]));
      grub_fprintf (stderr, 
		    "TEST-GRUB result: %s\n\n",
		    ((res==GRUB_SUCCESS) ? "success" : "failure"));
		    */
    }

  }

  grub_debug (GRUB_DEBUG_TEST,
	      "\nTEST-GRUB shutting down grub server...\n");

  grub_server_shutdown ();

  grub_debug (GRUB_DEBUG_TEST,
	      "TEST-GRUB closing callback port...\n");

  grub_callback_disallow (callback_contact);

  grub_debug (GRUB_DEBUG_TEST,
	      "TEST-GRUB shutting down nexus...\n");

  nexus_shutdown ();

  /* can't use grub-util functions after shutting down nexus */
  if (GRUB_DEBUG && GRUB_DEBUG_TEST) {
    fprintf (stderr, 
	     "TEST-GRUB exiting...\n");
  }

  return 0;
}
