
#ifndef GLOBUS_DUROC_RUNTIME_H
#define GLOBUS_DUROC_RUNTIME_H


#include "nexus.h"
#include "globus_duct_runtime.h"

#include "globus_common.h"
#include "globus_duroc_common.h"

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif
 
EXTERN_C_BEGIN


extern int 
globus_duroc_runtime_activate (void);

extern int
globus_duroc_runtime_deactivate (void);

extern void
globus_duroc_runtime_atexit ();
extern globus_module_descriptor_t globus_duroc_runtime_module;
#define GLOBUS_DUROC_RUNTIME_MODULE (&globus_duroc_runtime_module)

#define GLOBUS_DUROC_RUNTIME_INTRA_SEND_PROTOCOL_VERSION    250
#define GLOBUS_DUROC_RUNTIME_INTER_SEND_PROTOCOL_VERSION    350

extern void
globus_duroc_runtime_barrier ();

extern int 
globus_duroc_runtime_inter_subjob_send (int             dst_addr,
					const char    * tag,
					int             msg_size,
					globus_byte_t * msg);

extern int
globus_duroc_runtime_inter_subjob_receive (const char     * tag,
					   int            * msg_sizep,
					   globus_byte_t ** msgp);

extern int 
globus_duroc_runtime_inter_subjob_structure (int  * local_address,
					     int  * remote_count,
					     int ** remote_addresses);

extern int
globus_duroc_runtime_intra_subjob_rank (int * rankp);

extern int
globus_duroc_runtime_intra_subjob_size (int * sizep);

extern int
globus_duroc_runtime_intra_subjob_send (int             dest_addr,
					const char    * tag,
					int             msg_len,
					globus_byte_t * msg);

extern int
globus_duroc_runtime_intra_subjob_receive (const char    * tag,
					   int           * msg_lenp,
					   globus_byte_t * msgp);


EXTERN_C_END

#endif /* GLOBUS_DUROC_RUNTIME_H */

