
#ifndef GLOBUS_DUROC_COMMON_H_INTERNAL
#define GLOBUS_DUROC_COMMON_H_INTERNAL

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif
 

#include "globus_duroc_common.h"

#include "nxbuff.h"
#include "rsl.h"
#include "utils.h"

EXTERN_C_BEGIN


#ifdef GLOBUS_DUROC_DEBUG
#define GLOBUS_DUROC_DEBUG_FLAG 1
#else
#define GLOBUS_DUROC_DEBUG_FLAG 0
#endif

#ifdef    GLOBUS_DUROC_ABORT_AT_ERROR

#define globus_duroc_at_error(string, intcode) \
    (assert(0))

#elif defined(GLOBUS_DUROC_VERBOSE_AT_ERROR)
     
#define globus_duroc_at_error(string, intcode) \
     (utils_debug (1 /* always enable */, \
		   "%s: %d: %s failure %d\n", \
		   __FILE__, __LINE__, string, intcode), \
      (0))
     
#else

#define globus_duroc_at_error(string, intcode) \
    (utils_debug (0 /* always disable */, \
                  ""), \
     (0))

#endif /* GLOBUS_DUROC_ABORT_AT_ERROR */


EXTERN_C_END

#endif /* GLOBUS_DUROC_COMMON_H_INTERNAL */

