
#ifndef GLOBUS_DUROC_CONTROL_INTERNAL_CONTROL_H
#define GLOBUS_DUROC_CONTROL_INTERNAL_CONTROL_H


#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif
 
 

/*
 * This file declares the globus_duroc_control_t support routines.
 *
 * globus_duroc_control_t is instantiated to perform DUROC job-control operations
 * the public interface API is defined in globus_duroc_control.h
 *
 * these routines are used by duroc-control.c
 */

#include <assert.h>

#include "nexus.h"

#include "subjob.h"
#include "job_monitor.h"
#include "globus_duroc_control.h"

EXTERN_C_BEGIN

int globus_duroc_control_init (globus_duroc_control_t * controlp);

void globus_duroc_control_destroy (globus_duroc_control_t *controlp);

int 
globus_duroc_control_i_control_make_job_no (globus_duroc_control_t *controlp);
int 
globus_duroc_control_i_control_link_job (globus_duroc_control_t     * controlp,
				  globus_duroc_job_monitor_t * job_monitorp);
void
globus_duroc_control_i_control_unlink_job (globus_duroc_control_t *controlp,
				    globus_duroc_job_monitor_t *job_monitorp);
int
globus_duroc_control_i_control_link_gram (globus_duroc_control_t * controlp,
				   const char * contact,
				   int serialno);
void 
globus_duroc_control_i_control_unlink_gram (globus_duroc_control_t *controlp,
				     const char * contact);
int
globus_duroc_control_i_subjob_contacts (globus_duroc_control_t * controlp,
			       globus_duroc_job_monitor_t * job_monitorp,
			       int    * subjob_countp,
			       char *** subjob_contactsp,
			       char *** subjob_labelsp);


/*
 * generate the job contact string for this
 * <control, job_monitor> pair
 *
 * contacts include communications info and a
 * linearized job_monitor state snapshot to allow limited
 * failure-handling by the outside agent
 * (globus_duroc_job_kill can fall back on a 'controlless' kill
 * of the snapshot job if the real control is unavailable)
 */
int globus_duroc_control_job_contact (globus_duroc_control_t      * controlp,
			       globus_duroc_job_monitor_t  * job_monitorp,
			       char                ** contact);

/*
 * get job_monitor_t record for contact
 * atomically increments record ref_count
 * on success and s_job_release must be called after use
 */
int
globus_duroc_control_i_job_lookup (globus_duroc_control_t * controlp,
			    const char * job_contact,
			    globus_duroc_job_monitor_t ** job_monitorpp);

int
globus_duroc_control_i_control_open_gram (globus_duroc_control_t * controlp);

/*
 * get job_monitor_t record for label
 * atomically increments record ref_count
 * on success and s_job_release must be called after use
 */
int 
globus_duroc_control_i_job_lookup_by_gram (globus_duroc_control_t      * controlp,
				const char           * globus_gram_contact,
				globus_duroc_job_monitor_t ** job_monitorpp);

/*
 * get job_monitor_t record for label
 * atomically increments record ref_count
 * on success and s_job_release must be called after use
 */
int
globus_duroc_control_i_job_lookup_by_serialno (globus_duroc_control_t      * controlp,
				    int                    serialno,
				    globus_duroc_job_monitor_t ** job_monitorpp);

void
globus_duroc_control_i_job_monitor_release (globus_duroc_control_t      * controlp,
				     globus_duroc_job_monitor_t ** job_monitorpp);


int 
globus_duroc_control_i_subjob_delete (globus_duroc_control_t     * controlp,
			       globus_duroc_job_monitor_t * job_monitorp,
			       const char          * subjob_label);

int
globus_duroc_control_i_control_contact_lsp (globus_duroc_control_t  * controlp,
				     char           ** contact);

void
globus_duroc_control_i_subjob_kill (globus_duroc_subjob_t *subjobp);

int 
globus_duroc_control_i_subjob_delete (globus_duroc_control_t      *controlp,
			       globus_duroc_job_monitor_t *job_monitorp,
			       const char          *subjob_label);

/*
 * for each GRAM state callback:
 * -- if job ID is mappable to job monitor
 * -- -- enter state update into job monitor
 * -- -- propogate/synthesize state to client ?
 * -- else if job ID is mappable to deferral structure
 * -- -- enter state update into deferral structure
 * -- else if deferral possible
 * -- -- add deferral mapping to callback demux table
 * -- -- enter state update into deferral structure
 */


/*
 * for each subjob checkin message:
 * -- enter check-in data into job monitor
 * -- send RUN ? [if committed and complete check-in]
 */


EXTERN_C_END

#endif /* GLOBUS_DUROC_CONTROL_INTERNAL_CONTROL_H */

