/**********************************************************************
$Id: measure_clock.c,v 1.1 1997/07/23 22:04:11 tuecke Exp $

$Source: /home/globdev/CVS/globus-current/Globus/Miscellaneous/utp/measure_clock/measure_clock.c,v $

$Log: measure_clock.c,v $
Revision 1.1  1997/07/23 22:04:11  tuecke
First pass at integrating Dave Kohr UTP timing package into nexus

Revision 1.3  1994/11/08 16:44:37  kohr
Use mode argument to UTP_init(), use new UTP_warn().

Revision 1.2  1994/11/03  19:53:15  kohr
Move current source from RCS to CVS control.

Revision 1.1  1994/10/25  20:42:51  tuecke
An initial version of Dave Kohr's timing package

Measure clock cost using UTP.
**********************************************************************/

/**********************************************************************
Uses some private UTP functions.
**********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "UTP.h"
#include "UTP_private.h"


#define NUM_REPS 1000		/* #repetitions of all tests. */
#define NUM_TESTS 3		/* 3 tests of UTP timers: start, stop, and
				   start-stop. */
#define TIMER_FOR_START      0	/* Timer ID's for the tests. */
#define TIMER_FOR_STOP       1
#define TIMER_FOR_START_STOP 2
#define OUTFILENAME "utp_dump-clocks.txt"

/**********************************************************************
Leaves output in the file "utp_dump-clocks.txt".  This file is not in
regular UTP format: the header and 3 following timer value records are
normal, but the rest consists of a large number of single-field records
containing just the elapsed time thus far (with the first such record
normalized to 0.0).  These records permit analysis of the variation in cost
of acquiring the clock value.
**********************************************************************/


int main(int argc, char *argv[])
{
	UTP_TimeValue_t *timeValues, startValue;
	int i;
	FILE *outFile;

	if (!(timeValues = (UTP_TimeValue_t *)
	      malloc((NUM_REPS + 1) * sizeof(UTP_TimeValue_t)))) {
		UTP_warn("measure-clock : malloc() failed: \"%s\"",
			 sys_errlist[errno]);
		return 1;
	}
				/* Fault buffer into memory. */
	for (i = 0; i < NUM_REPS + 1; i++)
		UTP_timeZero(&timeValues[i]);

	UTP_init(NUM_REPS + NUM_TESTS, UTP_MODE_SHARED);

/**********************************************************************
Do start, stop, and start-stop tests, using public UTP facilities.
**********************************************************************/


				/* Do the start test. */
	UTP_start_timer(TIMER_FOR_START);
	for (i = 0; i < NUM_REPS; i++)
		UTP_start_timer(i + NUM_TESTS);
	UTP_stop_timer(TIMER_FOR_START);

				/* Do the stop test. */
	UTP_start_timer(TIMER_FOR_STOP);
	for (i = 0; i < NUM_REPS; i++)
		UTP_stop_timer(i + NUM_TESTS);
	UTP_stop_timer(TIMER_FOR_STOP);

				/* Do the start-stop test. */
	UTP_start_timer(TIMER_FOR_START_STOP);
	for (i = 0; i < NUM_REPS; i++) {
		UTP_start_timer(i + NUM_TESTS);
		UTP_stop_timer(i + NUM_TESTS);
	}
	UTP_stop_timer(TIMER_FOR_START_STOP);

				/* This fairly gross hack inhibits printing
				   of values for the NUM_REPS timers being
				   measured (we don't care about their
				   values, just how long it took to get
				   them. */
	UTP_numTimers = NUM_TESTS;

	UTP_set_filename(OUTFILENAME);

	UTP_shutdown();

/**********************************************************************
Now acquire the time repeatedly using low-level, private UTP facilities. Do
this (NUM_REPS + 1) times, to get NUM_REPS spacings between clock
acquisition events for subsequent analysis.  Append the resulting times to
file OUTFILENAME using stdio and private UTP facilities.
**********************************************************************/

	for (i = 0; i < NUM_REPS + 1; i++)
		UTP_readTime(&timeValues[i]);

				/* Normalize all values to first one. */
				/* Using memcpy() is a bit of a hack....*/
	memcpy(&startValue, &timeValues[0], sizeof(UTP_TimeValue_t));
	for (i = 0; i < NUM_REPS + 1; i++)
		UTP_timeDifference(&timeValues[i], &startValue,
				   &timeValues[i]);

	if (!(outFile = fopen(OUTFILENAME, "a"))) {
		UTP_warn("measure-clock: fopen() on file \"%s\" failed",
			 OUTFILENAME);
		UTP_warn("measure-clock: system error message is "
			 "\"%s\"", sys_errlist[errno]);
		return 1;
	}

	for (i = 0; i < NUM_REPS + 1; i++) {
		char buff[30];

		UTP_timeToString(buff, &timeValues[i]);
		fprintf(outFile, "%s\n", buff);
	}

	if (fclose(outFile)) {
		UTP_warn("measure-clock: fclose() on file \"%s\" failed",
			 OUTFILENAME);
		UTP_warn("measure-clock: system error message is "
			 "\"%s\"", sys_errlist[errno]);
		return 1;
	}

	return 0;
}
