C     $Id: test_fortran.f,v 1.1 1997/07/23 22:04:11 tuecke Exp $
C
C     $Source: /home/globdev/CVS/globus-current/Globus/Miscellaneous/utp/fortran/test_fortran.f,v $
C
C     $Log: test_fortran.f,v $
C     Revision 1.1  1997/07/23 22:04:11  tuecke
C     First pass at integrating Dave Kohr UTP timing package into nexus
C
C     Revision 1.2  1994/11/03 19:53:21  kohr
C     Move current source from RCS to CVS control.
C
C     Revision 1.1  1994/11/03  19:48:54  kohr
C     First version under CVS control.
C
C     Test Fortran InterFace of UTP timing package.

C     Pre-CVS version information:
C
C     Revision 1.2  1994/11/03  02:25:17  kohr
C     Added enable/disable and key/value attributes.
C
C     Revision 1.1  1994/10/28  19:00:45  kohr
C     Initial revision

      program main

      implicit none

      include 'UTP_fortran.h'

      integer NUM_REPS, NUM_TESTS, TIMER_FOR_START, TIMER_FOR_STOP,
     &    TIMER_FOR_START_STOP, NUM_TIMERS
      parameter (NUM_REPS = 10)
      parameter (NUM_TESTS = 3)
      parameter (TIMER_FOR_START = 0)
      parameter (TIMER_FOR_STOP = 1)
      parameter (TIMER_FOR_START_STOP = 2)
      parameter (NUM_TIMERS = NUM_REPS + NUM_TESTS)

      integer i, prec
      double precision t

      call utp_init(NUM_TIMERS, UTP_MODE_SHARED)

      call utp_set_attribute('expected-message-1',
     &    'Timer  3 had time   .000278 at precision  6')

      call utp_start_timer(TIMER_FOR_START)
      do i = 0, NUM_REPS - 1
          call utp_start_timer(i + NUM_TESTS)
      end do
      call utp_stop_timer(TIMER_FOR_START)

      call utp_start_timer(TIMER_FOR_STOP)
      do i = 0, NUM_REPS - 1
          call utp_stop_timer(i + NUM_TESTS)
      end do
      call utp_stop_timer(TIMER_FOR_STOP)

      call utp_start_timer(TIMER_FOR_START_STOP)
      do i = 0, NUM_REPS - 1
          call utp_start_timer(i + NUM_TESTS)
          call utp_stop_timer(i + NUM_TESTS)
      end do
      call utp_stop_timer(TIMER_FOR_START_STOP)

      t = 3.456
      call utp_get_accum_time(NUM_TESTS, t, prec)

      print *, 'Timer ', NUM_TESTS, ' had time ', t, ' at precision ',
     &    prec

      call utp_reset_timer(NUM_TESTS)

      call utp_disable_timer(NUM_TESTS + 1)
      call utp_stop_timer(NUM_TESTS + 1)

      call utp_disable_timer(NUM_TESTS + 2)
      call utp_enable_timer(NUM_TESTS + 2)
      call utp_start_timer(NUM_TESTS + 2)
      call utp_stop_timer(NUM_TESTS + 2)

      call utp_name_timer(NUM_TESTS, 'I am a timer with no time!')

      call utp_set_filename('utp_dump_test_f.txt')

      call UTP_shutdown()

      end
