/**********************************************************************
$Id: nexus_utp_fortran.c,v 1.1 1997/07/23 22:04:10 tuecke Exp $

$Source: /home/globdev/CVS/globus-current/Globus/Miscellaneous/utp/fortran/nexus_utp_fortran.c,v $

$Log: nexus_utp_fortran.c,v $
Revision 1.1  1997/07/23 22:04:10  tuecke
First pass at integrating Dave Kohr UTP timing package into nexus

Revision 1.2  1994/11/03 19:52:29  kohr
Move current source from RCS to CVS control.

Revision 1.1  1994/10/25  20:41:58  tuecke
An initial version of Dave Kohr's timing package

FORTRAN language binding for the Unnamed Timing Package (UTP).
**********************************************************************/

/*
Pre-CVS version information:

Revision 1.4  1994/11/03  02:25:17  kohr
Added enable/disable and key/value attributes.

Revision 1.3  1994/10/28  04:20:29  kohr
Got FORTRAN interface working properly.

Revision 1.2  1994/10/07  03:55:48  kohr
Added utp_set_filename(), utp_get_accum_time().

Revision 1.1  1994/09/16  20:09:43  kohr
Initial revision
*/

#include <stdio.h>
#include <string.h>

#include "fortran_types.h"

#include "UTP.h"
#include "UTP_private.h"


void
FORTRAN_CALLABLE(utp_init) (f_integer_t *_numTimers, f_integer_t *_mode)
{
	int numTimers = *_numTimers, mode = *_mode;

	UTP_init(numTimers, mode);
}

void
FORTRAN_CALLABLE(utp_set_filename) (f_character_t outFilename
				    CHAR_LEN_DECL(outFilenameLen))
{
	char buff[UTP_MAX_NAME_LENGTH];
	LOCAL_CHAR_LEN_DECL(outFilenameLen)

	CONVERT_CHAR_FTN_TO_C_INPLACE(outFilename, outFilenameLen, buff)

	UTP_set_filename(buff);
}

void
FORTRAN_CALLABLE(utp_set_attribute) (f_character_t keyStr,
				     f_character_t valueStr
				     CHAR_LEN_DECL(keyStrLen)
				     CHAR_LEN_DECL(valueStrLen))
{
	char keyBuff[UTP_MAX_NAME_LENGTH];
	char valueBuff[UTP_MAX_NAME_LENGTH];
	LOCAL_CHAR_LEN_DECL(keyStrLen)
	LOCAL_CHAR_LEN_DECL(valueStrLen)

	CONVERT_CHAR_FTN_TO_C_INPLACE(keyStr, keyStrLen, keyBuff);
	CONVERT_CHAR_FTN_TO_C_INPLACE(valueStr, valueStrLen, valueBuff);

	UTP_set_attribute(keyBuff, "", valueBuff);
}

void
FORTRAN_CALLABLE(utp_start_timer) (f_integer_t *_timerNumber)
{
	int timerNumber = *_timerNumber;

	UTP_start_timer(timerNumber);
}

void
FORTRAN_CALLABLE(utp_stop_timer) (f_integer_t *_timerNumber)
{
	int timerNumber = *_timerNumber;

	UTP_stop_timer(timerNumber);
}

void
FORTRAN_CALLABLE(utp_reset_timer) (f_integer_t *_timerNumber)
{
	int timerNumber = *_timerNumber;

	UTP_reset_timer(timerNumber);
}

void
FORTRAN_CALLABLE(utp_disable_timer) (f_integer_t *_timerNumber)
{
	int timerNumber = *_timerNumber;

	UTP_disable_timer(timerNumber);
}

void FORTRAN_CALLABLE(utp_enable_timer) (f_integer_t *_timerNumber)
{
	int timerNumber = *_timerNumber;

	UTP_enable_timer(timerNumber);
}

void FORTRAN_CALLABLE(utp_disable_all_timers) (void)
{
	UTP_disable_all_timers();
}

void FORTRAN_CALLABLE(utp_enable_all_timers) (void)
{
	UTP_enable_all_timers();
}

void
FORTRAN_CALLABLE(utp_name_timer) (f_integer_t *_timerNumber,
				  f_character_t nameStr
				  CHAR_LEN_DECL(nameLen))
{
	int timerNumber = *_timerNumber;
	char buff[UTP_MAX_NAME_LENGTH];
	LOCAL_CHAR_LEN_DECL(nameLen)

	CONVERT_CHAR_FTN_TO_C_INPLACE(nameStr, nameLen, buff);

	UTP_name_timer(timerNumber, buff);
}

void
FORTRAN_CALLABLE(utp_get_accum_time) (f_integer_t *_timerNumber, 
				      f_double_t *_time,
				      f_integer_t *_precision)
{
	int timerNumber = *_timerNumber;
	double time;
	int precision;

	UTP_get_accum_time(timerNumber, &time, &precision);

	*_time = time;
	*_precision = precision;
}

void
FORTRAN_CALLABLE(utp_shutdown) (void)
{
	UTP_shutdown();
}
