/**********************************************************************
$Id: fortran_types.h,v 1.1 1997/07/23 22:04:10 tuecke Exp $

$Source: /home/globdev/CVS/globus-current/Globus/Miscellaneous/utp/fortran/fortran_types.h,v $

$Log: fortran_types.h,v $
Revision 1.1  1997/07/23 22:04:10  tuecke
First pass at integrating Dave Kohr UTP timing package into nexus

Revision 1.4  1995/04/06 22:52:50  kohr
Handle trailing underscores properly.

Revision 1.3  1995/04/06  22:25:46  kohr
RS6000 uses trailing underscore now.

Revision 1.2  1994/11/03  19:53:08  kohr
Move current source from RCS to CVS control.

Revision 1.1  1994/11/03  19:48:46  kohr
First version under CVS control.

Macros for converting between C and FORTRAN data representations.
**********************************************************************/

/*
Pre-CVS version information:

Revision 1.4  1994/11/02  20:22:41  kohr
Improve documentation in comments.

Revision 1.3  1994/10/31  22:08:14  kohr
Add support for f77 under FreeBSD.

Revision 1.2  1994/10/28  04:21:16  kohr
Moved in FORTRAN_CALLABLE, fixed EXTRACT_CHAR_LEN and other stuff.

Revision 1.1  1994/10/27  03:45:13  kohr
Initial revision
*/


/*
Originally developed by Bob Olson (I think).
*/


#ifndef _fortran_types_h
#define _fortran_types_h


/*
Turn funcName (which must be all lower-case) into something callable from
FORTRAN, typically by appending one or more underscores.
*/

#if defined(RS6000)
#define FORTRAN_CALLABLE(funcName) funcName

#elif defined(__FreeBSD__)
#define FORTRAN_CALLABLE(funcName) funcName ## __

#else
#define FORTRAN_CALLABLE(funcName) funcName ## _

#endif


/**********************************************************************
Macros for abstracted Fortran string handling.

String arguments in a C routine that is Fortran-callable should be writting
as follows. Both the CHAR_LEN_DECL and the LOCAL_CHAR_LEN_DECL are required
(either one or the other actually expands into something non-null, based on
the platform the program is being compiled on).

FORTRAN_CALLABLE(cfunc) (f_character_t string_arg,
			 f_character_t string_arg2
			 CHAR_LEN_DECL(string_len)
			 CHAR_LEN_DECL(string2_len))
{
	char *cstr, buf[1000];
	LOCAL_CHAR_LEN_DECL(string_len)
	LOCAL_CHAR_LEN_DECL(string2_len)
	int the_length;
	char *the_characters;

	CONVERT_CHAR_FTN_TO_C_MALLOC(string_arg, string_len, cstr);
	CONVERT_CHAR_FTN_TO_C_INPLACE(string_arg, string_len, buf);
	EXTRACT_CHAR_LEN(string_arg, string_len, the_length)
	EXTRACT_CHAR_PTR(string_arg, the_characters)
}
**********************************************************************/

/*
Cray FORTRAN represents a character string as a structure containing a
length and a pointer to the character array.  A pointer to this structure
is passed to the callee.  Functions are provided in <fortran.h> to access
different parts of this structure.
*/

#ifdef CRAY
#include <fortran.h>
#define CHAR_LEN_DECL(varname)
#define CHAR_LEN(varname)
#define LOCAL_CHAR_LEN_DECL(varname) int varname;
#define CONVERT_CHAR_FTN_TO_C_INPLACE(ftn_char, len, buf) \
	{ int cpy_len; \
	len = _fcdlen(ftn_char); \
	cpy_len = (len >= sizeof(buf)) ? (sizeof(buf) - 1) : len; \
	strncpy(buf, _fcdtocp(ftn_char), cpy_len); \
	buf[cpy_len] = '\0'; \
        }
#define CONVERT_CHAR_FTN_TO_C_MALLOC(ftn_char, len, ptr) \
	len = _fcdlen(ftn_char); \
	NexusMalloc(convert_char_ftn_to_c_malloc(), ptr, char *, len + 1); \
	strncpy(ptr, _fcdtocp(ftn_char), len); \
	ptr[len] = '\0';
#define CONVERT_CHAR_C_TO_FTN(ftn_char, buf, len) \
	len = strlen(buf); \
	ftn_char = _cptofcd(buf, len);
#define EXTRACT_CHAR_PTR(ftn_char, ptr) \
	ptr = _fcdtocp(ftn_char);
#define EXTRACT_CHAR_LEN(ftn_char, ftn_char_len, dest) \
	dest = _fcdlen(ftn_char);

#else

/*
All other FORTRAN's we've ported to pass character strings as 2 separate 
arguments: a pointer to the array of characters (passed in the same
position as the actual argument in the call), and "silent" trailing
arguments representing the length of the string, which appear in the same
left-to-right order as did the actual string arguments.
*/

#define CHAR_LEN_DECL(varname) , int varname
#define CHAR_LEN(varname) varname
#define LOCAL_CHAR_LEN_DECL(varname)
#define CONVERT_CHAR_FTN_TO_C_INPLACE(ftn_char, len, buf) \
	{ int cpy_len; \
	cpy_len = (len >= sizeof(buf)) ? (sizeof(buf) - 1) : len; \
	strncpy(buf, ftn_char, cpy_len); \
	buf[cpy_len] = '\0'; \
        }
#define CONVERT_CHAR_FTN_TO_C_MALLOC(ftn_char, len, ptr) \
	NexusMalloc(convert_char_ftn_to_c_malloc(), ptr, char *, len + 1); \
	strncpy(ptr, ftn_char, len);\
	ptr[len] = '\0';
#define CONVERT_CHAR_C_TO_FTN(ftn_char, buf, len) \
	len = strlen(buf); \
	ftn_char = buf;
#define EXTRACT_CHAR_PTR(ftn_char, ptr) \
	ptr = ftn_char;
#define EXTRACT_CHAR_LEN(ftn_char, ftn_char_len, dest) \
	dest = ftn_char_len;
#endif

/*
Macros for dealing with logical types.
*/

#ifdef CRAY

#define FTN_LOGICAL_TRUE _btol(1)
#define FTN_LOGICAL_FALSE _btol(0)

/* Argument to FTN_LOGICAL_TO_LONG is a pointer */
#define FTN_LOGICAL_TO_LONG(v) _ltob(v)

/* Argument to FTN_LOGICAL_TO_LONG is an integer */
#define LONG_TO_FTN_LOGICAL(v) _btol(v)

#else

#define FTN_LOGICAL_TRUE 1
#define FTN_LOGICAL_FALSE 0

/* Argument to FTN_LOGICAL_TO_LONG is a pointer */
#define FTN_LOGICAL_TO_LONG(v) ((long) (*(v)))

/* Argument to FTN_LOGICAL_TO_LONG is an integer */
#define LONG_TO_FTN_LOGICAL(v) ((long) (v) == 0 ? 0 : 1)

#endif

/*
Fortran data types
*/

#ifdef CRAY

typedef _fcd f_character_t;
typedef _f_log f_logical_t;
typedef _f_int f_integer_t;
typedef _f_real f_real_t;
typedef _f_real16 f_doubleprecision_t;
typedef _f_real16 f_double_t;

#else

typedef char *f_character_t;
typedef char f_char_t;
typedef int f_logical_t;
typedef int f_integer_t;
typedef float f_real_t;
typedef double f_doubleprecision_t;
typedef double f_double_t;

#endif

typedef struct _f_complex_t
{
    f_real_t r;
    f_real_t i;
} f_complex_t;

typedef struct _f_doublecomplex_t
{
    f_doubleprecision_t r;
    f_doubleprecision_t i;
} f_doublecomplex_t;


#endif /* _fortran_types_h */

