
#ifndef _LOGGING_H_
#define _LOGGING_H_

/*****************************************************************

This software is copyright (C) by the Lawrence Berkeley National Laboratory.
Permission is granted to reproduce this software for non-commercial
purposes provided that this notice is left intact.

It is acknowledged that the U.S. Government has rights to this software
under Contract DE-AC03-76SF00098 between the U.S.  Department of Energy
and the University of California.

This software is provided as a professional and academic contribution
for joint exchange. Thus, it is experimental, and is provided ``as is'',
with no warranties of any kind whatsoever, no support, no promise of
updates, or printed documentation. By using this software, you
acknowledge that the Lawrence Berkeley Laboratory and Regents of the
University of California shall have no liability with respect to the
infringement of other copyrights by any part of this software.

For further information about this notice, contact Brian L. Tierney
Bld. 50B, Rm. 2239, Lawrence Berkeley National Laboratory, Berkeley, CA, 94720
(bltierney@lbl.gov)

*******************************************************/

#include <stdio.h>

#if defined(GLOBUS_NETLOGGER_ENABLED)
#   include "globus_config.h"
#   if defined(GLOBUS_IO_ENABLED)
#       include "globus_common.h"
#       include "globus_io.h"
#   endif
#endif

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/*
 * Tedesco Jean: add the conditionnal compilation of the stuff I add for  
 * timestamps  correction 
 */
#define CORRECT_TIMESTAMPS

#define NL_FILE 0
#define NL_SYSLOG 1
#define NL_HOST 2
#define NL_FILE_MEM 3
#define NL_SYSLOG_MEM 4
#define NL_HOST_MEM 5

#define NL_MAX_BUFFER 10 * 1024 /* maximum number of events to buffer in memory
			before requiring a NetLoggerFlush call */

#ifndef  DPSS_NETLOGGER_PORT
#define DPSS_NETLOGGER_PORT 14830
#endif

typedef struct _loginfo {
    int method;
    FILE *log_fp;
    int log_socket;
    char *pname;
    char *hname;
    char *level;
    int hold;  /* hold messages in memory untill NetLoggerFlush() called */ 
    int num_events;
    char **event_buffer;
#   ifdef CORRECT_TIMESTAMPS
    long tshift_sec;
    long tshift_usec;
#   endif /* CORRECT_TIMESTAMPS */
#if defined(GLOBUS_IO_ENABLED)
    globus_io_handle_t * handle;
#endif
} NLhandle;

/* NetLogger Routines */
NLhandle *NetLoggerOpen(int method, char *pname, char *filename, char *hostname, int port);
int NetLoggerWrite(NLhandle *lp, char *keyword, char *fmt,...);
int NetLoggerFlush(NLhandle *lp);
int NetLoggerClose(NLhandle *lp);

/* special write calls */

/* user passes in timing info */
int NetLoggerGTWrite(NLhandle *lp, long sec, long usec, char *keyword, 
	char *fmt,...);

/* non-varargs versions of call */
int
NetLoggerGTWriteString(NLhandle * lp, long sec, long usec, char *keyword,
                       char *data);

/* set default level */
int NetLoggerSetLevel(NLhandle *lp, char *level);

/* internal NetLogger routines */
FILE  *LogOpen(char *logfile_name, char *mode);
int   SysLogOpen(char *prog_name, int syslog_facility);
int   NetLogOpen(char *hostname, int port);

int   LogClose(FILE * fp);
int   SysLogClose(void);
int   NetLogClose(int socket);
 
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _LOGGING_H_ */

