#include "globus_common.h"
#include "globus_tilde_expand.h"

#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <errno.h>
#include <sys/types.h>
#include <unistd.h>
#include <pwd.h>
#include <ctype.h>

#define GLOBUS_TILDE_EXPAND_USAGE \
"\nSyntax: globus_tilde_expand  [~ | ~user]\n"

int
main(int argc, char **argv)
{
    char *   inpath;
    char *   outpath;

    if(argc != 2)
    {
	globus_libc_fprintf(stderr,GLOBUS_TILDE_EXPAND_USAGE);
	exit(1);
    }

    inpath=argv[1];
    globus_tilde_expand(
	GLOBUS_TILDE_EXPAND|GLOBUS_TILDE_USER_EXPAND,
	GLOBUS_FALSE, /* the string start with ~[user] if any, not /~[user] */
	inpath,
	&outpath);
    globus_libc_printf("%s",outpath);
    exit(0);
}
