/******************************************************************************
globus_file_time.c

Description:
    File time conversion program
******************************************************************************/

/******************************************************************************
                             Include header files
******************************************************************************/

#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
/*
#include "globus_common.h"
*/
#include <errno.h>

static void		print_usage();

typedef enum		{NO_TIME_STD, ACCESS, STATUS_CHANGE, MODIFY} time_std_t;
typedef enum		{NO_TIME_MODE, GMT_DATE, UTC_DATE, UTC_SEC} time_mode_t;
char 	*std_str[] =	{"None", 
			 "-a|-access-time",
			 "-c|-status-change-time",
			 "-m|-modify-time"};
char 	*mode_str[] =	{"None", 
			 "-g|-gmt-date",
			 "-u|-utc-date",
			 "-U|-utc-seconds"};

char	*filename=NULL;

/******************************************************************************
Function:       print_usage()
Description:
Parameters:
Returns:
******************************************************************************/
static void
print_usage()
{
  fprintf(stderr, "\n");
  fprintf(stderr, "Usage: %s \\\n       %s %s %s \\\n       %s %s %s %s\n",
          "globus-file-time",
          "[{-a|-access-time} |",
          "{-c|-status-change-time} |",
          "{-m|-modify-time}]",
          "[{-g|-gmt-date} |",
          "{-u|-utc-date} |",
          "{-U|-utc-seconds}]",
          "filename"
         );
} /* print_usage() */


int
main(int argc, char *argv[])
{

  time_std_t std = NO_TIME_STD;
  time_mode_t mode = NO_TIME_MODE;

  int i, res = 0;
  int file_time = 0;
  time_t tmp_time;
  struct stat buf;

  for (i=1; i<argc-1; i++) {
    if ( (strcmp(argv[i], "-a") == 0) ||
         (strcmp(argv[i], "-access-time") == 0) ) 
    {
      if (std == NO_TIME_STD) {
        std = ACCESS;
      }
      else if (std != ACCESS) {
        fprintf(stderr, "Conflicting arguments: {%s} & {%s}\n",
                        std_str[std], std_str[ACCESS]
               );
        print_usage();
        exit(1);
      }
    }
    else if ( (strcmp(argv[i], "-c") == 0) ||
              (strcmp(argv[i], "-status-change-time") == 0) ) 
    { 
      if (std == NO_TIME_STD) {
        std = STATUS_CHANGE;
      }
      else if (std != STATUS_CHANGE) {
        fprintf(stderr, "Conflicting arguments: {%s} & {%s}\n",
                        std_str[std], std_str[STATUS_CHANGE]
               );
        print_usage();
        exit(1);
      }
    }
    else if ( (strcmp(argv[i], "-m") == 0) ||
              (strcmp(argv[i], "-modify-time") == 0) ) 
    { 
      if (std == NO_TIME_STD) {
        std = MODIFY;
      }
      else if (std != MODIFY) {
        fprintf(stderr, "Conflicting arguments: {%s} & {%s}\n",
                        std_str[std], std_str[MODIFY]
               );
        print_usage();
        exit(1);
      }
    }
    else if ( (strcmp(argv[i], "-g") == 0) ||
              (strcmp(argv[i], "-gmt-date") == 0) ) 
    { 
      if (mode == NO_TIME_MODE) {
        mode = GMT_DATE;
      }
      else if (std != GMT_DATE) {
        fprintf(stderr, "Conflicting arguments: {%s} & {%s}\n",
                        mode_str[std], mode_str[GMT_DATE]
               );
        print_usage();
        exit(1);
      }
    }
    else if ( (strcmp(argv[i], "-u") == 0) ||
              (strcmp(argv[i], "-utc-date") == 0) ) 
    { 
      if (mode == NO_TIME_MODE) {
        mode = UTC_DATE;
      }
      else if (std != UTC_DATE) {
        fprintf(stderr, "Conflicting arguments: {%s} & {%s}\n",
                        mode_str[std], mode_str[UTC_DATE]
               );
        print_usage();
        exit(1);
      }
    }
    else if ( (strcmp(argv[i], "-U") == 0) ||
              (strcmp(argv[i], "-utc-seconds") == 0) ) 
    { 
      if (mode == NO_TIME_MODE) {
        mode = UTC_SEC;
      }
      else if (std != UTC_SEC) {
        fprintf(stderr, "Conflicting arguments: {%s} & {%s}\n",
                        mode_str[std], mode_str[UTC_SEC]
               );
        print_usage();
        exit(1);
      }
    }
    else
    {
      fprintf(stderr, "Unknown argument %s\n", argv[i]);
      print_usage();
      exit(1);
    }
  }

  if (std == NO_TIME_STD)
    std = MODIFY;
  if (mode == NO_TIME_MODE)
    mode = UTC_DATE;

  filename = argv[argc-1];

  /*
  * get the last modified time of the file in seconds
  */
  res = stat (filename, &buf);
  if (res == -1) {
    fprintf(stderr, "Wrong file name: %s\n", filename);
    print_usage();
    exit (1);
  }

  switch (std) {
    case ACCESS:
      file_time = (int) buf.st_atime;
      break;
    case MODIFY:
      file_time = (int) buf.st_mtime;
      break;
    case STATUS_CHANGE:
      file_time = (int) buf.st_ctime;
      break;
    default:
      file_time = (int) buf.st_mtime;
      break;
  }

  /*
  * currently, this is not supported
  */
  switch (mode) {
    case GMT_DATE:
      break;
    case UTC_DATE:
      break;
    case UTC_SEC:
      break;
    default:
      break;
  }
  
  printf("%d\n", file_time);
  exit (0);
}
