/******************************************************************************
globus_date2utc.c
 
Description:
 
CVS Information:
 
    $Source: /home/globdev/CVS/globus-current/Globus/Miscellaneous/globus_date_conversion/globus_date2utc.c,v $
    $Date: 1999/08/10 21:23:01 $
    $Revision: 1.10 $
    $Author: blau $
******************************************************************************/
#include <time.h>
#include <string.h>
#include "globus_common.h"

/* We need this program specifically to compare date that are stored
   in the MDS; That is why we chose to convert from this format...*/
#define format_str "%a %b %d %T GMT %Y"

long
get_time_conv_diff()
{
    struct timeval time;
    time_t       curr_time;
    time_t       curr_time_conv;
    long         time_conv_diff;
    struct tm    tm;
    struct tm*   tm_ptr               = GLOBUS_NULL;
    int          rc;
 
    bzero((char*) &tm, sizeof(tm));
 
    rc = gettimeofday( &time, NULL);
 
    curr_time = (time_t) time.tv_sec;
#ifdef HAVE_GMTIME_R
    gmtime_r(&curr_time,
             &tm);
    tm_ptr = &tm;
#else
    tm_ptr = gmtime(&curr_time);
#endif
 
 
#ifdef HAVE_MKTIME
    curr_time_conv = mktime(tm_ptr);
#else
    curr_time_conv = timegm(tm_ptr);
    if( curr_time_conv > 0 )
    {
        curr_time_conv += tm.tm_gmtoff;
    }
#endif
 
 
    time_conv_diff = (long) curr_time_conv - (long) curr_time;
 
 
    return time_conv_diff;
}


int 
main(int argc, char *argv[])
{
    struct tm    tmresult;
    time_t       time_in_UTC;
    char *       p;

    
    if (argc != 2)
    {
	printf("Usage: globus_date2utc \"date in double quotes\"\n");
	printf("Print-out a calendar time (the number of seconds since 00:00:00 UTC,\n" \
	       "or January 1, 1970) of the date supplied as parameter.");
	printf("  E.g.:\n");
	printf("       globus_date2utc \"Thu Dec  3 21:05:39 GMT 1998\"");
	printf("       912740739\n");
	exit(1);
    }

    if (!strcmp(argv[1],"-now"))
    {
	printf("%ld\n", (long) time(GLOBUS_NULL));
	return 0;
    }



    p = globus_strptime(argv[1],format_str,&tmresult);

    if (!p)
    {
	printf("format error : assuming \"+%s\" \n", format_str);
	return 1;
    }


#ifdef HAVE_MKTIME
   time_in_UTC=mktime(&tmresult) - get_time_conv_diff();
#else
   time_in_UTC=timegm(&tmresult);
   if ( time_in_UTC > 0 )
   {
       time_in_UTC += tmresult.tm_gmtoff;
   }
   time_in_UTC -= get_time_conv_diff();
#endif       
       
    printf("%ld\n",time_in_UTC);
    
    

    return 0;
}



