/*
 * nexus_dc_crayt3e.c
 */

static char *rcsid = "$Header: /home/globdev/CVS/globus-current/Globus/Miscellaneous/data_conversion/library/globus_dc_crayt3e.c,v 1.6 2000/04/17 08:30:36 toonen Exp $";

#include "globus_dc.h"

#define FLT_EXP_DIF	16258			/* 16385 - 127 ??       */
#define DBL_EXP_DIF	15362			/* 16385 - 1023 ??      */

/* only used on double */
#define CRAY_SIGN	0x8000000000000000UL	/*  1 bit sign          */
#define CRAY_EXP	0x7fff000000000000UL	/* 15 bits exponent     */
#define CRAY_MAN_MSB	0x0000800000000000UL	/*  1 bit normalize     */
#define CRAY_MAN_LSB	0x00007fffffffffffUL	/* 47 bits mantissa     */
#define CRAY_MAN_ALL	0x0000ffffffffffffUL	/* 48 bits mantissa     */
#define FLT_RND_BIT	0x0000000000800000UL	/* round cray -> float  */
#define DBL_RND_BIT	0x0000000000000008UL	/* round double -> cray */

typedef union
{
    unsigned long	l;    /* 1 64 bit long   */
    nexus_byte_t	b[8]; /* 8 bytes         */
    unsigned short	s[2]; /* 2 32 bit shorts */
    float		f[2]; /* 2 floats        */
    double		d;    /* 1 double        */
    unsigned long long  ll;   /* 1 long long     */
} cray_buf_t;

/*
 * nexus_dc_is_native_char()
 */
int nexus_dc_is_native_char(int format)
{
    if (format == NEXUS_DC_FORMAT_JAVA)
	return(NEXUS_FALSE); /* 16 bit signed BE */
    else
	return(NEXUS_TRUE); /* 8 bit signed */
}
/* nexus_dc_is_native_char() */


/*
 * nexus_dc_get_char()
 */
void nexus_dc_get_char(nexus_byte_t **buffer,
		       char *data,
		       unsigned long count,
		       int format)
{
    if (format == NEXUS_DC_FORMAT_JAVA) /* 16 bit signed BE */
    {
	nexus_byte_t	*dst = (nexus_byte_t *)data;
	nexus_byte_t	*src = (nexus_byte_t *)*buffer;
	int		i;

	for (i = 0; i < count; i++)
	{
	    dst[i] = src[(i * 2) + 1];
	}
	*buffer += count * 2;
    }
    else /* 8 bit signed */
    {
        memcpy(data, *buffer, count);
        *buffer += count;
    }
}
/* nexus_dc_get_char() */


/*
 * nexus_dc_check_lost_precision_char()
 */
int nexus_dc_check_lost_precision_char(nexus_byte_t *buffer,
				       unsigned long count,
				       int format)
{
    if (format == NEXUS_DC_FORMAT_JAVA)
    {
	int	i;

	for (i = 0; i < count; i++)
	{
	    if (buffer[(i * 2)] | (buffer[(i * 2) + 1] & 0xf0))
		return (i);
	}
    }

    return(-1);
}
/* nexus_dc_check_lost_precision_char() */


/*
 * nexus_dc_is_native_u_char()
 */
int nexus_dc_is_native_u_char(int format)
{
    if (format == NEXUS_DC_FORMAT_JAVA)
	return(NEXUS_FALSE);
    else
	return(NEXUS_TRUE);
}
/* nexus_dc_is_native_u_char() */


/*
 * nexus_dc_get_u_char()
 */
void nexus_dc_get_u_char(nexus_byte_t **buffer,
			 unsigned char *data,
			 unsigned long count,
			 int format)
{
    if (format == NEXUS_DC_FORMAT_JAVA) /* 16 bit signed BE */
    {
        nexus_byte_t *dst = (nexus_byte_t *) data;
	nexus_byte_t *src = (nexus_byte_t *) *buffer;
	int i;

	for (i = 0; i < count; i++)
	{
	    dst[i] = src[(i * 2) + 1];
	}
	*buffer += count * 2;
    }
    else /* 8 bit unsigned (native) */
    {
	memcpy(data, *buffer, count);
        *buffer += count;
    }
}
/* nexus_dc_get_u_char() */


/*
 * nexus_dc_check_lost_precision_u_char()
 */
int nexus_dc_check_lost_precision_u_char(nexus_byte_t *buffer,
					 unsigned long count,
					 int format)
{
    if (format == NEXUS_DC_FORMAT_JAVA) /* 16 bit signed BE */
    {
	int i;

	for (i = 0; i < count; i++)
	{
	    if (buffer[(i * 2)] | (buffer[(i * 2) + 1] & 0xf0))
		return (i);
	}
    }
    return(-1);
}
/* nexus_dc_check_lost_precision_u_char() */


/*
 * nexus_dc_is_native_short()
 */
int nexus_dc_is_native_short(int format)
{
    if (format == NEXUS_DC_FORMAT_CRAYT3E)
	return(NEXUS_TRUE); /* 32 bit signed BE */
    else
	return(NEXUS_FALSE);
}
/* nexus_dc_is_native_short() */


/*
 * nexus_dc_get_short()
 */
void nexus_dc_get_short(nexus_byte_t **buffer,
			short *data,
			unsigned long count,
			int format)
{
    nexus_byte_t *dst = (nexus_byte_t *) data;
    nexus_byte_t *src = (nexus_byte_t *) *buffer;
    int		 i;

    switch(format)
    {
    case NEXUS_DC_FORMAT_64BIT_LE: /* 16 bit signed LE */
    case NEXUS_DC_FORMAT_32BIT_LE:
	for (i = 0; i < count; i++)
	{
	    /* byte swap and sign extend */
	    dst[3] = src[0];
	    if ( (dst[2] = src[1]) & 0xf0 )
	    {
		dst[0] = 0xff;
		dst[1] = 0xff;
	    }
	    else
	    {
		dst[0] = 0x00;
		dst[1] = 0x00;
	    }
	    src += 2;
	    dst += 4;
	}
	*buffer += count * 2;
	break;
    case NEXUS_DC_FORMAT_JAVA:     /* 16 bit signed BE */
    case NEXUS_DC_FORMAT_32BIT_BE:
    case NEXUS_DC_FORMAT_64BIT_BE:
	for (i = 0; i < count; i++)
	{
	    /* sign extend */
	    dst[3] = src[1];
	    if ( (dst[2] = src[0]) & 0xf0 )
	    {
		dst[0] = 0xff;
		dst[1] = 0xff;
	    }
	    else
	    {
		dst[0] = 0x00;
		dst[1] = 0x00;
	    }
	    src += 2;
	    dst += 4;
	}
	*buffer += count * 2;
	break;
    case NEXUS_DC_FORMAT_CRAYC90: /* 64 bit signed BE */
	for (i = 0; i < count; i++)
	{
	    dst[0] = src[4];
	    dst[1] = src[5];
	    dst[2] = src[6];
	    dst[3] = src[7];
	    src += 8;
	    dst += 4;
	}
	*buffer += count * 8;
	break;
    case NEXUS_DC_FORMAT_CRAYT3E: /* 32 bit signed BE */
	memcpy(data, *buffer, count * 4);
	*buffer += count * 4;
	break;
    case NEXUS_DC_FORMAT_UNKNOWN:
	/* DUNNO!!! */
	break;
    }
} /* nexus_dc_get_short() */


/*
 * nexus_dc_check_lost_precision_short()
 */
int nexus_dc_check_lost_precision_short(nexus_byte_t *buffer,
					unsigned long count,
					int format)
{
    int i;
    
    switch(format)
    {
    case NEXUS_DC_FORMAT_JAVA: /* 16 bit signed */
    case NEXUS_DC_FORMAT_32BIT_BE:
    case NEXUS_DC_FORMAT_64BIT_BE:
    case NEXUS_DC_FORMAT_32BIT_LE:
    case NEXUS_DC_FORMAT_64BIT_LE:
    case NEXUS_DC_FORMAT_CRAYT3E: /* 32 bit signed (native) */
	return (-1);
    case NEXUS_DC_FORMAT_CRAYC90: /* 64 bit signed BE */
	for (i = 0; i < count; i++)
	{
	    if ( buffer[0] & 0xf0 )
	    { /* < 0 */
		if (~buffer[0] | ~buffer[1] |
		    ~buffer[2] | ~buffer[3] |
		    ~(buffer[4] | 0x7f) )
		    return (i);
	    }
	    else
	    { /* >= 0 */
		if (buffer[0] | buffer[1] |
		    buffer[2] | buffer[3] |
		    (buffer[4] & 0xf0))
		    return (i);
	    }
	    buffer += 4;
	}
	return (-1);
    case NEXUS_DC_FORMAT_UNKNOWN:
	  return (0);
    }

    return (-1);
} /* nexus_dc_check_lost_precision_short() */


/*
 * nexus_dc_is_native_u_short()
 */
int nexus_dc_is_native_u_short(int format)
{
    if (format == NEXUS_DC_FORMAT_CRAYT3E)
	return(NEXUS_TRUE);
    else
	return(NEXUS_FALSE);
} /* nexus_dc_is_native_u_short() */


/*
 * nexus_dc_get_u_short()
 */
void nexus_dc_get_u_short(nexus_byte_t **buffer,
			  unsigned short *data,
			  unsigned long count,
			  int format)
{
    nexus_byte_t *dst = (nexus_byte_t *) data;
    nexus_byte_t *src = (nexus_byte_t *) *buffer;
    int i;

    switch(format)
    {
    case NEXUS_DC_FORMAT_64BIT_LE:
    case NEXUS_DC_FORMAT_32BIT_LE:
	for (i = 0; i < count; i++)
	{
	    /* byte swap */
	    dst[3] = src[0];
	    dst[2] = src[1];
	    dst[1] = 0x00;
	    src[0] = 0x00;
	    src += 2;
	    dst += 4;
	}
	*buffer += count * 2;
	break;
    case NEXUS_DC_FORMAT_JAVA:
    case NEXUS_DC_FORMAT_32BIT_BE:
    case NEXUS_DC_FORMAT_64BIT_BE:
	for (i = 0; i < count; i++)
	{
	    dst[2] = src[0];
	    dst[3] = src[1];
	    dst[0] = 0x00;
	    dst[1] = 0x00;
	    src += 2;
	    dst += 4;
	}
	*buffer += count * 2;
	break;
    case NEXUS_DC_FORMAT_CRAYC90:
	for (i = 0; i < count; i++)
	{
	    dst[0] = dst[4];
	    dst[1] = src[5];
	    dst[2] = src[6];
	    dst[3] = src[7];
	    src += 8;
	    dst += 4;
	}
	*buffer += count * 8;
	break;
    case NEXUS_DC_FORMAT_CRAYT3E:
	memcpy(data, *buffer, count * 4);
	*buffer += count * 4;
    case NEXUS_DC_FORMAT_UNKNOWN:
	/* DUNNO!!! */
	break;
    }
} /* nexus_dc_get_u_short() */


/*
 * nexus_dc_check_lost_precision_u_short()
 */
int nexus_dc_check_lost_precision_u_short(nexus_byte_t *buffer,
					  unsigned long count,
					  int format)
{
    int i;
    
    switch(format) 
    {
    case NEXUS_DC_FORMAT_32BIT_BE: /* unsigned 16 */
    case NEXUS_DC_FORMAT_64BIT_BE:
    case NEXUS_DC_FORMAT_32BIT_LE:
    case NEXUS_DC_FORMAT_64BIT_LE:
    case NEXUS_DC_FORMAT_CRAYT3E: /* native */
	break;
    case NEXUS_DC_FORMAT_JAVA: /* signed 16 */
	for (i = 0; i < count; i++)
	{
	    if (buffer[0] & 0xf0)
		return (i);
	    buffer += 2;
	}
	return (-1);
    case NEXUS_DC_FORMAT_CRAYC90: /* unsigned? 64 */
	for (i = 0; i < count; i++)
	{
	    if (buffer[0] | buffer[1] |
		buffer[2] | buffer[3])
		return (i);
	    buffer += 8;
	}
	return (-1);
    case NEXUS_DC_FORMAT_UNKNOWN:
	return (0);
    }
    
    return (-1);
}
/* nexus_dc_check_lost_precision_u_short() */


/*
 * nexus_dc_is_native_int()
 */
int nexus_dc_is_native_int(int format)
{
    if ((format == NEXUS_DC_FORMAT_CRAYT3E)
	|| (format == NEXUS_DC_FORMAT_CRAYC90))
	return(NEXUS_TRUE);
    else
	return(NEXUS_FALSE);
}
/* nexus_dc_is_native_int() */


/*
 * nexus_dc_get_int()
 */
void nexus_dc_get_int(nexus_byte_t **buffer,
		      int *data,
		      unsigned long count,
		      int format)
{
    nexus_byte_t *dst = (nexus_byte_t *) data;
    nexus_byte_t *src = (nexus_byte_t *) *buffer;
    int i;

    switch(format)
    {
    case NEXUS_DC_FORMAT_64BIT_LE:
    case NEXUS_DC_FORMAT_32BIT_LE:
	for (i = 0; i < count; i++)
	{
	    /* byte swap and sign extend */
	    dst[7] = src[0];
	    dst[6] = src[1];
	    dst[5] = src[2];
	    if ( (dst[4] = src[3]) & 0xf0 )
	    {
		dst[3] = 0xff;
		dst[2] = 0xff;
		dst[1] = 0xff;
		dst[0] = 0xff;
	    }
	    else
	    {
		dst[3] = 0x00;
		dst[2] = 0x00;
		dst[1] = 0x00;
		dst[0] = 0x00;
	    }
	    src += 4;
	    dst += 8;
	}
	*buffer += count * 4;
	break;
    case NEXUS_DC_FORMAT_JAVA:     /* 32 bit BE */
    case NEXUS_DC_FORMAT_32BIT_BE:
    case NEXUS_DC_FORMAT_64BIT_BE:
	for (i = 0; i < count; i++)
	{
	    dst[7] = src[3];
	    dst[6] = src[2];
	    dst[5] = src[1];
	    if ( (dst[4] = src[0]) & 0xf0 )
	    {
		dst[3] = 0xff;
		dst[2] = 0xff;
		dst[1] = 0xff;
		dst[0] = 0xff;
	    }
	    else
	    {
		dst[3] = 0x00;
		dst[2] = 0x00;
		dst[1] = 0x00;
		dst[0] = 0x00;
	    }
	    src += 4;
	    dst += 8;
	}
        *buffer += count * 4;
	break;
    case NEXUS_DC_FORMAT_CRAYC90: /* 64 bit BE */
    case NEXUS_DC_FORMAT_CRAYT3E:
	memcpy(data, *buffer, count * 8);
	*buffer += count * 8;
	break;
    case NEXUS_DC_FORMAT_UNKNOWN:
	/* DUNNO!!! */
	break;
    }
}
/* nexus_dc_get_int() */


/*
 * nexus_dc_check_lost_precision_int()
 */
int nexus_dc_check_lost_precision_int(nexus_byte_t *buffer,
				      unsigned long count,
				      int format)
{
    if (format == NEXUS_DC_FORMAT_UNKNOWN)
	return(0);
    else
	return(-1);
}
/* nexus_dc_check_lost_precision_int() */

/*
 * nexus_dc_is_native_u_int()
 */
int nexus_dc_is_native_u_int(int format)
{
    if ((format == NEXUS_DC_FORMAT_CRAYT3E)
	|| (format == NEXUS_DC_FORMAT_CRAYC90))
	return(NEXUS_TRUE);
    else
	return(NEXUS_FALSE);
}
/* nexus_dc_is_native_u_int() */


/*
 * nexus_dc_get_u_int()
 */
void nexus_dc_get_u_int(nexus_byte_t **buffer,
			unsigned int *data,
			unsigned long count,
			int format)
{
    nexus_byte_t *src = (nexus_byte_t *) *buffer;
    nexus_byte_t *dst = (nexus_byte_t *) data;
    int i;

    switch(format)
    {
    case NEXUS_DC_FORMAT_64BIT_LE:
    case NEXUS_DC_FORMAT_32BIT_LE:
	for (i = 0; i < count; i++)
	{
	    /* byte swap */
	    dst[7] = src[0];
	    dst[6] = src[1];
	    dst[5] = src[2];
	    dst[4] = src[3];
	    dst[3] = 0x00;
	    dst[2] = 0x00;
	    dst[1] = 0x00;
	    dst[0] = 0x00;
	    src += 4;
	    dst += 8;
	}
	*buffer += count * 4;
	break;
    case NEXUS_DC_FORMAT_JAVA:     /* 32 bit BE */
    case NEXUS_DC_FORMAT_32BIT_BE:
    case NEXUS_DC_FORMAT_64BIT_BE:
	for (i = 0; i < count; i++)
	{
	    dst[4] = src[0];
	    dst[5] = src[1];
	    dst[6] = src[2];
	    dst[7] = src[3];
	    dst[3] = 0x00;
	    dst[2] = 0x00;
	    dst[1] = 0x00;
	    dst[0] = 0x00;
	    src += 4;
	    dst += 8;
	}
        *buffer += count * 4;
	break;
    case NEXUS_DC_FORMAT_CRAYC90: /* 64 bit BE */
    case NEXUS_DC_FORMAT_CRAYT3E:
	memcpy(data, *buffer, count * 8);
	*buffer += count * 8;
	break;
    case NEXUS_DC_FORMAT_UNKNOWN:
	/* DUNNO!!! */
	break;
    }
}
/* nexus_dc_get_u_int() */


/*
 * nexus_dc_check_lost_precision_u_int()
 */
int nexus_dc_check_lost_precision_u_int(nexus_byte_t *buffer,
					unsigned long count,
					int format)
{
    int i;
    
    switch (format)
    {
    case NEXUS_DC_FORMAT_JAVA: /* 32 bit signed BE */
	for (i = 0; i < count; i++)
	{
	    if (buffer[(i * 4) + 0] & 0xf0)
		return (i);
	}
    case NEXUS_DC_FORMAT_UNKNOWN:
	return (0);
    default:
	return (-1);
    }
}
/* nexus_dc_check_lost_precision_u_int() */


/*
 * nexus_dc_is_native_long()
 */
int nexus_dc_is_native_long(int format)
{
    if ((format == NEXUS_DC_FORMAT_64BIT_BE)
	|| (format == NEXUS_DC_FORMAT_JAVA)
	|| (format == NEXUS_DC_FORMAT_CRAYC90)
	|| (format == NEXUS_DC_FORMAT_CRAYT3E))
	return(NEXUS_TRUE);
    else
	return(NEXUS_FALSE);
}
/* nexus_dc_is_native_long() */


/*
 * nexus_dc_get_long()
 */
void nexus_dc_get_long(nexus_byte_t **buffer,
		       long *data,
		       unsigned long count,
		       int format)
{
    nexus_byte_t *dst = (nexus_byte_t *) data;
    nexus_byte_t *src = (nexus_byte_t *) *buffer;
    int i;

    switch(format)
    {
    case NEXUS_DC_FORMAT_32BIT_LE:
	/* byte swap and sign extend */
	for (i = 0; i < count; i++)
	{
	    dst[7] = src[0];
	    dst[6] = src[1];
	    dst[5] = src[2];
	    if ( (dst[4] = src[3]) & 0xf0 )
	    {
		dst[3] = 0xff;
		dst[2] = 0xff;
		dst[1] = 0xff;
		dst[0] = 0xff;
	    }
	    else
	    {
		dst[3] = 0x00;
		dst[2] = 0x00;
		dst[1] = 0x00;
		dst[0] = 0x00;
	    }
	    src += 4;
	    dst += 8;
	}
	*buffer += count * 4;
	break;
    case NEXUS_DC_FORMAT_32BIT_BE:
	/* sign extend */
	for (i = 0; i < count; i++)
	{
	    dst[7] = src[3];
	    dst[6] = src[2];
	    dst[5] = src[1];
	    if ( (dst[4] = src[0]) & 0xf0 )
	    {
		dst[3] = 0xff;
		dst[2] = 0xff;
		dst[1] = 0xff;
		dst[0] = 0xff;
	    }
	    else
	    {
		dst[3] = 0x00;
		dst[2] = 0x00;
		dst[1] = 0x00;
		dst[0] = 0x00;
	    }
	    src += 4;
	    dst += 8;
	}
	*buffer += count * 4;
	break;
    case NEXUS_DC_FORMAT_64BIT_LE:
	/* byte swap */
	for (i = 0; i < count; i++)
	{
	    dst[0] = src[7];
	    dst[1] = src[6];
	    dst[2] = src[5];
	    dst[3] = src[4];
	    dst[4] = src[3];
	    dst[5] = src[2];
	    dst[6] = src[1];
	    dst[7] = src[0];
	    src += 8;
	    dst += 8;
	}
	*buffer += count * 8;
	break;
    case NEXUS_DC_FORMAT_64BIT_BE:
    case NEXUS_DC_FORMAT_JAVA:
    case NEXUS_DC_FORMAT_CRAYC90:
    case NEXUS_DC_FORMAT_CRAYT3E:
	memcpy(data, *buffer, count * 8);
        *buffer += count * 8;
	break;
    case NEXUS_DC_FORMAT_UNKNOWN:
	/* DUNNO!!! */
	break;
    }
} /* nexus_dc_get_long() */


/*
 * nexus_dc_check_lost_precision_long()
 */
int nexus_dc_check_lost_precision_long(nexus_byte_t *buffer,
				       unsigned long count,
				       int format)
{
    return(-1);
} /* nexus_dc_check_lost_precision_long() */


/*
 * nexus_dc_is_native_u_long()
 */
int nexus_dc_is_native_u_long(int format)
{
    if ((format == NEXUS_DC_FORMAT_64BIT_BE)
	|| (format == NEXUS_DC_FORMAT_CRAYC90)
	|| (format == NEXUS_DC_FORMAT_CRAYT3E))
	return(NEXUS_TRUE);
    else
	return(NEXUS_FALSE);
}
/* nexus_dc_is_native_u_long() */


/*
 * nexus_dc_get_u_long()
 */
void nexus_dc_get_u_long(nexus_byte_t **buffer,
			 unsigned long *data,
			 unsigned long count,
			 int format)
{
    nexus_byte_t *dst = (nexus_byte_t *) data;
    nexus_byte_t *src = (nexus_byte_t *) *buffer;
    int i;

    switch(format)
    {
    case NEXUS_DC_FORMAT_32BIT_LE:
	/* byte swap */
	for (i = 0; i < count; i++)
	{
	    dst[7] = src[0];
	    dst[6] = src[1];
	    dst[5] = src[2];
	    dst[4] = src[3];
	    dst[3] = 0x00;
	    dst[2] = 0x00;
	    dst[1] = 0x00;
	    dst[0] = 0x00;
	    src += 4;
	    dst += 8;
	}
	*buffer += count * 4;
	break;
    case NEXUS_DC_FORMAT_32BIT_BE:
	for (i = 0; i < count; i++)
	{
	    dst[7] = src[3];
	    dst[6] = src[2];
	    dst[5] = src[1];
	    dst[4] = src[0];
	    dst[3] = 0x00;
	    dst[2] = 0x00;
	    dst[1] = 0x00;
	    dst[0] = 0x00;
	    src += 4;
	    dst += 8;
	}
	*buffer += count * 4;
	break;
    case NEXUS_DC_FORMAT_64BIT_LE:
	/* byte swap */
	for (i = 0; i < count; i++)
	{
	    dst[0] = src[7];
	    dst[1] = src[6];
	    dst[2] = src[5];
	    dst[3] = src[4];
	    dst[4] = src[3];
	    dst[5] = src[2];
	    dst[6] = src[1];
	    dst[7] = src[0];
	    src += 8;
	    dst += 8;
	}
	*buffer += count * 8;
	break;
    case NEXUS_DC_FORMAT_64BIT_BE:
    case NEXUS_DC_FORMAT_JAVA:
    case NEXUS_DC_FORMAT_CRAYC90:
    case NEXUS_DC_FORMAT_CRAYT3E:
	memcpy(data, *buffer, count * 8);
        *buffer += count * 8;
	break;
    case NEXUS_DC_FORMAT_UNKNOWN:
	/* DUNNO!!! */
	break;
    }
}
/* nexus_dc_get_u_long() */


/*
 * nexus_dc_check_lost_precision_u_long()
 */
int nexus_dc_check_lost_precision_u_long(nexus_byte_t *buffer,
					 unsigned long count,
					 int format)
{
    if (format == NEXUS_DC_FORMAT_JAVA)
    {
	int i;

	for (i = 0; i < count; i++)
	{
	    if (buffer[(i * 8) + 0] & 0x80)
		return(i);
	}
    }
    return(-1);
}
/* nexus_dc_check_lost_precision_u_long() */


/*
 * nexus_dc_is_native_float()
 */
int nexus_dc_is_native_float(int format)
{
    if ((format == NEXUS_DC_FORMAT_64BIT_BE)
	|| (format == NEXUS_DC_FORMAT_32BIT_BE)
	|| (format == NEXUS_DC_FORMAT_CRAYT3E))
	return(NEXUS_TRUE);
    else
	return(NEXUS_FALSE);
} /* nexus_dc_is_native_float() */


/*
 * nexus_dc_get_float()
 */
void nexus_dc_get_float(nexus_byte_t **buffer,
			float *data,
			unsigned long count,
			int format)
{
    nexus_byte_t *src = (nexus_byte_t *) *buffer;
    nexus_byte_t *dst = (nexus_byte_t *) data;
    int i;

    switch(format)
    {
    case NEXUS_DC_FORMAT_64BIT_LE:
    case NEXUS_DC_FORMAT_32BIT_LE:
	/* byte swap */
	for (i = 0; i < count; i++)
	{
	    dst[3] = src[0];
	    dst[2] = src[1];
	    dst[1] = src[2];
	    dst[0] = src[3];
	    src += 4;
	    dst += 4;
	}
	*buffer += count * 4;
	break;
    case NEXUS_DC_FORMAT_32BIT_BE:
    case NEXUS_DC_FORMAT_64BIT_BE:
    case NEXUS_DC_FORMAT_JAVA:
    case NEXUS_DC_FORMAT_CRAYT3E:
	memcpy(data, *buffer, count * 4);
        *buffer += count * 4;
	break;
    case NEXUS_DC_FORMAT_CRAYC90:
    {
	cray_buf_t	c;
	short		s, e, m; /* 32 bit on T3E */
	int		i, j;

	for (i = 0; i < count; i++)
	{
	    /* get next cray float */
	    for (j = 0; j < 6; j++) /* never look at 2 least significant bytes */
		c.b[j] = src[j];

	    /* separate fields */
	    e = ((c.s[0] & 0x7fff0000) >> 16) - FLT_EXP_DIF; /* adjust exponent bias */
	    m = ((c.s[1] & 0xff000000) >> 24) | /* lo  8 mantissa */
		((c.s[0] & 0x00007fff) <<  8) | /* hi 15 mantissa */
		((c.s[1] & 0x00800000) >> 23);  /* round bit      */
	    s = (c.s[0] & 0xf0000000); /* sign bit */
	    
	    if (e > 0) /* e is biased exponent */
	    {
		/* float is normal -- most common case */
		/* assume no overflow -- could keep sign and round to infinity? */
		c.s[0] = s | (e << 23) | m;
	    }
	    else
	    {
		/* really small float */
		if (e < -22)
		{
		    /* underflow to 0 */
		    c.s[0] = s; /* preserve sign? */
		}
		else
		{
		    /* denormalize mantissa */
		    m = (m | 0x00800000) >> (1 - e); /* explicit 1, shift */
		    c.s[0] = s | m;
		}
	    }

	    /* put IEEE float */
	    for (j = 0; j < 4; j++)
		dst[j] = c.b[j];
	    
	    src += 8;
	    dst += 4;
	}
	*buffer += count * 8;
	break;
    }
    case NEXUS_DC_FORMAT_UNKNOWN:
	/* DUNNO!!! */
	break;
    }
}
/* nexus_dc_get_float() */


/*
 * nexus_dc_check_lost_precision_float()
 */
int nexus_dc_check_lost_precision_float(nexus_byte_t *buffer,
					unsigned long count,
					int format)
{
    int result = -1;
    switch(format)
    {
    case NEXUS_DC_FORMAT_32BIT_BE:
    case NEXUS_DC_FORMAT_64BIT_BE:
    case NEXUS_DC_FORMAT_32BIT_LE:
    case NEXUS_DC_FORMAT_64BIT_LE:
    case NEXUS_DC_FORMAT_JAVA:
    case NEXUS_DC_FORMAT_CRAYT3E:  
	break;
    case NEXUS_DC_FORMAT_CRAYC90:
    {
	break;
    }
    case NEXUS_DC_FORMAT_UNKNOWN:
	result = 0;
	break;
    }
    return(result);
}
/* nexus_dc_check_lost_precision_float() */


/*
 * nexus_dc_is_native_double()
 */
int nexus_dc_is_native_double(int format)
{
    if ((format == NEXUS_DC_FORMAT_CRAYT3E)
	|| (format == NEXUS_DC_FORMAT_32BIT_BE)
	|| (format == NEXUS_DC_FORMAT_JAVA)
	|| (format == NEXUS_DC_FORMAT_64BIT_BE))
	return(NEXUS_TRUE);
    else
	return(NEXUS_FALSE);
}
/* nexus_dc_is_native_double() */


/*
 * nexus_dc_get_double()
 */
void nexus_dc_get_double(nexus_byte_t **buffer,
			 double *data,
			 unsigned long count,
			 int format)
{
    nexus_byte_t *src = (nexus_byte_t *) *buffer;
    nexus_byte_t *dst = (nexus_byte_t *) data;
    int i;

    switch(format)
    {
    case NEXUS_DC_FORMAT_64BIT_LE:
    case NEXUS_DC_FORMAT_32BIT_LE:
	/* byte swap */
	for (i = 0; i < count; i++)
	{
	    dst[0] = src[7];
	    dst[1] = src[6];
	    dst[2] = src[5];
	    dst[3] = src[4];
	    dst[4] = src[3];
	    dst[5] = src[2];
	    dst[6] = src[1];
	    dst[7] = src[0];
	    src += 8;
	    dst += 8;
	}
	*buffer += count * 8;
	break;
    case NEXUS_DC_FORMAT_JAVA:
    case NEXUS_DC_FORMAT_32BIT_BE:
    case NEXUS_DC_FORMAT_64BIT_BE:
    case NEXUS_DC_FORMAT_CRAYT3E:
	memcpy(data, *buffer, count * 8);
        *buffer += count * 8;
	break;
    case NEXUS_DC_FORMAT_CRAYC90:
    {
	cray_buf_t	c;
	long		s, e, m; /* 64 bit on T3E */
	int		i, j;

	for (i = 0; i < count; i++)
	{
	    /* get next cray float */
	    for (j = 0; j < 8; j++)
		c.b[j] = src[j];

	    e = ((c.l & CRAY_EXP) >> 48) - DBL_EXP_DIF;
	    m = (c.l & CRAY_MAN_LSB) << 5; /* 47 bits from cray, need 52 */
	    s = c.l & CRAY_SIGN;

	    if (e > 0)
	    {
		/* normal, assume no overflow */
		c.l = s | (e << 52) | m;
	    }
	    else
	    {
		if (e < -52)
		{
		    /* underflow to 0 */
		    c.l = s; /* keep sign? */
		}
		else
		{
		    /* denormalize */
		    m = (m | 0x0008000000000000UL) >> (1 - e);
		    c.l = s | m;
		    
		}
	    }


	    /* put IEEE float */
	    for (j = 0; j < 8; j++)
		dst[j] = c.b[j];
	    
	    src += 8;
	    dst += 8;
	break;
	}
	*buffer += count * 8;
    }
    case NEXUS_DC_FORMAT_UNKNOWN:
	/* DUNNO!!! */
	break;
    }
}
/* nexus_dc_get_double() */


/*
 * nexus_dc_check_lost_precision_double()
 */
int nexus_dc_check_lost_precision_double(nexus_byte_t *buffer,
					 unsigned long count,
					 int format)
{
    int result = -1;
    switch(format)
    {
    case NEXUS_DC_FORMAT_32BIT_BE:
    case NEXUS_DC_FORMAT_64BIT_BE:
    case NEXUS_DC_FORMAT_32BIT_LE:
    case NEXUS_DC_FORMAT_64BIT_LE:
    case NEXUS_DC_FORMAT_JAVA:
    case NEXUS_DC_FORMAT_CRAYT3E:
	break;
    case NEXUS_DC_FORMAT_CRAYC90:
    {
	nexus_byte_t *place = buffer;
	int i;

	for (i = 0; i < count; i++)
	{
	    if (*place & 0x38)
	    {
		/* exponent doesn't fit */
		result = i;
		break;
	    }
	}
	break;
    }
    case NEXUS_DC_FORMAT_UNKNOWN:
	result = 0;
	break;
    }
    return(result);
}
/* nexus_dc_check_lost_precision_double() */

/*
 * nexus_dc_is_native_long_long()
 */
int nexus_dc_is_native_long_long(int format)
{
    if ((format == NEXUS_DC_FORMAT_32BIT_BE)
	|| (format == NEXUS_DC_FORMAT_64BIT_BE)
        || (format == NEXUS_DC_FORMAT_JAVA)
        || (format == NEXUS_DC_FORMAT_CRAYC90)
        || (format == NEXUS_DC_FORMAT_CRAYT3E))
        return(NEXUS_TRUE);
    else
        return(NEXUS_FALSE);
}
/* nexus_dc_is_native_long_long() */


/*
 * nexus_dc_get_long_long()
 */
void nexus_dc_get_long_long(nexus_byte_t **buffer,
                       long long *data,
                       unsigned long count,
                       int format)
{
    nexus_byte_t *dst = (nexus_byte_t *) data;
    nexus_byte_t *src = (nexus_byte_t *) *buffer;
    int i;

    switch(format)
    {
    case NEXUS_DC_FORMAT_32BIT_LE:
    case NEXUS_DC_FORMAT_64BIT_LE:
        /* byte swap */
        for (i = 0; i < count; i++)
        {
            dst[0] = src[7];
            dst[1] = src[6];
            dst[2] = src[5];
            dst[3] = src[4];
            dst[4] = src[3];
            dst[5] = src[2];
            dst[6] = src[1];
            dst[7] = src[0];
            src += 8;
            dst += 8;
        }
        *buffer += count * 8;
        break;
    case NEXUS_DC_FORMAT_32BIT_BE:
    case NEXUS_DC_FORMAT_64BIT_BE:
    case NEXUS_DC_FORMAT_JAVA:
    case NEXUS_DC_FORMAT_CRAYC90:
    case NEXUS_DC_FORMAT_CRAYT3E:
        memcpy(data, *buffer, count * 8);
        *buffer += count * 8;
        break;
    case NEXUS_DC_FORMAT_UNKNOWN:
        /* DUNNO!!! */
        break;
    }
} /* nexus_dc_get_long_long() */


/*
 * nexus_dc_check_lost_precision_long_long()
 */
int nexus_dc_check_lost_precision_long_long(nexus_byte_t *buffer,
                                       unsigned long count,
                                       int format)
{
    return(-1);
} /* nexus_dc_check_lost_precision_long_long() */


/*
 * nexus_dc_is_native_u_long_long()
 */
int nexus_dc_is_native_u_long_long(int format)
{
    if ((format == NEXUS_DC_FORMAT_32BIT_BE)
	|| (format == NEXUS_DC_FORMAT_64BIT_BE)
        || (format == NEXUS_DC_FORMAT_CRAYC90)
        || (format == NEXUS_DC_FORMAT_CRAYT3E))
        return(NEXUS_TRUE);
    else
        return(NEXUS_FALSE);
}
/* nexus_dc_is_native_u_long_long() */


/*
 * nexus_dc_get_u_long_long()
 */
void nexus_dc_get_u_long_long(nexus_byte_t **buffer,
                         unsigned long long *data,
                         unsigned long count,
                         int format)
{
    nexus_byte_t *dst = (nexus_byte_t *) data;
    nexus_byte_t *src = (nexus_byte_t *) *buffer;
    int i;

    switch(format)
    {
    case NEXUS_DC_FORMAT_32BIT_LE:
    case NEXUS_DC_FORMAT_64BIT_LE:
        /* byte swap */
        for (i = 0; i < count; i++)
        {
            dst[0] = src[7];
            dst[1] = src[6];
            dst[2] = src[5];
            dst[3] = src[4];
            dst[4] = src[3];
            dst[5] = src[2];
            dst[6] = src[1];
            dst[7] = src[0];
            src += 8;
            dst += 8;
        }
        *buffer += count * 8;
        break;
    case NEXUS_DC_FORMAT_32BIT_BE:
    case NEXUS_DC_FORMAT_64BIT_BE:
    case NEXUS_DC_FORMAT_JAVA:
    case NEXUS_DC_FORMAT_CRAYC90:
    case NEXUS_DC_FORMAT_CRAYT3E:
        memcpy(data, *buffer, count * 8);
        *buffer += count * 8;
        break;
    case NEXUS_DC_FORMAT_UNKNOWN:
        /* DUNNO!!! */
        break;
    }
}
/* nexus_dc_get_u_long_long() */


/*
 * nexus_dc_check_lost_precision_u_long_long()
 */
int nexus_dc_check_lost_precision_u_long_long(nexus_byte_t *buffer,
                                         unsigned long count,
                                         int format)
{
    if (format == NEXUS_DC_FORMAT_JAVA)
    {
        int i;

        for (i = 0; i < count; i++)
        {
            if (buffer[(i * 8) + 0] & 0x80)
                return(i);
        }
    }
    return(-1);
}
/* nexus_dc_check_lost_precision_u_long_long() */

