
#include "globus_common.h"

typedef globus_result_t (* test_func_t)( char ** );

typedef struct testpar_s
{
    globus_bool_t         should_succeed;
    test_func_t           test_func;
    char *                install_path;
    char *                deploy_path;
} testpar_t;


globus_result_t
get_config_content( char** bufp )
{
    char*  p = *bufp;
    return globus_common_get_attribute_from_config_file( 
	p,
	GLOBUS_INSTALL_PATH_SH_LOCATION,
	"GLOBUS_INSTALL_PATH",
	bufp);
}

#define Y GLOBUS_TRUE
#define N GLOBUS_FALSE
/*
 * NOTE: when changing back so that GLOBUS_INSTALL_PATH not being defined
 *       is an error, change the definition of "X" to N
 */
#define X N

#define install globus_common_install_path
#define deploy  globus_common_deploy_path
#define service globus_common_services_path
#define tools   globus_common_tools_path
#define config  get_config_content

static testpar_t tests[]
= { /*  0 */ { Y, install, GLOBUS_PREFIX, GLOBUS_NULL },
	     { Y, install, "foobar", GLOBUS_NULL },   /* no reality check... */
	     { X, install, "", GLOBUS_NULL },         /* empty string        */
	     { X, install, GLOBUS_NULL, GLOBUS_NULL },/* not defined         */

	     { Y, deploy,  GLOBUS_NULL, GLOBUS_PREFIX },
    /*  5 */ { Y, deploy,  GLOBUS_NULL, "foobar" },
	     { N, deploy,  GLOBUS_NULL, "" },
	     { N, deploy,  GLOBUS_NULL, GLOBUS_NULL },

	     { Y, service, GLOBUS_PREFIX, GLOBUS_NULL },
	     { Y, service, "foobar", GLOBUS_NULL },
    /* 10 */ { X, service, "", GLOBUS_NULL },
	     { X, service, GLOBUS_NULL, GLOBUS_NULL },

	     { Y, tools  , GLOBUS_PREFIX, GLOBUS_NULL },
	     { Y, tools  , "foobar", GLOBUS_NULL },
	     { X, tools  , "", GLOBUS_NULL },
    /* 15 */ { X, tools  , GLOBUS_NULL, GLOBUS_NULL },

	     { Y, config , GLOBUS_NULL, "./path_tests/test1" },
	     { Y, config , GLOBUS_NULL, "./path_tests/test2" },
	     { X, config , GLOBUS_NULL, "./path_tests/test3" },
	     { N, config , GLOBUS_NULL, "./path_tests/test4" },
    /* 20 */ { N, config , GLOBUS_NULL, "./path_tests/test5" },
	     { Y, config , GLOBUS_NULL, "./path_tests/test6" },
	     { Y, config , GLOBUS_NULL, "./path_tests/test7" }
};

static int exit_code = 0;

void do_test(int counter, testpar_t* test, int verbose)
{
    globus_result_t  res;
    char *           p;
    char *           q;
    
    p = GLOBUS_NULL;

    globus_libc_unsetenv("GLOBUS_INSTALL_PATH");
    globus_libc_unsetenv("GLOBUS_DEPLOY_PATH");

    if (test->install_path)
	globus_libc_setenv("GLOBUS_INSTALL_PATH",
			   test->install_path,
			   GLOBUS_TRUE);

    if (test->deploy_path)
	globus_libc_setenv("GLOBUS_DEPLOY_PATH",
			   test->deploy_path,
			   GLOBUS_TRUE);

    if (test->test_func == config)
	p = test->deploy_path;

    res = test->test_func( &p );

    #define checknull(Q) ( (q=(Q)) ? q : "NULL")
    #define checkbool(Q) ((Q) ? "Yes" : "No ")

    if (verbose)
    {
	globus_libc_printf(
	    "Test %2d:  should succeed = %s result =(%ld) [%s] message = %s\n",
	    counter,
	    checkbool(test->should_succeed),
	    (long)(res),
	    checknull(p),
	    checknull(globus_object_printable_to_string(globus_error_get(res)))
	    );
    }

    if ((res==GLOBUS_SUCCESS && !test->should_succeed) ||
	(res!=GLOBUS_SUCCESS && test->should_succeed)   )
    {
	globus_libc_fprintf(stderr, "test %d failed\n", counter);
	exit_code = 1;
    }

    if (p)
	globus_free(p);
	   
}


int main(int argc, char *argv[])
{
    int               i, n_tests, verbose;

    n_tests = sizeof(tests) / (sizeof(testpar_t));

    globus_module_activate(GLOBUS_COMMON_MODULE);

    verbose = (argc>1 && (0==strcmp(argv[1],"-verbose")));

    for (i=0; i<n_tests; i++)
    {
	do_test(i, &tests[i], verbose);
    }

    globus_module_deactivate(GLOBUS_COMMON_MODULE);

    return exit_code;
}

