/****************************************************/
/* File : grid-info-num-procs.c                           */
/* Purpose: Via sysconf, determines the number of   */
/*          processors on the current host          */
/****************************************************/

#include "grid_info_config.h"

#include <stdio.h>
#include <unistd.h>


#undef NUM_PROC
/* On each machine type the nomenclature for
   flags to sysconf changes.  Map the correct
   flag onto NUM_PROC
*/


#if TARGET_ARCH_SOLARIS || TARGET_ARCH_AIX
# define NUM_PROC _SC_NPROCESSORS_ONLN
#endif

#if TARGET_ARCH_IRIX
# define NUM_PROC _SC_NPROC_ONLN
#endif


#if TARGET_ARCH_CRAYT3E           /*  TARGET_ARCH_UNICOS    ??  */
# define NUM_PROC _SC_CRAY_NCPU
#endif

#if TARGET_ARCH_OSF1
# define NUM_PROC _SC_NPROCESSORS_CONF
#endif

#if defined(TARGET_ARCH_HPUX11)
/*
 HPUX 11 does not provide sysinfo. pstat does not return
 proper cpu count information on HPUX 10
 */
#include <sys/param.h>
#include <sys/pstat.h>
#endif


int main (void) {
#if defined(TARGET_ARCH_HPUX11)
  {
    struct pst_dynamic buf;
    int rc;
    size_t elemsize=sizeof(struct pst_dynamic);
    size_t elemcount=1U;
    int index=0;

    rc = pstat_getdynamic(&buf,
                          elemsize,
                          elemcount,
			  index);

    printf("%d", (rc==-1) ? 1 : buf.psd_proc_cnt); 
  }
#elif defined(TARGET_ARCH_HPUX)
  {
    FILE *pipe;
    pipe = popen("sysinfo -cpu_count", "w");
    if (pipe!=NULL) pclose (pipe); /* command ran */
    else fprintf (stdout, "1");
  }
#elif defined(NUM_PROC)
    fprintf(stdout, "%d", sysconf(NUM_PROC));
#else
    fprintf(stdout, "1");
#endif
  exit(0); 
}




/**************************************************

Commands tolookfor
sysconf
sysinfo
sysdef
fpversion


CRAY3TE:

sysconf | grep ...

--

     long sysconf (int name);
     _SC_CRAY_NCPU                 The number of CPUs currently available.


======

IRIX:

long sysinfo (int command, char *buf, long count);

  _MIPS_SI_NUM_PROCESSORS
  _MIPS_SI_AVAIL_PROCESSORS

--

long sysconf(int name);

  _SC_NPROC_ONLN 

--

sysconf NPROC_ONLN


---
SP-UX


sysinfo -cpu_count


--
HP-UX

?????

---

AIX

  long int sysconf (Name)

  _SC_NPROCESSORS_ONLN

**************************************************/


