
#include <lber.h>
#include "ldap.h"
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <String.h>

void PrintEntry(LDAP *ldap_server, LDAPMessage* entry) {

    char *a, *dn;
    BerElement *ber;
    char** values;
    int numValues;
    int i;

    dn = ldap_get_dn(ldap_server,entry);
    cout << dn << ":" << endl;
    delete dn;

    for (a = ldap_first_attribute(ldap_server,entry,&ber); a != NULL;
	 a = ldap_next_attribute(ldap_server,entry,ber) ) {

      values = ldap_get_values(ldap_server,entry,a);
      numValues = ldap_count_values(values);

      cout << "\t" << a << "(" << numValues << "):"; 
      for(i=0;i<numValues;i++) {
	cout << " " << values[i];
      }
      ldap_value_free(values);
      cout << endl;
    }
    
    cout << endl;
}

void GetNamesFromMessage(LDAP *ldap_server, LDAPMessage* entry,
			 String& distName, String& hostName) {

  char *a, *dn;
  BerElement *ber;
  char** values;
  int numValues;
  int i;

  dn = ldap_get_dn(ldap_server,entry);
  distName = dn;
  delete dn;

  for (a = ldap_first_attribute(ldap_server,entry,&ber); a != NULL;
       a = ldap_next_attribute(ldap_server,entry,ber)) {

    values = ldap_get_values(ldap_server,entry,a);
    numValues = ldap_count_values(values);

    if (!strcmp(a,"hn")) {
      hostName = values[0];
      return;
    }
  }
}


void GetLoadAvg(String hostName, char** loads) {

  FILE *upfp;
  char line[129];
  char load[7];
  int i,j,k;
  char command[1024];

  strcpy(command,"rsh ");
  strcat(command,hostName);
  strcat(command," uptime > /tmp/uptime.out");

  system(command);

  /* read uptime output */

  upfp = fopen("/tmp/uptime.out","r");
  if (fgets(line, 128, upfp) == NULL) {
    printf("Error reading uptime\n");
    exit(1);
  }
  fclose(upfp);

  /* replace ',' with ' ' to make life easier */

  for(i=0;i<strlen(line);i++) {
    if (line[i] == ',') {
      line[i] = ' ';
    }
  }

  //puts(line);

  /* pick the three loads off the string */

  /* step backward from the end until a ':' is found */

  for(i=strlen(line)-1;line[i] != ':';i--) {}

  i++;

  for(k=0;k<3;k++) {

    /* find first character in the load */

    for(;line[i] == ' ';i++) {}

    /* copy into load string */

    j=0;
    while ((line[i] != ' ') && (line[i] != '\n')) {
      load[j] = line[i];
      i++;
      j++;
    }
    load[j] = '\0';

    loads[k] = new char[strlen(load)+1];
    strcpy(loads[k],load);

  }

}


GetNames(String*& distName, String*& hostName, int& numNames) {

  LDAP *ldap_server;
  LDAPMessage* reply;
  LDAPMessage* entry;
  char* searchString;
  String* temp;
  int allocNames=0;
  int i;

  delete distName;
  delete hostName;
  numNames=0;

  //cout << "opening..." << endl;

  if ((ldap_server = ldap_open("globus.org",389)) == NULL) {
    ldap_perror(ldap_server,"ldap_open");
    exit(1);
  }

  //cout << "binding..." << endl;

  if (ldap_simple_bind_s(ldap_server,"","") != LDAP_SUCCESS) {
    ldap_perror(ldap_server,"ldap_simple_bind_s");
    exit(1);
  }

  //cout << "searching for host names..." << endl;

  searchString = "(accessMethod=Interactive)";

  if (ldap_search_s(ldap_server,"o=Argonne National Laboratory,o=Globus,c=US",
		    LDAP_SCOPE_SUBTREE, searchString,NULL,0,&reply)
      != LDAP_SUCCESS) {
    ldap_perror(ldap_server,"ldap_search");
    exit(1);
  }

  //cout << "parsing reply..." << endl;

  for(entry=ldap_first_entry(ldap_server,reply);entry!=NULL;
      entry=ldap_next_entry(ldap_server,entry)) {

    if (numNames == allocNames) {
      temp = hostName;
      allocNames += 10;
      hostName = new String[allocNames];
      for(i=0;i<numNames;i++) {
	hostName[i] = temp[i];
      }
      temp = distName;
      allocNames += 10;
      distName = new String[allocNames];
      for(i=0;i<numNames;i++) {
	distName[i] = temp[i];
      }
    }
    GetNamesFromMessage(ldap_server,entry,distName[numNames],
			hostName[numNames]);
    numNames++;

  }

  /*
  cout << "found " << numNames << " names:" << endl;
  for(i=0;i<numNames;i++) {
    cout << "\t" << hostName[i] << "\t" << distName[i] << endl;
  }
  */

  //cout << "unbinding..." << endl;

  ldap_unbind(ldap_server);

}

void UpdateLoad(char* dn, char** load) {

  LDAP *ldap_server;
  LDAPMod *mod,**mods;
  int i;

  if ((ldap_server = ldap_open("globus.org",389)) == NULL) {
    ldap_perror(ldap_server,"ldap_open");
    exit(1);
  }

  if (ldap_simple_bind_s(ldap_server,"cn=Directory Manager, o=Globus, c=US",
			 "WWWadmin") != LDAP_SUCCESS) {
    ldap_perror(ldap_server,"ldap_simple_bind_s");
    exit(1);
  }

  mods = new LDAPMod*[4];
  mods[3] = NULL;

  mod = new LDAPMod;
  mod->mod_op = LDAP_MOD_REPLACE;
  mod->mod_type = "cpuload1";
  mod->mod_vals.modv_strvals = new char*[2];
  mod->mod_vals.modv_strvals[0] = load[0];
  mod->mod_vals.modv_strvals[1] = NULL;
  mods[0] = mod;

  mod = new LDAPMod;
  mod->mod_op = LDAP_MOD_REPLACE;
  mod->mod_type = "cpuload5";
  mod->mod_vals.modv_strvals = new char*[2];
  mod->mod_vals.modv_strvals[0] = load[1];
  mod->mod_vals.modv_strvals[1] = NULL;
  mods[1] = mod;

  mod = new LDAPMod;
  mod->mod_op = LDAP_MOD_REPLACE;
  mod->mod_type = "cpuload15";
  mod->mod_vals.modv_strvals = new char*[2];
  mod->mod_vals.modv_strvals[0] = load[2];
  mod->mod_vals.modv_strvals[1] = NULL;
  mods[2] = mod;

  if (ldap_modify_s(ldap_server,dn,mods)) {
    ldap_perror(ldap_server,"ldap_modify");
    exit(1);
  }

  delete [] mods[0]->mod_vals.modv_strvals;
  delete [] mods[1]->mod_vals.modv_strvals;
  delete [] mods[2]->mod_vals.modv_strvals;
  delete [] mods;

  ldap_unbind(ldap_server);


}

void UpdateLoads(String* distName, String* hostName, int numNames) {

  char dn[1024];
  char** load;
  int i;

  for(i=0;i<numNames;i++) {
    load = new char*[3];
    strcpy(dn,distName[i].chars());
    GetLoadAvg(hostName[i],load);
    UpdateLoad(dn,load);

    cout << hostName[i] << " " << load[0] << " " << load[1] << " "
	 << load[2] << endl;

    delete load;
  }
}

main(int argc, char** argv) {

  String* distName;
  String* hostName;
  int numNames;
  long curTime, nameReadTime, updateStart;

  while(1) {
    nameReadTime = time(NULL);
    GetNames(distName,hostName,numNames);
    curTime = time(NULL);
    while(curTime < nameReadTime + 60 * 60) {
      updateStart = time(NULL);
      UpdateLoads(distName,hostName,numNames);
      curTime = time(NULL);
      if (curTime - updateStart < 60 * 5) {
	sleep(60 * 5 - (curTime - updateStart));
      }
    }
  }
}
