/*
  script connects to MDS server. 

  for 

  dn = "hn=spnode009.mcs.anl.gov,o=Argonne National Laboratory,o=Globus,c=US";

  it replaces the current value of the attribute rm to

  "mn=Workstation Resource Manager, o=Argonne National Lab, o=Globus, c=US"
*/


#include <lber.h>
#include "ldap.h"
#include <iostream.h>
#include <stdio.h>

void PrintEntry(LDAP *ldap_server, LDAPMessage* entry) {

    char *a, *dn;
    BerElement *ber;
    char** values;
    int numValues;
    int i;

    dn = ldap_get_dn(ldap_server,entry);
    cout << dn << ":" << endl;
    delete dn;

    for (a = ldap_first_attribute(ldap_server,entry,&ber); a != NULL;
	 a = ldap_next_attribute(ldap_server,entry,ber) ) {

      values = ldap_get_values(ldap_server,entry,a);
      numValues = ldap_count_values(values);

      cout << "\t" << a << "(" << numValues << "):"; 
      for(i=0;i<numValues;i++) {
	cout << " " << values[i];
      }
      ldap_value_free(values);
      cout << endl;
    }
    
    cout << endl;
}

main(int argc, char** argv) {

  LDAP *ldap_server;
  int ret;
  int rc;
  int matches;
  int first;
  LDAPMessage* reply;
  LDAPMessage* entry;

  cout << "opening..." << endl;

  if ((ldap_server = ldap_open("globus.org",389)) == NULL) {
    ldap_perror(ldap_server,"ldap_open");
    exit(1);
  }

  cout << "binding..." << endl;

  //  if ((ret = ldap_simple_bind_s(ldap_server,"",""))
  if ((ret = ldap_simple_bind_s(ldap_server,
v				"cn=Directory Manager,o=Globus,c=US",
				"WWWadmin")) != LDAP_SUCCESS) {
    ldap_perror(ldap_server,"ldap_simple_bind_s");
    exit(1);
  }

  cout << "modifying..." << endl;

  char* dn;
  LDAPMod *mod,**mods;

  mods = new LDAPMod*[2];
  mods[1] = NULL;
  mod = new LDAPMod;
  mod->mod_op = LDAP_MOD_REPLACE;
  mod->mod_type = "rm";
  mod->mod_vals.modv_strvals = new char*[2];
  mod->mod_vals.modv_strvals[0] =
    "mn=Workstation Resource Manager, o=Argonne National Lab, o=Globus, c=US";
  mod->mod_vals.modv_strvals[1] = NULL;
  mods[0] = mod;


  dn = "hn=spnode009.mcs.anl.gov,o=Argonne National Laboratory,o=Globus,c=US";

  if (ldap_modify_s(ldap_server,dn,mods)) {
    ldap_perror(ldap_server,"ldap_modify");
    exit(1);
  }

  cout << "unbinding..." << endl;

  ldap_unbind(ldap_server);

}

